/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.MonolithJavaValueUtilsKt;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.platform.debugger.impl.ui.XDebuggerEntityConverter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/JvmDebuggerUtils;", "", "<init>", "()V", "findProxyFromContext", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDescriptorFromNode", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.java.debugger.impl"})
@ApiStatus.Internal
public final class JvmDebuggerUtils {
    @NotNull
    public static final JvmDebuggerUtils INSTANCE = new JvmDebuggerUtils();

    private JvmDebuggerUtils() {
    }

    @JvmStatic
    @Nullable
    public static final XDebugSessionProxy findProxyFromContext(@NotNull DebuggerContextImpl debuggerContext) {
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || (debuggerSession = debuggerSession.getXDebugSession()) == null) {
            return null;
        }
        DebuggerSession session = debuggerSession;
        return XDebuggerEntityConverter.asProxy((XDebugSession)session);
    }

    @JvmStatic
    @Nullable
    public static final ValueDescriptorImpl getDescriptorFromNode(@NotNull XValueContainerNode<?> node, @NotNull DebuggerContextImpl debuggerContext) {
        JavaValue javaValue;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        XDebugSessionProxy sessionProxy = JvmDebuggerUtils.findProxyFromContext(debuggerContext);
        if (sessionProxy != null) {
            XValueContainer xValueContainer = node.getValueContainer();
            XValue xValue = xValueContainer instanceof XValue ? (XValue)xValueContainer : null;
            if (xValue == null) {
                return null;
            }
            XValue xValue2 = xValue;
            javaValue = MonolithJavaValueUtilsKt.findJavaValue(xValue2, sessionProxy);
            if (javaValue == null) {
                return null;
            }
        } else {
            XValueContainer xValueContainer = node.getValueContainer();
            Intrinsics.checkNotNull((Object)xValueContainer, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.JavaValue");
            javaValue = (JavaValue)xValueContainer;
        }
        JavaValue javaValue2 = javaValue;
        return javaValue2.getDescriptor();
    }

    @JvmStatic
    @Nullable
    public static final ValueDescriptorImpl getDescriptorFromNode(@NotNull XValueContainerNode<?> node, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(e.getDataContext());
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
        return JvmDebuggerUtils.getDescriptorFromNode(node, debuggerContextImpl);
    }
}

