/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.JvmDropFrameActionHandler;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XExpressionDialog;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceEarlyReturnAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ForceEarlyReturnAction.$$$reportNull$$$0(0);
        }
        final Project project = e.getProject();
        final JavaStackFrame stackFrame = ForceEarlyReturnAction.getStackFrame(e);
        if (stackFrame == null || project == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        final StackFrameProxyImpl proxy = stackFrame.getStackFrameProxy();
        final ThreadReferenceProxyImpl thread = proxy.threadProxy();
        Objects.requireNonNull(debuggerContext.getManagerThread()).schedule(new DebuggerContextCommandImpl(this, debuggerContext, thread){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                Method method;
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    method = proxy.location().method();
                }
                catch (EvaluateException e) {
                    ForceEarlyReturnAction.showError(project, JavaDebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                if (DebuggerUtilsEx.isVoid(method)) {
                    ForceEarlyReturnAction.forceEarlyReturnWithFinally(thread.getVirtualMachine().mirrorOfVoid(), stackFrame, debugProcess, null);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> new XExpressionDialog(this, project, debugProcess.getXdebugProcess().getEditorsProvider(), "forceReturnValue", JavaDebuggerBundle.message((String)"dialog.title.return.value", (Object[])new Object[0]), stackFrame.getSourcePosition(), null){

                        protected void doOKAction() {
                            ForceEarlyReturnAction.evaluateAndReturn(project, stackFrame, debugProcess, this.getExpression(), (DialogWrapper)this);
                        }
                    }.show());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ForceEarlyReturnAction$1", "threadAction"));
            }
        });
    }

    private static void forceEarlyReturnWithFinally(final Value value, final JavaStackFrame frame, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        DebuggerInvocationUtil.invokeLaterAnyModality(() -> {
            if (JvmDropFrameActionHandler.evaluateFinallyBlocks(debugProcess.getProject(), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")), frame, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ForceEarlyReturnAction.forceEarlyReturn(value, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ForceEarlyReturnAction.showError(debugProcess.getProject(), JavaDebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ForceEarlyReturnAction$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            })) {
                return;
            }
            ForceEarlyReturnAction.forceEarlyReturn(value, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
        });
    }

    private static void forceEarlyReturn(final Value value, final ThreadReferenceProxyImpl thread, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                try {
                    debugProcess.startWatchingMethodReturn(thread);
                    thread.forceEarlyReturn(value);
                }
                catch (Exception e) {
                    ForceEarlyReturnAction.showError(debugProcess.getProject(), JavaDebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                DebuggerInvocationUtil.invokeLaterAnyModality(() -> {
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    debugProcess.getSession().stepInto(true, null);
                });
            }
        });
    }

    private static void evaluateAndReturn(final Project project, final JavaStackFrame stackFrame, final DebugProcessImpl debugProcess, XExpression expression, final DialogWrapper dialog) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(expression, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (result instanceof JavaValue) {
                        ForceEarlyReturnAction.forceEarlyReturnWithFinally(((JavaValue)result).getDescriptor().getValue(), stackFrame, debugProcess, dialog);
                    }
                }

                public void errorOccurred(@NlsContexts.DialogMessage @NotNull String errorMessage) {
                    if (errorMessage == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    ForceEarlyReturnAction.showError(project, JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ForceEarlyReturnAction$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, stackFrame.getSourcePosition());
        } else {
            ForceEarlyReturnAction.showError(project, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    private static void showError(Project project, @NlsContexts.DialogMessage String message) {
        JvmDropFrameActionHandler.showError(project, message, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ForceEarlyReturnAction.$$$reportNull$$$0(1);
        }
        boolean enable = false;
        JavaStackFrame stackFrame = ForceEarlyReturnAction.getStackFrame(e);
        if (stackFrame != null && stackFrame.getDescriptor().getUiIndex() == 0) {
            enable = stackFrame.getStackFrameProxy().getVirtualMachine().canForceEarlyReturn();
        }
        DebuggerUIUtil.setActionEnabled((AnActionEvent)e, (boolean)enable);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ForceEarlyReturnAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/ForceEarlyReturnAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/ForceEarlyReturnAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

