/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.rpc.HotSwapSource;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatistics;
import org.jetbrains.annotations.NotNull;

public class HotSwapAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            HotSwapAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        if (session != null && session.isAttached()) {
            HotSwapStatistics.logHotSwapCalled((Project)project, (HotSwapSource)HotSwapSource.RELOAD_ALL);
            HotSwapUI.getInstance(project).reloadChangedClasses(session, DebuggerSettings.getInstance().COMPILE_BEFORE_HOTSWAP);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            HotSwapAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        e.getPresentation().setEnabled(session != null && HotSwapUIImpl.canHotSwap(session));
        boolean compile = DebuggerSettings.getInstance().COMPILE_BEFORE_HOTSWAP;
        String text = compile ? ActionsBundle.message((String)"action.Hotswap.and.compile.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Hotswap.text", (Object[])new Object[0]);
        String description = compile ? ActionsBundle.message((String)"action.Hotswap.and.compile.description", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Hotswap.description", (Object[])new Object[0]);
        e.getPresentation().setText(text);
        e.getPresentation().setDescription(description);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HotSwapAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/HotSwapAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/HotSwapAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

