/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImplKt;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/actions/InterruptThreadAction;", "Lcom/intellij/debugger/actions/DebuggerAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.java.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInterruptThreadAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterruptThreadAction.kt\ncom/intellij/debugger/actions/InterruptThreadAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n12033#2,10:92\n14060#2:102\n14061#2:104\n12043#2:105\n1#3:103\n*S KotlinDebug\n*F\n+ 1 InterruptThreadAction.kt\ncom/intellij/debugger/actions/InterruptThreadAction\n*L\n24#1:92,10\n24#1:102\n24#1:104\n24#1:105\n24#1:103\n*E\n"})
public final class InterruptThreadAction
extends DebuggerAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerTreeNodeImpl[] nodes = DebuggerAction.getSelectedNodes(e.getDataContext());
        if (nodes == null) {
            return;
        }
        DebuggerTreeNodeImpl[] $this$mapNotNull$iv = nodes;
        boolean $i$f$mapNotNull = false;
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ThreadReferenceProxyImpl it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            NodeDescriptorImpl descriptor = it.getDescriptor();
            if ((descriptor instanceof ThreadDescriptorImpl ? ((ThreadDescriptorImpl)descriptor).getThreadReference() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List threadsToInterrupt = (List)destination$iv$iv;
        if (threadsToInterrupt.isEmpty()) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(e.getDataContext());
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
        DebuggerContextImpl debuggerContext = debuggerContextImpl;
        DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        DebugProcessImpl debugProcess = debugProcessImpl;
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = debuggerContext.getManagerThread();
        if (debuggerManagerThreadImpl == null) {
            return;
        }
        DebuggerManagerThreadImpl managerThread = debuggerManagerThreadImpl;
        for (ThreadReferenceProxyImpl thread : threadsToInterrupt) {
            Companion.interruptThread(thread, debugProcess, managerThread);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerTreeNodeImpl[] selectedNodes = DebuggerAction.getSelectedNodes(e.getDataContext());
        boolean visible = false;
        boolean enabled = false;
        if (selectedNodes != null && selectedNodes.length > 0) {
            NodeDescriptorImpl threadDescriptor;
            visible = true;
            enabled = true;
            for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                threadDescriptor = selectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl) continue;
                visible = false;
                break;
            }
            if (visible) {
                for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                    NodeDescriptorImpl nodeDescriptorImpl = selectedNode.getDescriptor();
                    Intrinsics.checkNotNull((Object)nodeDescriptorImpl, (String)"null cannot be cast to non-null type com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl");
                    threadDescriptor = (ThreadDescriptorImpl)nodeDescriptorImpl;
                    if (!((ThreadDescriptorImpl)threadDescriptor).isFrozen() && !((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                    enabled = false;
                    break;
                }
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setText(JavaDebuggerBundle.messagePointer((String)"action.interrupt.thread.text", (Object[])new Object[0]));
        presentation2.setEnabledAndVisible(visible && enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/actions/InterruptThreadAction$Companion;", "", "<init>", "()V", "interruptThread", "", "thread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "managerThread", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "intellij.java.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void interruptThread(@NotNull ThreadReferenceProxyImpl thread, @NotNull DebugProcessImpl debugProcess, @NotNull DebuggerManagerThreadImpl managerThread) {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)managerThread, (String)"managerThread");
            DebuggerManagerThreadImplKt.executeOnDMT$default(managerThread, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(thread, debugProcess, null){
                int label;
                final /* synthetic */ ThreadReferenceProxyImpl $thread;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                {
                    this.$thread = $thread;
                    this.$debugProcess = $debugProcess;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                this.$thread.getThreadReference().interrupt();
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                Project project = this.$debugProcess.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                Project project2 = project;
                                NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                                String string = JavaDebuggerBundle.message((String)"thread.operation.interrupt.is.not.supported.by.vm", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                MessageType messageType = MessageType.INFO;
                                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                                notificationGroup.createNotification(string, messageType).notify(project2);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

