/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.RepairDebuggerViewAction;
import com.intellij.debugger.actions.SessionActionBase;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerDiagnosticsUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/debugger/actions/RepairDebuggerViewAction;", "Lcom/intellij/debugger/actions/SessionActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.java.debugger.impl"})
public final class RepairDebuggerViewAction
extends SessionActionBase
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerSession debuggerSession = this.debuggerSession(e);
        if (debuggerSession == null) {
            return;
        }
        DebuggerSession session = debuggerSession;
        DebugProcessImpl debugProcessImpl = session.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debugProcessImpl), (String)"getProcess(...)");
        DebugProcessImpl process = debugProcessImpl;
        process.getManagerThread().schedule(new DebuggerCommandImpl(process, session){
            final /* synthetic */ DebugProcessImpl $process;
            final /* synthetic */ DebuggerSession $session;
            {
                this.$process = $process;
                this.$session = $session;
                super(null, 1, null);
            }

            /*
             * WARNING - void declaration
             */
            protected void action() {
                SuspendContextImpl suspendContextImpl;
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                SuspendManager suspendManager = this.$process.getSuspendManager();
                Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"getSuspendManager(...)");
                SuspendManager suspendManager2 = suspendManager;
                List<SuspendContextImpl> eventContexts = suspendManager2.getEventContexts();
                Intrinsics.checkNotNull(eventContexts);
                Iterable $this$filter$iv = eventContexts;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(it.getSuspendPolicy() == 2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List suspendAllContexts = (List)destination$iv$iv;
                DebuggerDiagnosticsUtil.checkThreadsConsistency(this.$process, true);
                Iterable $this$filter$iv2 = eventContexts;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo22 = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!it.isEvaluating()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List evaluating = (List)destination$iv$iv2;
                if (!((Collection)evaluating).isEmpty()) {
                    this.$process.logError("May be a problem with hanged evaluation: " + evaluating);
                }
                actionPerformed.1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(actionPerformed.1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("All paused contexts: " + eventContexts);
                if (suspendAllContexts.size() > 1) {
                    void $this$filterTo$iv$iv3;
                    actionPerformed.1 $this$thisLogger$iv2 = this;
                    boolean $i$f$thisLogger2 = false;
                    Logger logger2 = Logger.getInstance(actionPerformed.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.error("A lot of suspend all contexts: " + suspendAllContexts);
                    Iterable $this$filter$iv3 = suspendAllContexts;
                    boolean $i$f$filter3 = false;
                    Iterable $i$f$filterTo22 = $this$filter$iv3;
                    Collection destination$iv$iv3 = new ArrayList<E>();
                    boolean $i$f$filterTo3 = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv3) {
                        SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv);
                        boolean bl = false;
                        if (!(it.getEventSet() != null)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List contextsWithEventSet = (List)destination$iv$iv3;
                    if (contextsWithEventSet.size() > 1) {
                        actionPerformed.1 $this$thisLogger$iv3 = this;
                        boolean $i$f$thisLogger3 = false;
                        Logger logger3 = Logger.getInstance(actionPerformed.1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                        logger3.error("A lot of suspend all contexts with event set: " + contextsWithEventSet);
                    }
                    suspendContextImpl = !((Collection)contextsWithEventSet).isEmpty() ? (SuspendContextImpl)((Object)contextsWithEventSet.get(0)) : (SuspendContextImpl)((Object)suspendAllContexts.get(0));
                } else if (!((Collection)suspendAllContexts).isEmpty()) {
                    suspendContextImpl = (SuspendContextImpl)((Object)suspendAllContexts.get(0));
                } else if (!((Collection)eventContexts).isEmpty()) {
                    actionPerformed.1 $this$thisLogger$iv4 = this;
                    boolean $i$f$thisLogger4 = false;
                    Logger logger4 = Logger.getInstance(actionPerformed.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
                    logger4.warn("Only thread-paused contexts available");
                    suspendContextImpl = eventContexts.get(0);
                } else {
                    actionPerformed.1 $this$thisLogger$iv5 = this;
                    boolean $i$f$thisLogger5 = false;
                    Logger logger5 = Logger.getInstance(actionPerformed.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getInstance(...)");
                    logger5.error("Cannot find a context to restore debugger view");
                    return;
                }
                SuspendContextImpl suspendContextToRestore = suspendContextImpl;
                DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(this.$session, suspendContextToRestore, suspendContextToRestore.getEventThread(), null);
                Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"createDebuggerContext(...)");
                DebuggerContextImpl restoredDebuggerContext = debuggerContextImpl;
                DebuggerInvocationUtil.invokeLater(this.$process.getProject(), () -> actionPerformed.1.action$lambda$3(this.$session, restoredDebuggerContext));
            }

            private static final void action$lambda$3(DebuggerSession $session, DebuggerContextImpl $restoredDebuggerContext) {
                $session.getContextManager().setState($restoredDebuggerContext, DebuggerSession.State.PAUSED, DebuggerSession.Event.PAUSE, null);
            }
        });
    }
}

