/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerAsync;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0082@\u00a2\u0006\u0002\u0010\n\u001a3\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0082\b\u001aD\u0010\u0013\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u00152\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u000e\b\u0004\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0011H\u0082\b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"acceptsFileType", "", "positionManager", "Lcom/intellij/debugger/PositionManager;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getSourcePositionAsync", "Lcom/intellij/debugger/SourcePosition;", "location", "Lcom/sun/jdi/Location;", "(Lcom/intellij/debugger/PositionManager;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkCacheEntry", "position", "className", "", "insideReadAction", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "callInReadAction", "T", "", "action", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nCompoundPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompoundPositionManager.kt\ncom/intellij/debugger/engine/CompoundPositionManagerKt\n*L\n1#1,313:1\n309#1,3:314\n*S KotlinDebug\n*F\n+ 1 CompoundPositionManager.kt\ncom/intellij/debugger/engine/CompoundPositionManagerKt\n*L\n299#1:314,3\n*E\n"})
public final class CompoundPositionManagerKt {
    private static final boolean acceptsFileType(PositionManager positionManager, FileType fileType) {
        if (fileType == null || fileType == UnknownFileType.INSTANCE) {
            return true;
        }
        return positionManager.isAcceptedFileType(fileType);
    }

    private static final Object getSourcePositionAsync(PositionManager positionManager, Location location, Continuation<? super SourcePosition> $completion) {
        if (positionManager instanceof PositionManagerAsync) {
            return ((PositionManagerAsync)positionManager).getSourcePositionAsync(location, $completion);
        }
        try {
            return ReadAction.nonBlocking(() -> CompoundPositionManagerKt.getSourcePositionAsync$lambda$0(positionManager, location)).executeSynchronously();
        }
        catch (Exception e) {
            Throwable throwable = DebuggerUtilsAsync.unwrap(e);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"unwrap(...)");
            throw throwable;
        }
    }

    private static final boolean checkCacheEntry(SourcePosition position, String className, Function1<? super Function0<Unit>, Unit> insideReadAction) {
        boolean $i$f$checkCacheEntry = false;
        boolean $i$f$callInReadAction = false;
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        insideReadAction.invoke((Object)new Function0<Unit>(result$iv, position, className){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ SourcePosition $position$inlined;
            final /* synthetic */ String $className$inlined;
            {
                this.$result = $result;
                this.$position$inlined = sourcePosition;
                this.$className$inlined = string;
            }

            public final void invoke() {
                boolean bl;
                Ref.ObjectRef objectRef = this.$result;
                boolean bl2 = false;
                PsiFile psiFile = this.$position$inlined.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile psiFile2 = psiFile;
                if (!psiFile2.isValid()) {
                    bl = false;
                } else {
                    String string = DebuggerUtilsEx.getAlternativeSourceUrl(this.$className$inlined, psiFile2.getProject());
                    if (string == null) {
                        bl = true;
                    } else {
                        String url = string;
                        VirtualFile file = psiFile2.getVirtualFile();
                        bl = file != null && Intrinsics.areEqual((Object)url, (Object)file.getUrl());
                    }
                }
                objectRef.element = bl;
            }
        });
        return (Boolean)result$iv.element;
    }

    private static final <T> T callInReadAction(Function1<? super Function0<Unit>, Unit> insideReadAction, Function0<? extends T> action) {
        boolean $i$f$callInReadAction = false;
        Ref.ObjectRef result = new Ref.ObjectRef();
        insideReadAction.invoke((Object)new Function0<Unit>(result, action){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function0<T> $action;
            {
                this.$result = $result;
                this.$action = $action;
            }

            public final void invoke() {
                this.$result.element = this.$action.invoke();
            }
        });
        return (T)result.element;
    }

    private static final SourcePosition getSourcePositionAsync$lambda$0(PositionManager $positionManager, Location $location) {
        return $positionManager.getSourcePosition($location);
    }

    public static final /* synthetic */ boolean access$acceptsFileType(PositionManager positionManager, FileType fileType) {
        return CompoundPositionManagerKt.acceptsFileType(positionManager, fileType);
    }

    public static final /* synthetic */ Object access$getSourcePositionAsync(PositionManager positionManager, Location location, Continuation $completion) {
        return CompoundPositionManagerKt.getSourcePositionAsync(positionManager, location, (Continuation<? super SourcePosition>)$completion);
    }
}

