/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.ThreadModelState;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.containers.UtilKt;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J'\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0018\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 H\u0003J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0007R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lcom/intellij/debugger/engine/DebuggerDiagnosticsUtil;", "", "<init>", "()V", "recursionTracker", "Ljava/lang/ThreadLocal;", "", "getRecursionTracker$annotations", "getRecursionTracker", "()Ljava/lang/ThreadLocal;", "needAnonymizedReports", "checkThreadsConsistency", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "reportDiffWithRealCounter", "getThreadState", "Lcom/intellij/debugger/engine/ThreadModelState;", "thread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "getAttachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "first", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lcom/intellij/openapi/diagnostic/Attachment;)[Lcom/intellij/openapi/diagnostic/Attachment;", "createStateAttachments", "", "createThreadsAttachment", "getDebuggerStateOverview", "noErr", "", "f", "Lkotlin/Function0;", "getEventSetClasses", "eventSet", "Lcom/sun/jdi/event/EventSet;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nDebuggerDiagnosticsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerDiagnosticsUtil.kt\ncom/intellij/debugger/engine/DebuggerDiagnosticsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,268:1\n777#2:269\n873#2,2:270\n777#2:272\n873#2,2:273\n777#2:275\n873#2,2:276\n777#2:278\n873#2,2:279\n1807#2,3:282\n777#2:285\n873#2,2:286\n1586#2:288\n1661#2,3:289\n23#3:281\n*S KotlinDebug\n*F\n+ 1 DebuggerDiagnosticsUtil.kt\ncom/intellij/debugger/engine/DebuggerDiagnosticsUtil\n*L\n61#1:269\n61#1:270,2\n69#1:272\n69#1:273,2\n95#1:275\n95#1:276,2\n108#1:278\n108#1:279,2\n172#1:282,3\n245#1:285\n245#1:286,2\n266#1:288\n266#1:289,3\n155#1:281\n*E\n"})
public final class DebuggerDiagnosticsUtil {
    @NotNull
    public static final DebuggerDiagnosticsUtil INSTANCE = new DebuggerDiagnosticsUtil();
    @NotNull
    private static final ThreadLocal<Boolean> recursionTracker = new ThreadLocal();

    private DebuggerDiagnosticsUtil() {
    }

    @NotNull
    public static final ThreadLocal<Boolean> getRecursionTracker() {
        return recursionTracker;
    }

    @JvmStatic
    public static /* synthetic */ void getRecursionTracker$annotations() {
    }

    @JvmStatic
    public static final boolean needAnonymizedReports() {
        return !ApplicationManager.getApplication().isInternal();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void checkThreadsConsistency(@NotNull DebugProcessImpl process, boolean reportDiffWithRealCounter) {
        ThreadModelState state;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        SuspendManager suspendManager = process.getSuspendManager();
        Intrinsics.checkNotNull((Object)suspendManager, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendManagerImpl");
        SuspendManagerImpl suspendManager2 = (SuspendManagerImpl)suspendManager;
        ThreadBlockedMonitor.InvocationWatcherNewImpl invocationWatching = process.myThreadBlockedMonitor.myInvocationWatching;
        Collection<ThreadReferenceProxyImpl> collection = VirtualMachineProxyImpl.getCurrent().getEvenDirtyAllThreads();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getEvenDirtyAllThreads(...)");
        Collection<ThreadReferenceProxyImpl> allThreads = collection;
        List<SuspendContextImpl> allContexts = suspendManager2.getEventContextsAsItIs();
        Intrinsics.checkNotNull(allContexts);
        Iterable $this$filter$iv = allContexts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.getSuspendPolicy() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suspendAllContexts = (List)destination$iv$iv;
        List problems = new ArrayList();
        for (ThreadReferenceProxyImpl threadProxy : allThreads) {
            int realSuspendCount;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv;
            if (threadProxy.isIgnoreModelSuspendCount()) continue;
            Iterable $this$filter$iv2 = allContexts;
            boolean $i$f$filter2 = false;
            element$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv2);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)threadProxy);
                if (!it.suspends(threadProxy)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List suspendingContexts = (List)destination$iv$iv2;
            int resumedByWatching = invocationWatching != null && suspendingContexts.contains((Object)invocationWatching.mySuspendAllContext) ? 1 : 0;
            int threadModelSuspendCount = threadProxy.getWholeSuspendModelNumber();
            if (suspendingContexts.size() - resumedByWatching != threadModelSuspendCount) {
                Object s = invocationWatching != null ? "RBW=" + resumedByWatching + ", " : "";
                ((Collection)problems).add("Error in model for " + threadProxy + ": " + (String)s + "model count = " + threadModelSuspendCount + ", suspending contexts: " + suspendingContexts);
            }
            if (reportDiffWithRealCounter && threadModelSuspendCount != (realSuspendCount = threadProxy.getSuspendCount())) {
                ((Collection)problems).add("Error in model for " + threadProxy + ": model count = " + threadModelSuspendCount + ", real count = " + realSuspendCount);
            }
            Intrinsics.checkNotNull((Object)threadProxy);
            state = DebuggerDiagnosticsUtil.getThreadState(threadProxy);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    if (!(!((Collection)suspendingContexts).isEmpty())) break;
                    ((Collection)problems).add("Thread " + threadProxy + " is considered as evaluating, but has suspending contexts: " + suspendingContexts);
                    break;
                }
                case 2: {
                    SuspendContextImpl it;
                    void $this$filterTo$iv$iv3;
                    List<SuspendContextImpl> list = suspendManager2.getPausedContexts();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getPausedContexts(...)");
                    Iterable $this$filter$iv3 = list;
                    boolean $i$f$filter3 = false;
                    Iterable bl = $this$filter$iv3;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                        it = (SuspendContextImpl)((Object)element$iv$iv3);
                        boolean bl2 = false;
                        if (!it.suspends(threadProxy)) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    List pausedSuspendingContexts = (List)destination$iv$iv3;
                    if (!((Collection)pausedSuspendingContexts).isEmpty()) {
                        ((Collection)problems).add("Thread " + threadProxy + " is considered as resumed explicitly, but has paused suspending contexts: " + pausedSuspendingContexts);
                    }
                    if (!suspendAllContexts.isEmpty()) break;
                    ((Collection)problems).add("Thread " + threadProxy + " is considered as resumed explicitly, but no one suspend-all context is found");
                    break;
                }
                case 3: {
                    SuspendContextImpl it;
                    if (!((Collection)suspendAllContexts).isEmpty()) {
                        ((Collection)problems).add("Thread " + threadProxy + " is considered as running, but there are suspend-all contexts: " + suspendAllContexts);
                    }
                    Iterable $this$filter$iv3 = allContexts;
                    boolean $i$f$filter4 = false;
                    Iterable $this$filterTo$iv$iv3 = $this$filter$iv3;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                        it = (SuspendContextImpl)((Object)element$iv$iv3);
                        boolean bl = false;
                        if (!(it.getSuspendPolicy() == 1 && Intrinsics.areEqual((Object)it.getEventThread(), (Object)threadProxy) && !it.isResumed())) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    List suspendThreadContexts = (List)destination$iv$iv3;
                    if (!(!((Collection)suspendThreadContexts).isEmpty())) break;
                    ((Collection)problems).add("Thread " + threadProxy + " is considered as running, but there are suspend-thread contexts for it: " + suspendThreadContexts);
                }
            }
        }
        for (SuspendContextImpl context : allContexts) {
            EvaluationContextImpl evaluationContext;
            Set<ThreadReferenceProxyImpl> resumedThreads;
            if (context.getSuspendPolicy() == 2 && (resumedThreads = context.myResumedThreads) != null && !((Collection)resumedThreads).isEmpty()) {
                for (ThreadReferenceProxyImpl threadProxy : resumedThreads) {
                    state = DebuggerDiagnosticsUtil.getThreadState(threadProxy);
                    if (state == ThreadModelState.EVALUATING || state == ThreadModelState.EXPLICITLY_RESUMED) continue;
                    ((Collection)problems).add("Invalid state of thread " + threadProxy + ": " + state);
                }
            }
            if (context.getSuspendPolicy() == 1 && (resumedThreads = context.myResumedThreads) != null && !((Collection)resumedThreads).isEmpty()) {
                ((Collection)problems).add("Suspend thread context with explicitly resumed threads: " + resumedThreads);
            }
            if (!context.isEvaluating()) continue;
            if (context.getEvaluationContext() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            ThreadReferenceProxyImpl threadForEvaluation = evaluationContext.getThreadForEvaluation();
            if (threadForEvaluation != null) {
                if (threadForEvaluation.isEvaluating()) continue;
                ((Collection)problems).add("In " + context + " found " + evaluationContext + " with " + threadForEvaluation + " as thread but it is not evaluating");
                continue;
            }
            ((Collection)problems).add("No thread for evaluation for evaluating " + context);
        }
        if (!((Collection)problems).isEmpty()) {
            process.logError("Found " + problems.size() + " problems", new Attachment("Problems.txt", CollectionsKt.joinToString$default((Iterable)problems, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
            for (String problem : problems) {
                DebuggerDiagnosticsUtil $this$thisLogger$iv = INSTANCE;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DebuggerDiagnosticsUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(problem);
            }
        }
    }

    @JvmStatic
    private static final ThreadModelState getThreadState(ThreadReferenceProxyImpl thread) {
        boolean bl;
        block6: {
            DebugProcessImpl debugProcessImpl = thread.getVirtualMachineProxy().getDebugProcess();
            Intrinsics.checkNotNull((Object)((Object)debugProcessImpl), (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
            SuspendManager suspendManager = debugProcessImpl.getSuspendManager();
            Intrinsics.checkNotNull((Object)suspendManager, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendManagerImpl");
            SuspendManagerImpl suspendManager2 = (SuspendManagerImpl)suspendManager;
            if (thread.isEvaluating()) {
                return ThreadModelState.EVALUATING;
            }
            if (suspendManager2.myExplicitlyResumedThreads.contains(thread)) {
                return ThreadModelState.EXPLICITLY_RESUMED;
            }
            List<SuspendContextImpl> list = suspendManager2.getEventContexts();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEventContexts(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it.getSuspendPolicy() == 2 || Intrinsics.areEqual((Object)it.getEventThread(), (Object)thread))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return ThreadModelState.STOPPED;
        }
        return ThreadModelState.RUNNING;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Attachment[] getAttachments(@NotNull DebugProcessImpl process, @Nullable Attachment first) {
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        if (!DebuggerManagerThreadImpl.Companion.isManagerThread()) {
            Intrinsics.checkNotNullExpressionValue((Object)Attachment.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return Attachment.EMPTY_ARRAY;
        }
        Attachment attachment = first;
        List paramAttachment = attachment != null ? CollectionsKt.listOf((Object)attachment) : CollectionsKt.emptyList();
        List result = CollectionsKt.plus((Collection)paramAttachment, (Iterable)DebuggerDiagnosticsUtil.createStateAttachments(process));
        for (Attachment attachment2 : result) {
            attachment2.setIncluded(true);
        }
        Collection collection = result;
        Intrinsics.checkNotNullExpressionValue((Object)Attachment.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (Attachment[])UtilKt.toArray((Collection)collection, (Object[])Attachment.EMPTY_ARRAY);
    }

    public static /* synthetic */ Attachment[] getAttachments$default(DebugProcessImpl debugProcessImpl, Attachment attachment, int n, Object object) {
        if ((n & 2) != 0) {
            attachment = null;
        }
        return DebuggerDiagnosticsUtil.getAttachments(debugProcessImpl, attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final List<Attachment> createStateAttachments(DebugProcessImpl process) {
        if (Intrinsics.areEqual((Object)recursionTracker.get(), (Object)true)) {
            return CollectionsKt.listOf((Object)new Attachment("Recursion_problem_detected_Just_dump.txt", DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)DebuggerDiagnosticsUtil::createStateAttachments$lambda$0))));
        }
        try {
            List list;
            recursionTracker.set(true);
            List $this$createStateAttachments_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createStateAttachments_u24lambda_u241.add(DebuggerDiagnosticsUtil.getDebuggerStateOverview(process));
            if (process.isAttached()) {
                $this$createStateAttachments_u24lambda_u241.add(DebuggerDiagnosticsUtil.createThreadsAttachment(process));
            }
            $this$createStateAttachments_u24lambda_u241.add(new Attachment("IDE_thread_dump.txt", DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)DebuggerDiagnosticsUtil::createStateAttachments$lambda$1$0))));
            List<SuspendContextImpl> list2 = process.getSuspendManager().getEventContexts();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getEventContexts(...)");
            $this$createStateAttachments_u24lambda_u241.add(new Attachment("context_detailed_information.txt", CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, DebuggerDiagnosticsUtil::createStateAttachments$lambda$1$1, (int)30, null)));
            list = CollectionsKt.build((List)list);
            return list;
        }
        finally {
            recursionTracker.remove();
        }
    }

    @JvmStatic
    private static final Attachment createThreadsAttachment(DebugProcessImpl process) {
        Object object;
        VirtualMachineProxyImpl virtualMachineProxyImpl = VirtualMachineProxyImpl.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"getCurrent(...)");
        VirtualMachineProxyImpl virtualMachine = virtualMachineProxyImpl;
        Collection<ThreadReferenceProxyImpl> collection = virtualMachine.allThreads();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"allThreads(...)");
        String threads = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, DebuggerDiagnosticsUtil::createThreadsAttachment$lambda$0, (int)30, null);
        String vmModelCount = "VM suspend model count = " + virtualMachine.getModelSuspendCount();
        if (process.myThreadBlockedMonitor.isInResumeAllMode()) {
            if (ThreadBlockedMonitor.isNewSuspendAllInvocationWatcher()) {
                ThreadBlockedMonitor.InvocationWatcherNewImpl invocationWatching;
                ThreadBlockedMonitor.InvocationWatcherNewImpl invocationWatcherNewImpl = invocationWatching = process.myThreadBlockedMonitor.myInvocationWatching;
                object = invocationWatcherNewImpl != null ? "Watcher for " + DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)() -> DebuggerDiagnosticsUtil.createThreadsAttachment$lambda$1(invocationWatcherNewImpl))) + " is active" : "some problem with watcher";
            } else {
                object = "old invocation watcher is using";
            }
        } else {
            object = "no suspend-all invocation watcher is activated";
        }
        String blockedThreadsInfo = object;
        return new Attachment("Application_threads_state.txt", vmModelCount + "\n" + blockedThreadsInfo + "\n" + threads);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final Attachment getDebuggerStateOverview(DebugProcessImpl process) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        SuspendManager suspendManager = process.getSuspendManager();
        Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"getSuspendManager(...)");
        SuspendManager suspendManager2 = suspendManager;
        DebuggerCommandImpl currentCommand = DebuggerManagerThreadImpl.Companion.getCurrentCommand();
        String currentCommandText = "Current command = " + currentCommand + "\n";
        SuspendContextCommandImpl suspendContextCommandImpl = currentCommand instanceof SuspendContextCommandImpl ? (SuspendContextCommandImpl)currentCommand : null;
        SuspendContextImpl currentSuspendContext = suspendContextCommandImpl != null ? suspendContextCommandImpl.getSuspendContext() : null;
        String currentSuspendContextText = "Current Command Suspend context = " + currentSuspendContext + "\n";
        Iterable iterable = Registry.Companion.getAll();
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RegistryValue it = (RegistryValue)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it.getKey(), (String)"debugger.", (boolean)false, (int)2, null) && it.isChangedFromDefault())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String registryInfo = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, DebuggerDiagnosticsUtil::getDebuggerStateOverview$lambda$1, (int)30, null);
        String content = registryInfo + currentCommandText + currentSuspendContextText + DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)() -> DebuggerDiagnosticsUtil.getDebuggerStateOverview$lambda$2(process))) + DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)() -> DebuggerDiagnosticsUtil.getDebuggerStateOverview$lambda$3(suspendManager2)));
        return new Attachment("Debugger_state_overview.txt", content);
    }

    @JvmStatic
    private static final String noErr(Function0<? extends Object> f) {
        try {
            return String.valueOf(f.invoke());
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getEventSetClasses(@NotNull EventSet eventSet) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)eventSet, (String)"eventSet");
        Iterable $this$map$iv = eventSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Event event = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getClass().getSimpleName());
        }
        return "[" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Attachment[] getAttachments(@NotNull DebugProcessImpl process) {
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        return DebuggerDiagnosticsUtil.getAttachments$default(process, null, 2, null);
    }

    private static final Object createStateAttachments$lambda$1$0() {
        return ThreadDumper.dumpThreadsToString();
    }

    private static final CharSequence createStateAttachments$lambda$1$1(SuspendContextImpl it) {
        return it.toAttachmentString();
    }

    private static final Object createStateAttachments$lambda$0() {
        return ThreadDumper.dumpThreadsToString();
    }

    private static final Object createThreadsAttachment$lambda$0$0(ThreadReferenceProxyImpl $it) {
        Intrinsics.checkNotNull((Object)$it);
        return DebuggerDiagnosticsUtil.getThreadState($it);
    }

    private static final CharSequence createThreadsAttachment$lambda$0(ThreadReferenceProxyImpl it) {
        return "(" + DebuggerDiagnosticsUtil.noErr((Function0<? extends Object>)((Function0)() -> DebuggerDiagnosticsUtil.createThreadsAttachment$lambda$0$0(it))) + ") " + it + ", model suspend counter = " + it.getWholeSuspendModelNumber() + ", real suspend counter = " + it.getSuspendCount();
    }

    private static final Object createThreadsAttachment$lambda$1(ThreadBlockedMonitor.InvocationWatcherNewImpl $invocationWatching) {
        return $invocationWatching.mySuspendAllContext;
    }

    private static final CharSequence getDebuggerStateOverview$lambda$1(RegistryValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + " = " + it.asString() + "\n";
    }

    private static final Object getDebuggerStateOverview$lambda$2(DebugProcessImpl $process) {
        return $process.getStateForDiagnostics();
    }

    private static final Object getDebuggerStateOverview$lambda$3(SuspendManager $suspendManager) {
        Intrinsics.checkNotNull((Object)$suspendManager, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendManagerImpl");
        return ((SuspendManagerImpl)$suspendManager).getStateForDiagnostics();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreadModelState.values().length];
            try {
                nArray[ThreadModelState.EVALUATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreadModelState.EXPLICITLY_RESUMED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreadModelState.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

