/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultSourcePositionProvider
extends SourcePositionProvider {
    @Override
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        DebugProcessImpl debugProcess;
        StackFrameProxyImpl frame;
        if (descriptor == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(2);
        }
        if ((frame = context.getFrameProxy()) == null) {
            return null;
        }
        if (descriptor instanceof FieldDescriptor) {
            return DefaultSourcePositionProvider.getSourcePositionForField((FieldDescriptor)descriptor, project, context, nearest);
        }
        if (descriptor instanceof LocalVariableDescriptor) {
            return DefaultSourcePositionProvider.getSourcePositionForLocalVariable(descriptor.getName(), project, context, nearest);
        }
        if (descriptor instanceof ArgumentValueDescriptorImpl) {
            Collection<String> names = ((ArgumentValueDescriptorImpl)descriptor).getVariable().getMatchedNames();
            if (!names.isEmpty()) {
                return DefaultSourcePositionProvider.getSourcePositionForLocalVariable(names.iterator().next(), project, context, nearest);
            }
        } else if (descriptor instanceof MethodReturnValueDescriptorImpl && (debugProcess = context.getDebugProcess()) != null) {
            return debugProcess.getPositionManager().getSourcePosition(((MethodReturnValueDescriptorImpl)descriptor).getMethod().location());
        }
        return null;
    }

    @Nullable
    private static SourcePosition getSourcePositionForField(@NotNull FieldDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        if (descriptor == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(5);
        }
        ReferenceType type = descriptor.getField().declaringType();
        String fieldName = descriptor.getField().name();
        if (fieldName.startsWith("val$")) {
            String varName = fieldName.substring(fieldName.lastIndexOf(36) + 1);
            PsiElement element = PositionUtil.getContextElement((StackFrameContext)context);
            if (element == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            PsiElement navigationElement = aClass.getNavigationElement();
            if (!(navigationElement instanceof PsiClass)) {
                return null;
            }
            aClass = (PsiClass)navigationElement;
            PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(varName, (PsiElement)aClass);
            if (psiVariable == null) {
                return null;
            }
            if (nearest) {
                return DebuggerContextUtil.findNearest(context, (PsiElement)psiVariable, aClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)psiVariable);
        }
        PsiClass aClass = null;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess != null) {
            try {
                List<Method> methods = type.methods();
                for (Method m : methods.reversed()) {
                    List<Location> locations = m.allLineLocations();
                    if (locations.isEmpty()) continue;
                    aClass = JVMNameUtil.getClassAt(debugProcess.getPositionManager().getSourcePosition((Location)ContainerUtil.getLastItem(locations)));
                    break;
                }
            }
            catch (AbsentInformationException | ClassNotPreparedException methods) {
                // empty catch block
            }
        }
        if (aClass == null) {
            DebuggerSession session = context.getDebuggerSession();
            GlobalSearchScope scope = session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project);
            aClass = DebuggerUtils.findClass((String)type.name(), (Project)project, (GlobalSearchScope)scope);
        }
        if (aClass != null) {
            PsiField field = aClass.findFieldByName(fieldName, false);
            if (field == null) {
                return null;
            }
            if (nearest) {
                return DebuggerContextUtil.findNearest(context, field.getNavigationElement(), aClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)field);
        }
        return null;
    }

    @Nullable
    private static SourcePosition getSourcePositionForLocalVariable(String name, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        PsiElement place2;
        if (project == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DefaultSourcePositionProvider.$$$reportNull$$$0(7);
        }
        if ((place2 = PositionUtil.getContextElement((StackFrameContext)context)) == null) {
            return null;
        }
        PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(name, place2);
        if (psiVariable == null) {
            return null;
        }
        PsiFile containingFile = psiVariable.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        try {
            if (nearest) {
                return DebuggerContextUtil.findNearest(context, (PsiElement)psiVariable, containingFile);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return SourcePosition.createFromElement((PsiElement)psiVariable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DefaultSourcePositionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeSourcePosition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourcePositionForField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourcePositionForLocalVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

