/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.JvmDropFrameActionHandler;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.actions.ResumeAllJavaThreadsActionHandler;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaDebugSessionEventsProvider;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaSteppingSuspendContext;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.dfaassist.DfaAssist;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.overhead.OverheadView;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.DapMode;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionEventsProvider;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XDropFrameHandler;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.ThreadsActionsProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession myJavaSession;
    private final JavaDebuggerEditorsProvider myEditorsProvider;
    private volatile XBreakpointHandler<?>[] myBreakpointHandlers;
    private final NodeManagerImpl myNodeManager;
    private final JvmSmartStepIntoActionHandler mySmartStepIntoActionHandler;
    private final JvmDropFrameActionHandler myDropFrameActionActionHandler;
    private final JavaDebugSessionEventsProvider myJavaDebugSessionEventsProvider;
    private static final JavaBreakpointHandlerFactory[] ourDefaultBreakpointHandlerFactories = new JavaBreakpointHandlerFactory[]{process -> new JavaBreakpointHandler.JavaLineBreakpointHandler(process), process -> new JavaBreakpointHandler.JavaExceptionBreakpointHandler(process), process -> new JavaBreakpointHandler.JavaFieldBreakpointHandler(process), process -> new JavaBreakpointHandler.JavaMethodBreakpointHandler(process), process -> new JavaBreakpointHandler.JavaWildcardBreakpointHandler(process), process -> new JavaBreakpointHandler.JavaCollectionBreakpointHandler(process)};

    public static JavaDebugProcess create(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession) {
        if (session == null) {
            JavaDebugProcess.$$$reportNull$$$0(0);
        }
        if (javaSession == null) {
            JavaDebugProcess.$$$reportNull$$$0(1);
        }
        JavaDebugProcessWithThreadsActions res = new JavaDebugProcessWithThreadsActions(session, javaSession);
        javaSession.getProcess().setXDebugProcess(res);
        return res;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession session, final @NotNull DebuggerSession javaSession) {
        if (session == null) {
            JavaDebugProcess.$$$reportNull$$$0(2);
        }
        if (javaSession == null) {
            JavaDebugProcess.$$$reportNull$$$0(3);
        }
        super(session);
        this.myJavaSession = javaSession;
        this.myEditorsProvider = new JavaDebuggerEditorsProvider();
        DebugProcessImpl process = javaSession.getProcess();
        this.myBreakpointHandlers = (XBreakpointHandler[])((StreamEx)StreamEx.of((Object[])ourDefaultBreakpointHandlerFactories).append(JavaBreakpointHandlerFactory.EP_NAME.getExtensionList().stream())).map(factory -> factory.createHandler(process)).toArray(XBreakpointHandler[]::new);
        JavaBreakpointHandlerFactory.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JavaBreakpointHandlerFactory>(){

            public void extensionAdded(@NotNull JavaBreakpointHandlerFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavaDebugProcess.this.myBreakpointHandlers = (XBreakpointHandler[])ArrayUtil.append((Object[])JavaDebugProcess.this.myBreakpointHandlers, (Object)((Object)extension.createHandler(JavaDebugProcess.this.myJavaSession.getProcess())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaDebugProcess$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)process.disposable);
        this.myJavaSession.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl newContext, final DebuggerSession.Event event) {
                if (newContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == DebuggerSession.Event.CONTEXT) {
                    DebuggerSession debuggerSession = newContext.getDebuggerSession();
                    final ThreadReferenceProxyImpl steppingThreadProxy = newContext.getThreadProxy();
                    if (debuggerSession != null && debuggerSession.getState() == DebuggerSession.State.IN_STEPPING) {
                        final DebugProcessImpl debugProcess = debuggerSession.getProcess();
                        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() {
                                JavaExecutionStack stack = steppingThreadProxy != null ? new JavaExecutionStack(steppingThreadProxy, debugProcess, true) : null;
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)new JavaSteppingSuspendContext(debugProcess, stack));
                            }
                        });
                        return;
                    }
                }
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.myJavaSession.isPaused()) {
                    final SuspendContextImpl newSuspendContext = newContext.getSuspendContext();
                    if (newSuspendContext != null && (JavaDebugProcess.this.shouldApplyContext(newContext) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        newSuspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(newSuspendContext){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                ThreadReferenceProxyImpl threadProxy = newContext.getThreadProxy();
                                newSuspendContext.initExecutionStacks(threadProxy);
                                if (event == DebuggerSession.Event.REFRESH) {
                                    ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).updateSuspendContext((XSuspendContext)newSuspendContext);
                                    return;
                                }
                                Pair item = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(newSuspendContext));
                                if (item != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)item.getFirst()).getXBreakpoint();
                                    Event second = (Event)item.getSecond();
                                    if (xBreakpoint != null && second instanceof LocatableEvent && threadProxy != null && ((LocatableEvent)second).thread() == threadProxy.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, (XSuspendContext)newSuspendContext);
                                        SourceCodeChecker.checkSource(newContext);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)newSuspendContext);
                                SourceCodeChecker.checkSource(newContext);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebugProcess$2$2", "contextAction"));
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/engine/JavaDebugProcess$2", "changeEvent"));
            }
        });
        this.myNodeManager = new NodeManagerImpl(this, session.getProject(), null){

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
                return new DebuggerTreeNodeImpl(null, descriptor);
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
                return new DebuggerTreeNodeImpl(null, descriptor);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String message) {
                return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
            }
        };
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.showAlternativeNotification(session.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame frame = session.getCurrentStackFrame();
                if (frame instanceof JavaStackFrame) {
                    this.showAlternativeNotification(frame);
                    StackFrameProxyImpl frameProxy = ((JavaStackFrame)frame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(javaSession.getContextManager(), frameProxy);
                    JavaDebugProcess.this.saveNodeHistory(frameProxy);
                }
            }

            private void showAlternativeNotification(@Nullable XStackFrame frame) {
                VirtualFile file;
                XSourcePosition position;
                if (DapMode.isDap()) {
                    return;
                }
                if (frame != null && (position = frame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.isFileProcessed(file = position.getFile())) {
                    EditorNotifications.getInstance((Project)session.getProject()).updateNotifications(file);
                }
            }
        });
        if (!DebuggerUtilsImpl.isRemote(process)) {
            DfaAssist.installDfaAssist(this.myJavaSession, session, (Disposable)process.disposable);
        }
        this.mySmartStepIntoActionHandler = new JvmSmartStepIntoActionHandler(javaSession);
        this.myDropFrameActionActionHandler = new JvmDropFrameActionHandler(javaSession);
        this.myJavaDebugSessionEventsProvider = new JavaDebugSessionEventsProvider(this);
    }

    private boolean shouldApplyContext(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
        if (xSuspendContext instanceof SuspendContextImpl) {
            SuspendContextImpl currentContext = (SuspendContextImpl)xSuspendContext;
            if (suspendContext == null || ((Object)((Object)suspendContext)).equals((Object)currentContext)) {
                JavaExecutionStack currentExecutionStack = currentContext.getActiveExecutionStack();
                return currentExecutionStack == null || !Comparing.equal((Object)context.getThreadProxy(), (Object)currentExecutionStack.getThreadProxy());
            }
        }
        return true;
    }

    public void saveNodeHistory() {
        this.saveNodeHistory(this.getDebuggerStateManager().getContext().getFrameProxy());
    }

    private void saveNodeHistory(StackFrameProxyImpl frameProxy) {
        this.myJavaSession.getProcess().getManagerThread().invoke(PrioritizedTask.Priority.NORMAL, () -> this.myNodeManager.setHistoryByContext(frameProxy));
    }

    private DebuggerStateManager getDebuggerStateManager() {
        return this.myJavaSession.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.myJavaSession;
    }

    public XDebugSessionEventsProvider getSessionEventsProvider() {
        return this.myJavaDebugSessionEventsProvider;
    }

    public void computeRunningExecutionStacks(final XSuspendContext.XExecutionStackContainer container) {
        final DebugProcessImpl debugProcess = this.getDebuggerSession().getProcess();
        final DebuggerContextImpl context = debugProcess.getDebuggerContext();
        DebuggerManagerThreadImpl managerThread = context.getManagerThread();
        if (managerThread == null) {
            container.errorOccurred(XDebuggerBundle.message((String)"debugger.threads.not.available", (Object[])new Object[0]));
            return;
        }
        managerThread.schedule(new DebuggerCommandImpl(this){

            @Override
            protected void action() {
                try {
                    ThreadReferenceProxyImpl currentThread = context.getThreadProxy();
                    Collection<ThreadReferenceProxyImpl> allThreads = VirtualMachineProxyImpl.getCurrent().allThreads();
                    List executionStacks = ContainerUtil.map(allThreads, thread -> new JavaExecutionStack((ThreadReferenceProxyImpl)thread, debugProcess, thread.equals(currentThread)));
                    container.addExecutionStack(executionStacks, true);
                }
                catch (Throwable e) {
                    container.errorOccurred(XDebuggerBundle.message((String)"debugger.threads.not.available", (Object[])new Object[0]) + ": " + e.getMessage());
                }
            }

            @Override
            protected void commandCancelled() {
                container.errorOccurred(XDebuggerBundle.message((String)"debugger.threads.not.available", (Object[])new Object[0]));
            }
        });
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = this.myEditorsProvider;
        if (javaDebuggerEditorsProvider == null) {
            JavaDebugProcess.$$$reportNull$$$0(4);
        }
        return javaDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOut();
    }

    public void stop() {
        this.myJavaSession.dispose();
        this.myNodeManager.dispose();
    }

    public void startPausing() {
        this.myJavaSession.pause();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.myJavaSession.resume();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            JavaDebugProcess.$$$reportNull$$$0(5);
        }
        this.myJavaSession.runToCursor(position, false);
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            JavaDebugProcess.$$$reportNull$$$0(6);
        }
        return this.myBreakpointHandlers;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myJavaSession.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole console = this.myJavaSession.getProcess().getExecutionResult().getExecutionConsole();
        if (console != null) {
            ExecutionConsole executionConsole = console;
            if (executionConsole == null) {
                JavaDebugProcess.$$$reportNull$$$0(7);
            }
            return executionConsole;
        }
        ExecutionConsole executionConsole = super.createConsole();
        if (executionConsole == null) {
            JavaDebugProcess.$$$reportNull$$$0(8);
        }
        return executionConsole;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!SplitDebuggerMode.isSplitDebugger()) {
                    this.registerThreadsPanel(ui);
                }
                this.registerMemoryViewPanel(ui);
                this.registerOverheadMonitor(ui);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                if (ui == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (console == null) {
                    6.$$$reportNull$$$0(2);
                }
                Content content = null;
                if (console instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)console).buildUi(ui);
                    content = ui.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(ui, console);
                }
                Content content2 = content;
                if (content2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                return content2;
            }

            private void registerThreadsPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    6.$$$reportNull$$$0(4);
                }
                final ThreadsPanel panel = new ThreadsPanel(JavaDebugProcess.this.myJavaSession.getProject(), JavaDebugProcess.this.getDebuggerStateManager());
                final Content threadsContent = ui.createContent("ThreadsContent", (JComponent)panel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), null, panel.getDefaultFocusedComponent());
                threadsContent.setCloseable(false);
                ui.addContent(threadsContent, 0, PlaceInGrid.left, true);
                ui.addListener(new ContentManagerListener(){

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getContent() == threadsContent) {
                            if (threadsContent.isSelected()) {
                                panel.setUpdateEnabled(true);
                                if (panel.isRefreshNeeded()) {
                                    panel.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                panel.setUpdateEnabled(false);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/JavaDebugProcess$6$1", "selectionChanged"));
                    }
                }, (Disposable)threadsContent);
            }

            private void registerMemoryViewPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    6.$$$reportNull$$$0(5);
                }
                if (!Registry.is((String)"debugger.enable.memory.view")) {
                    return;
                }
                final XDebugSession session = JavaDebugProcess.this.getSession();
                DebugProcessImpl process = JavaDebugProcess.this.myJavaSession.getProcess();
                InstancesTracker tracker = InstancesTracker.getInstance((Project)JavaDebugProcess.this.myJavaSession.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(session, process, tracker);
                final Content memoryViewContent = ui.createContent("MemoryView", (JComponent)((Object)classesFilteredView), JavaDebuggerBundle.message((String)"memory.toolwindow.title", (Object[])new Object[0]), null, classesFilteredView.getDefaultFocusedComponent());
                memoryViewContent.setCloseable(false);
                memoryViewContent.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData data = new MemoryViewDebugProcessData();
                process.putUserData(MemoryViewDebugProcessData.KEY, data);
                session.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        session.removeSessionListener((XDebugSessionListener)this);
                        data.getTrackedStacks().clear();
                    }
                });
                ui.addContent(memoryViewContent, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl managerThread = process.getManagerThread();
                ui.addListener(new ContentManagerListener(){

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (event.getContent() == memoryViewContent) {
                            classesFilteredView.setActive(memoryViewContent.isSelected(), managerThread);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/JavaDebugProcess$6$3", "selectionChanged"));
                    }
                }, (Disposable)memoryViewContent);
            }

            private void registerOverheadMonitor(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    6.$$$reportNull$$$0(6);
                }
                if (!Registry.is((String)"debugger.enable.overhead.monitor")) {
                    return;
                }
                DebugProcessImpl process = JavaDebugProcess.this.myJavaSession.getProcess();
                OverheadView monitor = new OverheadView(process);
                Content overheadContent = ui.createContent("OverheadMonitor", (JComponent)((Object)monitor), JavaDebuggerBundle.message((String)"overhead.toolwindow.title", (Object[])new Object[0]), null, monitor.getDefaultFocusedComponent());
                monitor.setBouncer(() -> ui.setBouncing(overheadContent, true));
                overheadContent.setCloseable(false);
                overheadContent.setShouldDisposeContent(true);
                ui.addContent(overheadContent, 0, PlaceInGrid.right, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$6";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "registerThreadsPanel";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "registerMemoryViewPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "registerOverheadMonitor";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            JavaDebugProcess.$$$reportNull$$$0(9);
        }
        if (topToolbar == null) {
            JavaDebugProcess.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            JavaDebugProcess.$$$reportNull$$$0(11);
        }
        if (!UIExperiment.isNewDebuggerUIEnabled()) {
            Constraints beforeRunner = new Constraints(Anchor.BEFORE, "Runner.Layout");
            leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
            leftToolbar.add(ActionManager.getInstance().getAction("DumpThreads"), beforeRunner);
            leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        }
        Constraints beforeSort = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        settings.addAction((AnAction)new WatchLastMethodReturnValueAction(), beforeSort);
        settings.addAction((AnAction)new AutoVarsSwitchAction(), beforeSort);
    }

    @Nullable
    public static DebugProcessImpl getCurrentDebugProcess(@NotNull AnActionEvent e) {
        XDebugProcess process;
        XDebugSession session;
        if (e == null) {
            JavaDebugProcess.$$$reportNull$$$0(12);
        }
        if ((session = DebuggerUIUtil.getSession((AnActionEvent)e)) != null && (process = session.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)process).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    public String getCurrentStateMessage() {
        String description = this.myJavaSession.getStateDescription();
        return description != null ? description : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoActionHandler;
    }

    @ApiStatus.Experimental
    @Nullable
    public XDropFrameHandler getDropFrameHandler() {
        return this.myDropFrameActionActionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSession";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDebugProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static final class JavaDebugProcessWithThreadsActions
    extends JavaDebugProcess
    implements ThreadsActionsProvider {
        private final ResumeAllJavaThreadsActionHandler myResumeAllJavaThreadsActionHandler;

        private JavaDebugProcessWithThreadsActions(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession) {
            if (session == null) {
                JavaDebugProcessWithThreadsActions.$$$reportNull$$$0(0);
            }
            if (javaSession == null) {
                JavaDebugProcessWithThreadsActions.$$$reportNull$$$0(1);
            }
            super(session, javaSession);
            this.myResumeAllJavaThreadsActionHandler = new ResumeAllJavaThreadsActionHandler(this.getDebuggerSession().getProcess());
        }

        @Nullable
        public DebuggerActionHandler getThawAllThreadsHandler() {
            return this.myResumeAllJavaThreadsActionHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "javaSession";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaDebugProcess$JavaDebugProcessWithThreadsActions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private final @NlsActions.ActionText String myText = JavaDebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
        private final @NlsActions.ActionText String myTextUnavailable = JavaDebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);

        WatchLastMethodReturnValueAction() {
            super("", JavaDebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchLastMethodReturnValueAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            DebugProcessImpl process = JavaDebugProcess.getCurrentDebugProcess(e);
            if (process == null || process.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.myText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.myTextUnavailable);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                WatchLastMethodReturnValueAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchLastMethodReturnValueAction.$$$reportNull$$$0(2);
            }
            return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean watch) {
            if (e == null) {
                WatchLastMethodReturnValueAction.$$$reportNull$$$0(3);
            }
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process = JavaDebugProcess.getCurrentDebugProcess(e);
            if (process != null) {
                process.setWatchMethodReturnValuesEnabled(watch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;

        AutoVarsSwitchAction() {
            super(JavaDebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), JavaDebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                AutoVarsSwitchAction.$$$reportNull$$$0(0);
            }
            return this.myAutoModeEnabled;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AutoVarsSwitchAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (e == null) {
                AutoVarsSwitchAction.$$$reportNull$$$0(2);
            }
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$AutoVarsSwitchAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$AutoVarsSwitchAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

