/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH$J$\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/engine/JavaDebuggerCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "<init>", "()V", "createPsiCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createPresentationPsiCodeFragment", "createPresentationPsiCodeFragmentImpl", "createPsiCodeFragmentImpl", "setThisType", "", "codeFragment", "intellij.java.debugger.impl"})
public abstract class JavaDebuggerCodeFragmentFactory
extends CodeFragmentFactory {
    @Nullable
    public final JavaCodeFragment createPsiCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JavaCodeFragment javaCodeFragment = this.createPsiCodeFragmentImpl(item, context, project);
        if (javaCodeFragment == null) {
            return null;
        }
        JavaCodeFragment codeFragment = javaCodeFragment;
        if (context != null) {
            this.setThisType(context, codeFragment);
        }
        return codeFragment;
    }

    @Nullable
    public final JavaCodeFragment createPresentationPsiCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JavaCodeFragment javaCodeFragment = this.createPresentationPsiCodeFragmentImpl(item, context, project);
        if (javaCodeFragment == null) {
            return null;
        }
        JavaCodeFragment codeFragment = javaCodeFragment;
        if (context != null) {
            this.setThisType(context, codeFragment);
        }
        return codeFragment;
    }

    @Nullable
    protected abstract JavaCodeFragment createPresentationPsiCodeFragmentImpl(@NotNull TextWithImports var1, @Nullable PsiElement var2, @NotNull Project var3);

    @Nullable
    protected abstract JavaCodeFragment createPsiCodeFragmentImpl(@NotNull TextWithImports var1, @Nullable PsiElement var2, @NotNull Project var3);

    private final void setThisType(PsiElement context, JavaCodeFragment codeFragment) {
        PsiType contextType = (PsiType)context.getUserData(DebuggerUtilsImpl.PSI_TYPE_KEY);
        if (contextType == null) {
            Class[] classArray = new Class[]{PsiClass.class};
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])classArray);
            if (contextClass != null) {
                contextType = (PsiType)JavaPsiFacade.getElementFactory((Project)codeFragment.getProject()).createType(contextClass);
            }
        }
        codeFragment.setThisType(contextType);
    }
}

