/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValuePresentation;
import com.intellij.debugger.engine.JavaValueUtilsKt;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.memory.agent.MemoryAgentPathsToClosestGCRootsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ThisDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.XValuePresentationProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XPinToTopData;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.pinned.items.PinToTopMemberValue;
import com.intellij.xdebugger.impl.pinned.items.PinToTopParentValue;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JavaValue
extends XNamedValue
implements NodeDescriptorProvider,
XValueTextProvider,
PinToTopParentValue,
PinToTopMemberValue {
    private static final Logger LOG = Logger.getInstance(JavaValue.class);
    private final boolean myCanBePinned;
    private final JavaValue myParent;
    @NotNull
    private final ValueDescriptorImpl myValueDescriptor;
    @NotNull
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;
    private final boolean myContextSet;
    private final CompletableFuture<XDescriptor> myXDescriptorFuture;
    private final CompletableFuture<XPinToTopData> myPinToTopDataFuture;
    private volatile XExpression evaluationExpression;

    protected JavaValue(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            JavaValue.$$$reportNull$$$0(1);
        }
        this(parent, valueDescriptor.calcValueName(), valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    protected JavaValue(JavaValue parent, String name, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.$$$reportNull$$$0(2);
        }
        if (evaluationContext == null) {
            JavaValue.$$$reportNull$$$0(3);
        }
        super(name);
        this.evaluationExpression = null;
        this.myParent = parent;
        this.myValueDescriptor = valueDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
        this.myContextSet = contextSet;
        this.myCanBePinned = this.doComputeCanBePinned();
        this.myXDescriptorFuture = this.myValueDescriptor.getInitFuture().thenCompose(__ -> JavaValueUtilsKt.getJavaValueXDescriptor(this));
        this.myPinToTopDataFuture = this.myValueDescriptor.getInitFuture().thenApply(__ -> new XPinToTopData(this.canBePinned(), this.getTag(), null, null, null));
    }

    @Nullable
    public String getTag() {
        Type type = this.myValueDescriptor.getType();
        return type == null ? null : type.name();
    }

    @Nullable
    public CompletableFuture<XPinToTopData> getPinToTopDataFuture() {
        return this.myPinToTopDataFuture;
    }

    public boolean canBePinned() {
        return this.myCanBePinned;
    }

    private boolean doComputeCanBePinned() {
        if (this.myValueDescriptor instanceof ArrayElementDescriptor) {
            return false;
        }
        return this.myParent != null;
    }

    public static JavaValue create(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            JavaValue.$$$reportNull$$$0(4);
        }
        if (evaluationContext == null) {
            JavaValue.$$$reportNull$$$0(5);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new JavaValue(parent, valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    static JavaValue create(@NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        if (valueDescriptor == null) {
            JavaValue.$$$reportNull$$$0(6);
        }
        if (evaluationContext == null) {
            JavaValue.$$$reportNull$$$0(7);
        }
        return JavaValue.create(null, valueDescriptor, evaluationContext, nodeManager, false);
    }

    public JavaValue getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl getDescriptor() {
        ValueDescriptorImpl valueDescriptorImpl = this.myValueDescriptor;
        if (valueDescriptorImpl == null) {
            JavaValue.$$$reportNull$$$0(8);
        }
        return valueDescriptorImpl;
    }

    @NotNull
    public EvaluationContextImpl getEvaluationContext() {
        EvaluationContextImpl evaluationContextImpl = this.myEvaluationContext;
        if (evaluationContextImpl == null) {
            JavaValue.$$$reportNull$$$0(9);
        }
        return evaluationContextImpl;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    private boolean isOnDemand() {
        return OnDemandRenderer.ON_DEMAND_CALCULATED.isIn((UserDataHolder)this.myValueDescriptor);
    }

    private boolean isCalculated() {
        return OnDemandRenderer.isCalculated(this.myValueDescriptor);
    }

    public void computePresentation(final @NotNull XValueNode node, final @NotNull XValuePlace place2) {
        if (node == null) {
            JavaValue.$$$reportNull$$$0(10);
        }
        if (place2 == null) {
            JavaValue.$$$reportNull$$$0(11);
        }
        if (this.isOnDemand() && !this.isCalculated()) {
            this.myValueDescriptor.applyOnDemandPresentation(node);
            return;
        }
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                node.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0])), false);
                this.cancelInitFuture();
            }

            @Override
            public void contextAction(final @NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isObsolete()) {
                    this.cancelInitFuture();
                    return;
                }
                if (!JavaValue.this.myContextSet) {
                    JavaValue.this.myValueDescriptor.setContext(JavaValue.this.myEvaluationContext);
                }
                JavaValue.this.myValueDescriptor.updateRepresentationNoNotify(JavaValue.this.myEvaluationContext, new DescriptorLabelListener(){

                    @Override
                    public void labelChanged() {
                        Icon nodeIcon = place2 == XValuePlace.TOOLTIP ? JavaValue.this.myValueDescriptor.getValueIcon() : DebuggerTreeRenderer.getValueIcon(JavaValue.this.myValueDescriptor, JavaValue.this.myParent != null ? JavaValue.this.myParent.getDescriptor() : null);
                        Icon inlayIcon = JavaValue.this.myValueDescriptor.getInlayIcon();
                        if (inlayIcon != null && node instanceof XValueNodeImpl) {
                            XValueNodeImpl xValueNode = (XValueNodeImpl)node;
                            xValueNode.setInlayIcon(inlayIcon);
                        }
                        XValuePresentation presentation = JavaValue.createPresentation(JavaValue.this.myValueDescriptor);
                        node.setPresentation(nodeIcon, presentation, JavaValue.this.myValueDescriptor.isExpandable());
                        JavaValue.scheduleCommand(JavaValue.this.myEvaluationContext, (Obsolescent)node, new SuspendContextCommandImpl(suspendContext){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                this.initFullValueEvaluator();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$1$1$1", "contextAction"));
                            }
                        });
                    }

                    private void initFullValueEvaluator() {
                        Renderer lastRenderer = JavaValue.this.myValueDescriptor.getLastRenderer();
                        boolean fullEvaluatorSet = this.setFullValueEvaluator(lastRenderer);
                        if (!fullEvaluatorSet && lastRenderer instanceof CompoundReferenceRenderer) {
                            fullEvaluatorSet = this.setFullValueEvaluator(((CompoundReferenceRenderer)lastRenderer).getLabelRenderer());
                        }
                        if (!fullEvaluatorSet) {
                            final String text = JavaValue.this.myValueDescriptor.getValueText();
                            if (text.length() > 1000) {
                                node.setFullValueEvaluator((XFullValueEvaluator)new JavaFullValueEvaluator(JavaValue.this.myEvaluationContext){

                                    @Override
                                    public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                        if (callback == null) {
                                            2.$$$reportNull$$$0(0);
                                        }
                                        final ValueDescriptorImpl fullValueDescriptor = JavaValue.this.myValueDescriptor.getFullValueDescriptor();
                                        fullValueDescriptor.updateRepresentation(this.myEvaluationContext, new DescriptorLabelListener(){

                                            @Override
                                            public void labelChanged() {
                                                callback.evaluated(fullValueDescriptor.getValueText());
                                            }
                                        });
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$1$1$2", "evaluate"));
                                    }
                                });
                            } else if (VisualizedTextPopupUtil.isVisualizable((String)text)) {
                                node.setFullValueEvaluator(new XFullValueEvaluator(this){

                                    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                        if (callback == null) {
                                            3.$$$reportNull$$$0(0);
                                        }
                                        callback.evaluated(text);
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$1$1$3", "startEvaluation"));
                                    }
                                });
                            }
                        }
                    }

                    private boolean setFullValueEvaluator(Renderer renderer) {
                        XFullValueEvaluator evaluator;
                        if (renderer instanceof FullValueEvaluatorProvider && (evaluator = ((FullValueEvaluatorProvider)((Object)renderer)).getFullValueEvaluator(node, JavaValue.this.myEvaluationContext, JavaValue.this.myValueDescriptor)) != null) {
                            node.setFullValueEvaluator(evaluator);
                            return true;
                        }
                        return false;
                    }
                });
            }

            private void cancelInitFuture() {
                CompletableFuture<Void> future = JavaValue.this.myValueDescriptor.getInitFuture();
                if (!future.isDone()) {
                    future.cancel(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$1", "contextAction"));
            }
        });
    }

    public static XValuePresentation createPresentation(ValueDescriptorImpl descriptor) {
        Renderer lastLabelRenderer = descriptor.getLastLabelRenderer();
        if (lastLabelRenderer instanceof XValuePresentationProvider) {
            XValuePresentationProvider presentationProvider = (XValuePresentationProvider)((Object)lastLabelRenderer);
            return presentationProvider.getPresentation(descriptor);
        }
        return new JavaValuePresentation(descriptor);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            JavaValue.$$$reportNull$$$0(12);
        }
        this.computeChildren(-1, node);
    }

    private void computeChildren(final int remainingElements, final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaValue.$$$reportNull$$$0(13);
        }
        this.myValueDescriptor.getInitFuture().thenRun(() -> JavaValue.scheduleCommand(this.myEvaluationContext, (Obsolescent)node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                JavaValue.this.myValueDescriptor.getChildrenRenderer(JavaValue.this.myEvaluationContext.getDebugProcess()).thenAccept(r -> r.buildChildren(JavaValue.this.myValueDescriptor.getValue(), new MyChildrenBuilder(remainingElements, node), JavaValue.this.myEvaluationContext));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$2", "contextAction"));
            }
        }));
    }

    protected static boolean scheduleCommand(@NotNull EvaluationContextImpl evaluationContext, final @NotNull Obsolescent node, final @NotNull SuspendContextCommandImpl command2) {
        if (evaluationContext == null) {
            JavaValue.$$$reportNull$$$0(14);
        }
        if (node == null) {
            JavaValue.$$$reportNull$$$0(15);
        }
        if (command2 == null) {
            JavaValue.$$$reportNull$$$0(16);
        }
        if (node.isObsolete()) {
            return false;
        }
        SuspendContextImpl suspendContext = evaluationContext.getSuspendContext();
        suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (suspendContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (node.isObsolete()) {
                    return;
                }
                command2.contextAction(suspendContext);
            }

            @Override
            protected void commandCancelled() {
                if (node instanceof XCompositeNode) {
                    XCompositeNode compositeNode = (XCompositeNode)node;
                    compositeNode.setErrorMessage(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                } else if (node instanceof XValueNode) {
                    XValueNode valueNode = (XValueNode)node;
                    valueNode.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0])), false);
                } else {
                    LOG.error("Unknown node type: " + String.valueOf(node));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$3", "contextAction"));
            }
        });
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            JavaValue.$$$reportNull$$$0(17);
        }
        AtomicBoolean computed = new AtomicBoolean(false);
        JavaValueUtilsKt.scheduleSourcePositionCompute(this.myEvaluationContext, this.myValueDescriptor, false, (Function1<? super XSourcePosition, Unit>)((Function1)xPos -> {
            if (computed.compareAndSet(false, true)) {
                navigatable.setSourcePosition(xPos);
            }
            return Unit.INSTANCE;
        }));
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            JavaValue.$$$reportNull$$$0(18);
        }
        if (this.myValueDescriptor instanceof FieldDescriptor && this.myParent != null && !(this.myParent.myValueDescriptor instanceof ThisDescriptorImpl)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                JavaValue.$$$reportNull$$$0(19);
            }
            return threeState;
        }
        JavaValueUtilsKt.scheduleSourcePositionCompute(this.myEvaluationContext, this.myValueDescriptor, true, (Function1<? super XSourcePosition, Unit>)((Function1)xPos -> {
            callback.computed(xPos);
            return Unit.INSTANCE;
        }));
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            JavaValue.$$$reportNull$$$0(20);
        }
        return threeState;
    }

    private DebuggerContextImpl getDebuggerContext() {
        return this.myEvaluationContext.getDebugProcess().getDebuggerContext();
    }

    public Project getProject() {
        return this.myValueDescriptor.getProject();
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            JavaValue.$$$reportNull$$$0(21);
        }
        if (this.myEvaluationContext.getSuspendContext().isResumed()) {
            return;
        }
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        this.myEvaluationContext.getManagerThread().schedule(new NavigateCommand(this, this.getDebuggerContext(), this.myValueDescriptor, debugProcess, null){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void doAction(@Nullable SourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    ReadAction.nonBlocking(() -> navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition))).executeSynchronously();
                }
            }
        });
    }

    @NotNull
    public CompletableFuture<XDescriptor> getXValueDescriptorAsync() {
        CompletableFuture<XDescriptor> completableFuture = this.myXDescriptorFuture;
        if (completableFuture == null) {
            JavaValue.$$$reportNull$$$0(22);
        }
        return completableFuture;
    }

    @Nullable
    public XValueModifier getModifier() {
        return this.myValueDescriptor.canSetValue() ? this.myValueDescriptor.getModifier(this) : null;
    }

    @ApiStatus.Internal
    public @NotNull CompletableFuture<@Nullable XValueModifier> getModifierAsync() {
        CompletionStage completionStage = this.myValueDescriptor.canSetValueAsync().thenApply(canSetValue -> canSetValue != false ? this.myValueDescriptor.getModifier(this) : null);
        if (completionStage == null) {
            JavaValue.$$$reportNull$$$0(23);
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<Void> isReady() {
        CompletableFuture<Void> completableFuture = this.myValueDescriptor.getInitFuture();
        if (completableFuture == null) {
            JavaValue.$$$reportNull$$$0(24);
        }
        return completableFuture;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        if (this.evaluationExpression != null) {
            Promise promise = Promises.resolvedPromise((Object)this.evaluationExpression);
            if (promise == null) {
                JavaValue.$$$reportNull$$$0(25);
            }
            return promise;
        }
        final AsyncPromise result = new AsyncPromise();
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    JavaValue.this.getDescriptor().getTreeEvaluation(JavaValue.this, JavaValue.this.getDebuggerContext()).whenComplete((psiExpression, ex) -> {
                        if (ex != null) {
                            result.setError(ex);
                        } else if (psiExpression != null) {
                            ReadAction.nonBlocking(() -> {
                                XExpression res = TextWithImportsImpl.toXExpression(new TextWithImportsImpl((PsiElement)psiExpression));
                                Set imports = (Set)psiExpression.getUserData(DebuggerTreeNodeExpression.ADDITIONAL_IMPORTS_KEY);
                                if (imports != null && res != null) {
                                    if (res.getCustomInfo() != null) {
                                        imports.add(res.getCustomInfo());
                                    }
                                    res = new XExpressionImpl(res.getExpression(), res.getLanguage(), StringUtil.join((Collection)imports, (String)","), res.getMode());
                                }
                                JavaValue.this.evaluationExpression = res;
                                result.setResult((Object)res);
                            }).executeSynchronously();
                        } else {
                            result.setError("Null");
                        }
                    });
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                    result.setError((Throwable)e);
                }
            }

            @Override
            protected void commandCancelled() {
                result.setError("Cancelled");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$5", "contextAction"));
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            JavaValue.$$$reportNull$$$0(26);
        }
        return asyncPromise;
    }

    @Nullable
    public String getValueText() {
        return this.myValueDescriptor.getValueText();
    }

    public boolean shouldShowTextValue() {
        if (this.myValueDescriptor.isValueReady()) {
            return this.myValueDescriptor.isString();
        }
        return false;
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                ReferringObjectsProvider provider = ReferringObjectsProvider.BASIC_JDI;
                if (DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
                    provider = new MemoryAgentPathsToClosestGCRootsProvider(10, 50, provider);
                }
                return new JavaReferringObjectsValue(JavaValue.this, provider, null);
            }
        };
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){

            public void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @NotNull XStackFrame frame) {
                if (callback == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (frame == null) {
                    7.$$$reportNull$$$0(1);
                }
                JavaValue.this.myEvaluationContext.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void commandCancelled() {
                        callback.errorOccurred(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                    }

                    @Override
                    protected void action() {
                        EvaluationContextImpl evaluationContext;
                        NodeDescriptor item;
                        Modifier modifier;
                        ValueDescriptorImpl inspectDescriptor = JavaValue.this.myValueDescriptor;
                        if (JavaValue.this.myValueDescriptor instanceof WatchItemDescriptor && (modifier = ((WatchItemDescriptor)JavaValue.this.myValueDescriptor).getModifier()) != null && (item = modifier.getInspectItem(JavaValue.this.getProject())) != null) {
                            inspectDescriptor = (ValueDescriptorImpl)item;
                        }
                        if ((evaluationContext = ((JavaStackFrame)frame).getFrameDebuggerContext(null).createEvaluationContext()) != null) {
                            callback.evaluated((XValue)JavaValue.create(inspectDescriptor, evaluationContext, JavaValue.this.myNodeManager));
                        } else {
                            callback.errorOccurred(JavaDebuggerBundle.message((String)"error.context.not.available", (Object[])new Object[0]));
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "frame";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaValue$7";
                objectArray[2] = "evaluate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void setRenderer(NodeRenderer nodeRenderer, @Nullable XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myValueDescriptor.setRenderer(nodeRenderer);
        this.reBuild(node);
    }

    public void reBuild(@Nullable XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (node == null) {
            return;
        }
        node.invokeNodeUpdate(() -> {
            node.clearChildren();
            this.computePresentation((XValueNode)node, XValuePlace.TREE);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 19, 20, 22, 23, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContext";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getXValueDescriptorAsync";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierAsync";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "isReady";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEvaluationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCommand";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 19, 20, 22, 23, 24, 25, 26 -> new IllegalStateException(string);
        };
    }

    private static abstract class SourcePositionCommand
    extends SuspendContextCommandImpl {
        protected final DebuggerContextImpl myDebuggerContext;
        protected final ValueDescriptor myDescriptor;
        protected final DebugProcessImpl myDebugProcess;
        protected final AnActionEvent myActionEvent;

        SourcePositionCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor, DebugProcessImpl debugProcess, AnActionEvent actionEvent) {
            super(debuggerContext.getSuspendContext());
            this.myDebuggerContext = debuggerContext;
            this.myDescriptor = descriptor;
            this.myDebugProcess = debugProcess;
            this.myActionEvent = actionEvent;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            block3: {
                if (suspendContext == null) {
                    SourcePositionCommand.$$$reportNull$$$0(0);
                }
                try {
                    this.doAction(SourcePositionCommand.calcPosition(this.myDescriptor, this.myDebugProcess));
                }
                catch (ClassNotLoadedException ex) {
                    String className = ex.className();
                    if (this.loadClass(className) == null) break block3;
                    suspendContext.getManagerThread().schedule(this.createRetryCommand());
                }
            }
        }

        protected abstract SourcePositionCommand createRetryCommand();

        protected abstract void doAction(@Nullable SourcePosition var1);

        private ReferenceType loadClass(String className) {
            EvaluationContextImpl eContext = this.myDebuggerContext.createEvaluationContext();
            try {
                return this.myDebugProcess.loadClass(eContext, className, eContext.getClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private static SourcePosition calcPosition(ValueDescriptor descriptor, DebugProcessImpl debugProcess) throws ClassNotLoadedException {
            Type type = descriptor.getType();
            if (type == null) {
                return null;
            }
            try {
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    type = arrayType.componentType();
                }
                if (type instanceof ClassType) {
                    Location location;
                    ClassType clsType = (ClassType)type;
                    Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(clsType, type.virtualMachine()::classesByName);
                    Location location2 = location = lambdaMethod != null ? (Location)ContainerUtil.getFirstItem(DebuggerUtilsEx.allLineLocations(lambdaMethod)) : null;
                    if (location == null) {
                        location = (Location)ContainerUtil.getFirstItem(DebuggerUtilsAsync.allLineLocationsSync(clsType));
                    }
                    if (location != null) {
                        SourcePosition position = debugProcess.getPositionManager().getSourcePosition(location);
                        return (SourcePosition)ReadAction.compute(() -> {
                            SourcePosition classPosition;
                            PsiClass classAt;
                            if (clsType.name().indexOf(36) < 0 && (classAt = JVMNameUtil.getClassAt(position)) != null && (classPosition = SourcePosition.createFromElement((PsiElement)classAt)) != null) {
                                return classPosition;
                            }
                            return position;
                        });
                    }
                }
            }
            catch (AbsentInformationException | ClassNotPreparedException e) {
                LOG.debug((Throwable)e);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$SourcePositionCommand", "contextAction"));
        }
    }

    private static class NavigateCommand
    extends SourcePositionCommand {
        NavigateCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor, DebugProcessImpl debugProcess, AnActionEvent e) {
            super(debuggerContext, descriptor, debugProcess, e);
        }

        @Override
        protected NavigateCommand createRetryCommand() {
            return new NavigateCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            if (sourcePosition != null) {
                sourcePosition.navigate(true);
            }
        }
    }

    private class MyChildrenBuilder
    implements ChildrenBuilder {
        private final int remainingElements;
        @NotNull
        private final XCompositeNode node;

        MyChildrenBuilder(@NotNull int remainingElements, XCompositeNode node) {
            if (node == null) {
                MyChildrenBuilder.$$$reportNull$$$0(0);
            }
            this.remainingElements = remainingElements;
            this.node = node;
        }

        @Override
        public NodeDescriptorFactory getDescriptorManager() {
            return JavaValue.this.myNodeManager;
        }

        @Override
        public NodeManager getNodeManager() {
            return JavaValue.this.myNodeManager;
        }

        @Override
        public ValueDescriptor getParentDescriptor() {
            return JavaValue.this.myValueDescriptor;
        }

        @Override
        public void initChildrenArrayRenderer(ArrayRenderer renderer, int arrayLength) {
            renderer.START_INDEX = 0;
            if (this.remainingElements >= 0) {
                renderer.START_INDEX = Math.max(0, arrayLength - this.remainingElements);
            }
        }

        @Override
        public void addChildren(List<? extends DebuggerTreeNode> nodes, boolean last) {
            XValueChildrenList childrenList = XValueChildrenList.EMPTY;
            if (!nodes.isEmpty()) {
                childrenList = new XValueChildrenList(nodes.size());
                for (DebuggerTreeNode debuggerTreeNode : nodes) {
                    NodeDescriptor descriptor = debuggerTreeNode.getDescriptor();
                    if (descriptor instanceof ValueDescriptorImpl) {
                        childrenList.add((XNamedValue)JavaValue.create(JavaValue.this, (ValueDescriptorImpl)descriptor, JavaValue.this.myEvaluationContext, JavaValue.this.myNodeManager, false));
                        continue;
                    }
                    if (!(descriptor instanceof MessageDescriptor)) continue;
                    childrenList.add((XNamedValue)new JavaStackFrame.DummyMessageValueNode(descriptor.getLabel(), DebuggerTreeRenderer.getDescriptorIcon(descriptor)));
                }
            }
            this.node.addChildren(childrenList, last);
        }

        @Override
        public void setChildren(List<? extends DebuggerTreeNode> nodes) {
            this.addChildren(nodes, true);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                MyChildrenBuilder.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                MyChildrenBuilder.$$$reportNull$$$0(2);
            }
            this.node.setMessage(message, icon, attributes, link);
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                MyChildrenBuilder.$$$reportNull$$$0(3);
            }
            this.node.addChildren(children, last);
        }

        public void tooManyChildren(int remaining) {
            this.node.tooManyChildren(remaining, () -> JavaValue.this.computeChildren(remaining, this.node));
        }

        public void tooManyChildren(int remaining, @NotNull Runnable addNextChildren) {
            if (addNextChildren == null) {
                MyChildrenBuilder.$$$reportNull$$$0(4);
            }
            this.node.tooManyChildren(remaining, addNextChildren);
        }

        public void setAlreadySorted(boolean alreadySorted) {
            this.node.setAlreadySorted(alreadySorted);
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                MyChildrenBuilder.$$$reportNull$$$0(5);
            }
            this.node.setErrorMessage(errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                MyChildrenBuilder.$$$reportNull$$$0(6);
            }
            this.node.setErrorMessage(errorMessage, link);
        }

        public boolean isObsolete() {
            return this.node.isObsolete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addNextChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaValue$MyChildrenBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tooManyChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class JavaFullValueEvaluator
    extends XFullValueEvaluator {
        protected final EvaluationContextImpl myEvaluationContext;

        public JavaFullValueEvaluator(@NotNull @Nls String linkText, EvaluationContextImpl evaluationContext) {
            if (linkText == null) {
                JavaFullValueEvaluator.$$$reportNull$$$0(0);
            }
            super(linkText);
            this.myEvaluationContext = evaluationContext;
        }

        public JavaFullValueEvaluator(EvaluationContextImpl evaluationContext) {
            this.myEvaluationContext = evaluationContext;
        }

        public abstract void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback var1) throws Exception;

        protected EvaluationContextImpl getEvaluationContext() {
            return this.myEvaluationContext;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                JavaFullValueEvaluator.$$$reportNull$$$0(1);
            }
            if (callback.isObsolete()) {
                return;
            }
            this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                protected void commandCancelled() {
                    callback.errorOccurred(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callback.isObsolete()) {
                        return;
                    }
                    this.evaluate(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator$1", "contextAction"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startEvaluation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

