/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.sun.jdi.ThreadReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u000eH\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/engine/RealThreadInfo;", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "realThread", "Lcom/sun/jdi/ThreadReference;", "<init>", "(Lcom/sun/jdi/ThreadReference;)V", "getRealThread", "()Lcom/sun/jdi/ThreadReference;", "checkSameThread", "", "thread", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filterName", "", "getFilterName", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.java.debugger.impl"})
public final class RealThreadInfo
implements LightOrRealThreadInfo {
    @NotNull
    private final ThreadReference realThread;

    public RealThreadInfo(@NotNull ThreadReference realThread) {
        Intrinsics.checkNotNullParameter((Object)realThread, (String)"realThread");
        this.realThread = realThread;
    }

    @Override
    @NotNull
    public ThreadReference getRealThread() {
        return this.realThread;
    }

    @Override
    public boolean checkSameThread(@NotNull ThreadReference thread, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        return Intrinsics.areEqual((Object)this.getRealThread(), (Object)thread);
    }

    @Override
    @NotNull
    public String getFilterName() {
        Object[] objectArray = new Object[]{this.getRealThread().name()};
        String string = JavaDebuggerBundle.message((String)"stepping.filter.real.thread.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final ThreadReference component1() {
        return this.realThread;
    }

    @NotNull
    public final RealThreadInfo copy(@NotNull ThreadReference realThread) {
        Intrinsics.checkNotNullParameter((Object)realThread, (String)"realThread");
        return new RealThreadInfo(realThread);
    }

    public static /* synthetic */ RealThreadInfo copy$default(RealThreadInfo realThreadInfo, ThreadReference threadReference, int n, Object object) {
        if ((n & 1) != 0) {
            threadReference = realThreadInfo.realThread;
        }
        return realThreadInfo.copy(threadReference);
    }

    @NotNull
    public String toString() {
        return "RealThreadInfo(realThread=" + this.realThread + ")";
    }

    public int hashCode() {
        return this.realThread.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealThreadInfo)) {
            return false;
        }
        RealThreadInfo realThreadInfo = (RealThreadInfo)other;
        return Intrinsics.areEqual((Object)this.realThread, (Object)realThreadInfo.realThread);
    }
}

