/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImplKt;
import com.intellij.debugger.engine.RunToCursorManagerKt;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/debugger/engine/RunToCursorManager;", "", "debugProcessImpl", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "waitingContexts", "", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "logWarningJob", "Lkotlinx/coroutines/Job;", "waitingJob", "isTryingToPauseAnotherHitEnabled", "", "onRunToCursorCommandStarted", "", "shouldTryToPauseAnotherHit", "suspendContext", "saveRunToCursorHit", "startRunToCursorTracking", "managerThread", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "resumeWaitingThreadsAndCancelWaitingJob", "dropAlreadyResumedContexts", "intellij.java.debugger.impl"})
public final class RunToCursorManager {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final List<SuspendContextImpl> waitingContexts;
    @Nullable
    private Job logWarningJob;
    @Nullable
    private Job waitingJob;
    private boolean isTryingToPauseAnotherHitEnabled;

    public RunToCursorManager(@NotNull DebugProcessImpl debugProcessImpl, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcessImpl), (String)"debugProcessImpl");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.waitingContexts = new ArrayList();
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){

            public void paused(SuspendContext suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Job job = logWarningJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                logWarningJob = null;
                this.resumeWaitingThreadsAndCancelWaitingJob();
            }
        });
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public final void onRunToCursorCommandStarted() {
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        this.isTryingToPauseAnotherHitEnabled = true;
        this.resumeWaitingThreadsAndCancelWaitingJob();
    }

    public final boolean shouldTryToPauseAnotherHit(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        if (!this.isTryingToPauseAnotherHitEnabled) {
            return false;
        }
        this.dropAlreadyResumedContexts();
        if (this.waitingContexts.size() >= RunToCursorManagerKt.access$getWaitingThreadsLimit()) {
            EventSet eventSet = suspendContext.getEventSet();
            this.logWarningJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(eventSet, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ EventSet $eventSet;
                {
                    this.$eventSet = $eventSet;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)RunToCursorManagerKt.access$getHitRunToCursorTimeout(), (Continuation)((Continuation)this));
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            $this$thisLogger$iv = $this$launch;
                            $i$f$thisLogger = false;
                            v1 = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                            v1.warn("Too many Run-to-Cursor hits from other threads, " + this.$eventSet);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.isTryingToPauseAnotherHitEnabled = false;
            this.resumeWaitingThreadsAndCancelWaitingJob();
            return false;
        }
        return true;
    }

    public final void saveRunToCursorHit(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        if (!this.isTryingToPauseAnotherHitEnabled) {
            suspendContext.getDebugProcess().getSuspendManager().voteResume(suspendContext);
            return;
        }
        this.waitingContexts.add(suspendContext);
        if (this.waitingJob != null) {
            return;
        }
        this.startRunToCursorTracking(suspendContext.getManagerThread());
    }

    private final void startRunToCursorTracking(DebuggerManagerThreadImpl managerThread) {
        this.waitingJob = DebuggerManagerThreadImplKt.executeOnDMT$default(managerThread, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RunToCursorManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay((long)RunToCursorManagerKt.access$getHitRunToCursorTimeout(), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        RunToCursorManager.access$dropAlreadyResumedContexts(this.this$0);
                        if (RunToCursorManager.access$getWaitingContexts$p(this.this$0).isEmpty()) {
                            RunToCursorManager.access$setWaitingJob$p(this.this$0, null);
                            return Unit.INSTANCE;
                        }
                        v1 = (SuspendContextImpl)CollectionsKt.firstOrNull((List)RunToCursorManager.access$getWaitingContexts$p(this.this$0));
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        whereToStop = v1;
                        RunToCursorManager.access$getWaitingContexts$p(this.this$0).remove((Object)whereToStop);
                        v2 = XDebuggerManagerImpl.getNotificationGroup();
                        v3 = JavaDebuggerBundle.message((String)"message.run.to.cursor.paused.in.another.thread", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                        v4 = MessageType.WARNING;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"WARNING");
                        v2.createNotification(v3, v4).notify(whereToStop.getDebugProcess().getProject());
                        whereToStop.getDebugProcess().getSuspendManager().voteSuspend(whereToStop);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void resumeWaitingThreadsAndCancelWaitingJob() {
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        Job job = this.waitingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.waitingJob = null;
        this.dropAlreadyResumedContexts();
        for (SuspendContextImpl context : this.waitingContexts) {
            context.getDebugProcess().getSuspendManager().voteResume(context);
        }
        this.waitingContexts.clear();
    }

    private final void dropAlreadyResumedContexts() {
        CollectionsKt.removeAll(this.waitingContexts, RunToCursorManager::dropAlreadyResumedContexts$lambda$0);
    }

    private static final boolean dropAlreadyResumedContexts$lambda$0(SuspendContextImpl it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.isResumed();
    }

    public static final /* synthetic */ void access$dropAlreadyResumedContexts(RunToCursorManager $this) {
        $this.dropAlreadyResumedContexts();
    }

    public static final /* synthetic */ List access$getWaitingContexts$p(RunToCursorManager $this) {
        return $this.waitingContexts;
    }

    public static final /* synthetic */ void access$setWaitingJob$p(RunToCursorManager $this, Job job) {
        $this.waitingJob = job;
    }
}

