/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger LOG = Logger.getInstance(SuspendManager.class);
    private final AtomicLong mySuspendContextNextId;
    private final Deque<SuspendContextImpl> myEventContexts;
    private final Deque<SuspendContextImpl> myPausedContexts;
    private final Set<ThreadReferenceProxyImpl> myFrozenThreads;
    protected final Set<ThreadReferenceProxyImpl> myExplicitlyResumedThreads;
    private final DebugProcessImpl myDebugProcess;
    private int suspends;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            SuspendManagerImpl.$$$reportNull$$$0(0);
        }
        this.mySuspendContextNextId = new AtomicLong();
        this.myEventContexts = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.myPausedContexts = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.myFrozenThreads = ConcurrentCollectionFactory.createConcurrentSet();
        this.myExplicitlyResumedThreads = ConcurrentCollectionFactory.createConcurrentSet();
        this.suspends = 0;
        this.myDebugProcess = debugProcess;
        this.myDebugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                if (process == null) {
                    1.$$$reportNull$$$0(0);
                }
                SuspendManagerImpl.this.myEventContexts.forEach(Disposer::dispose);
                SuspendManagerImpl.this.myEventContexts.clear();
                SuspendManagerImpl.this.myPausedContexts.forEach(Disposer::dispose);
                SuspendManagerImpl.this.myPausedContexts.clear();
                SuspendManagerImpl.this.myFrozenThreads.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/engine/SuspendManagerImpl$1", "processDetached"));
            }
        });
    }

    @Override
    @NotNull
    public SuspendContextImpl pushSuspendContext(int suspendPolicy, int nVotes) {
        SuspendContextImpl suspendContext = new SuspendContextImpl(this.myDebugProcess, suspendPolicy, nVotes, null, this.mySuspendContextNextId.incrementAndGet()){

            @Override
            protected void resumeImpl() {
                LOG.debug("Start resuming...");
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        this.getVirtualMachineProxy().resume();
                        LOG.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.myFrozenThreads.remove(this.getEventThread());
                        this.getEventThread().resume();
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("Thread resumed : " + String.valueOf(this.getEventThread()));
                        break;
                    }
                    case 0: {
                        LOG.debug("None resumed");
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
            }
        };
        this.pushContext(suspendContext);
        SuspendContextImpl suspendContextImpl = suspendContext;
        if (suspendContextImpl == null) {
            SuspendManagerImpl.$$$reportNull$$$0(1);
        }
        return suspendContextImpl;
    }

    @Override
    @NotNull
    public SuspendContextImpl pushSuspendContext(final @NotNull EventSet set) {
        if (set == null) {
            SuspendManagerImpl.$$$reportNull$$$0(2);
        }
        SuspendContextImpl suspendContext = new SuspendContextImpl(this, this.myDebugProcess, set.suspendPolicy(), set.size(), set, this.mySuspendContextNextId.incrementAndGet()){

            @Override
            protected void resumeImpl() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start resuming eventSet " + String.valueOf(set) + " suspendPolicy = " + set.suspendPolicy() + ",size = " + set.size());
                }
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        this.getVirtualMachineProxy().resumedSuspendAllContext();
                        break;
                    }
                    case 1: {
                        Objects.requireNonNull(this.getEventThread()).threadWasResumed();
                    }
                }
                DebuggerUtilsAsync.resume(set);
                LOG.debug("Set resumed ");
            }
        };
        this.pushContext(suspendContext);
        SuspendContextImpl suspendContextImpl = suspendContext;
        if (suspendContextImpl == null) {
            SuspendManagerImpl.$$$reportNull$$$0(3);
        }
        return suspendContextImpl;
    }

    private void pushContext(SuspendContextImpl suspendContext) {
        List<SuspendContextImpl> suspendAllContexts;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEventContexts.addFirst(suspendContext);
        ++this.suspends;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Push context : " + String.valueOf((Object)suspendContext));
            LOG.debug("Suspends = " + this.suspends);
        }
        if (DebuggerUtils.isAlwaysSuspendThreadBeforeSwitch() && (suspendAllContexts = this.getSuspendAllContexts()).size() > 1) {
            this.logError("More than one suspend all context: " + String.valueOf(suspendAllContexts));
        }
    }

    private void logError(String message) {
        this.myDebugProcess.logError(message);
    }

    @Override
    public void resume(@NotNull SuspendContextImpl context) {
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(4);
        }
        if (DebuggerUtils.isNewThreadSuspendStateTracking()) {
            this.resumeNew(context);
        } else {
            this.resumeOld(context);
        }
    }

    private void resumeOld(@NotNull SuspendContextImpl context) {
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(5);
        }
        SuspendManagerUtil.prepareForResume(context);
        this.popContext(context);
        context.resume(true);
        this.myDebugProcess.clearCashes(context);
    }

    private void resumeNew(@NotNull SuspendContextImpl context) {
        ThreadReferenceProxyImpl eventThread;
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(6);
        }
        if ((eventThread = context.getEventThread()) != null && this.isFrozen(eventThread)) {
            if (context.getSuspendPolicy() != 1) {
                this.logError("Suspend policy for frozen context " + String.valueOf((Object)context) + " is " + context.getSuspendPolicy());
            }
            this.myFrozenThreads.remove(eventThread);
        }
        this.popContext(context);
        Set<ThreadReferenceProxyImpl> resumedThreads = context.myResumedThreads;
        if (resumedThreads != null) {
            for (ThreadReferenceProxyImpl thread : resumedThreads) {
                thread.suspend();
            }
        }
        context.resume(true);
        this.myDebugProcess.clearCashes(context);
    }

    @Override
    public void popFrame(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(7);
        }
        boolean paused = this.hasPausedContext(suspendContext);
        this.popContext(suspendContext);
        suspendContext.resume(false);
        SuspendContextImpl newSuspendContext = this.pushSuspendContext(suspendContext.getSuspendPolicy(), 0);
        newSuspendContext.setThread(suspendContext.getEventThread().getThreadReference());
        this.notifyPaused(newSuspendContext, paused);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return this.myPausedContexts.peekFirst();
    }

    private void popContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (LOG.isDebugEnabled()) {
            LOG.debug("popContext, suspends = " + this.suspends);
        }
        this.myEventContexts.remove((Object)suspendContext);
        this.myPausedContexts.remove((Object)suspendContext);
    }

    private void pushPausedContext(SuspendContextImpl suspendContext) {
        if (!this.myEventContexts.contains((Object)suspendContext)) {
            this.logError("Suspend context " + String.valueOf((Object)suspendContext) + " was not in myEventContexts");
        }
        this.myPausedContexts.addFirst(suspendContext);
    }

    @ApiStatus.Internal
    public List<SuspendContextImpl> getEventContextsAsItIs() {
        return List.copyOf(this.myEventContexts);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        return ContainerUtil.filter(this.myEventContexts, c -> !c.isResumed());
    }

    @NotNull
    List<SuspendContextImpl> getSuspendAllContexts() {
        List list = ContainerUtil.filter(this.myEventContexts, c -> c.getSuspendPolicy() == 2 && !c.isResumed());
        if (list == null) {
            SuspendManagerImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean isFrozen(@NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(9);
        }
        return this.myFrozenThreads.contains(thread);
    }

    @Override
    public boolean isSuspended(@NotNull ThreadReferenceProxyImpl thread) throws ObjectCollectedException {
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(10);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean suspended = this.isFrozen(thread) ? true : ContainerUtil.exists(this.getEventContexts(), suspendContext -> suspendContext.suspends(thread));
        return suspended && thread.isSuspended();
    }

    @Override
    public void suspendThread(@NotNull SuspendContextImpl context, @NotNull ThreadReferenceProxyImpl thread) {
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(11);
        }
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread " + String.valueOf(thread) + " is going to be suspended in " + String.valueOf((Object)context));
        }
        if (context.isExplicitlyResumed(thread)) {
            context.myResumedThreads.remove(thread);
            context.myNotExecutableThreads.remove(thread);
            this.performIfNoNewInvocationWatcherTrackThisContext(context, () -> thread.suspend());
        } else {
            this.logError("Thread " + String.valueOf(thread) + " is trying to be suspended in " + String.valueOf((Object)context) + " but it is not in explicitly resumed threads");
        }
    }

    @Override
    public void resumeThread(@NotNull SuspendContextImpl context, @NotNull ThreadReferenceProxyImpl thread) {
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(13);
        }
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(14);
        }
        if (context.isExplicitlyResumed(thread)) {
            this.logError("Thread " + String.valueOf(thread) + " was in explicitly resumed threads for " + String.valueOf((Object)context));
        }
        if (context.getSuspendPolicy() == 1 && context.getEventThread() != thread) {
            this.logError("Suspend-thread context " + String.valueOf((Object)context) + " should not resume another thread " + String.valueOf(thread));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread " + String.valueOf(thread) + " is going to be resumed in " + String.valueOf((Object)context));
        }
        if (context.myResumedThreads == null) {
            context.myResumedThreads = ConcurrentCollectionFactory.createConcurrentSet();
        }
        context.myResumedThreads.add(thread);
        context.myNotExecutableThreads.remove(thread);
        this.performIfNoNewInvocationWatcherTrackThisContext(context, () -> thread.resume());
    }

    private void performIfNoNewInvocationWatcherTrackThisContext(@NotNull SuspendContextImpl context, @NotNull Runnable runnable) {
        ThreadBlockedMonitor.InvocationWatcherNewImpl watching;
        if (context == null) {
            SuspendManagerImpl.$$$reportNull$$$0(15);
        }
        if (runnable == null) {
            SuspendManagerImpl.$$$reportNull$$$0(16);
        }
        if ((watching = this.myDebugProcess.myThreadBlockedMonitor.myInvocationWatching) != null && watching.mySuspendAllContext == context) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No actual thread suspending/resuming happens in " + String.valueOf((Object)context) + " because of suspend all invocation is going");
            }
        } else {
            runnable.run();
        }
    }

    @Override
    public void freezeThread(@NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(17);
        }
        if (this.myFrozenThreads.add(thread)) {
            thread.suspend();
        }
    }

    @Override
    public void unfreezeThread(@NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(18);
        }
        if (this.myFrozenThreads.remove(thread)) {
            thread.resume();
        }
    }

    private void processVote(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(19);
        }
        if (suspendContext.myVotesToVote <= 0) {
            this.logError("Vote counter should be positive for " + String.valueOf((Object)suspendContext));
        }
        --suspendContext.myVotesToVote;
        if (LOG.isDebugEnabled()) {
            LOG.debug("myVotesToVote = " + suspendContext.myVotesToVote + " in " + String.valueOf((Object)suspendContext));
        }
        if (suspendContext.myVotesToVote == 0) {
            if (suspendContext.myIsVotedForResume) {
                this.scheduleResume(suspendContext);
            } else {
                boolean isSimplePause;
                EventSet eventSet;
                LOG.debug("vote paused");
                if (!Registry.is((String)"debugger.keep.step.requests")) {
                    ThreadReferenceProxyImpl thread = suspendContext.getEventThread();
                    this.myDebugProcess.deleteStepRequests(suspendContext.getVirtualMachineProxy().eventRequestManager(), thread != null ? thread.getThreadReference() : null);
                }
                boolean needSwitchToSuspendAll = false;
                if (DebuggerUtils.isAlwaysSuspendThreadBeforeSwitch() && suspendContext.getSuspendPolicy() == 1 && (eventSet = suspendContext.getEventSet()) != null) {
                    needSwitchToSuspendAll = RequestManagerImpl.hasSuspendAllRequestor(eventSet);
                }
                boolean bl = isSimplePause = !needSwitchToSuspendAll || !DebugProcessEvents.specialSuspendProcessingForAlwaysSwitch(suspendContext, this, Objects.requireNonNull(suspendContext.getEventThread()).getThreadReference());
                if (isSimplePause) {
                    this.notifyPaused(suspendContext, true);
                }
            }
        }
    }

    void scheduleResume(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(20);
        }
        if (suspendContext.myVotesToVote != 0) {
            this.logError("Explicit resuming with remain votes: " + suspendContext.myVotesToVote);
        }
        suspendContext.myIsGoingToResume = true;
        this.myPausedContexts.remove((Object)suspendContext);
        suspendContext.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> this.resume(suspendContext));
    }

    private void notifyPaused(@NotNull SuspendContextImpl suspendContext, boolean pushPaused) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(21);
        }
        if (pushPaused) {
            this.pushPausedContext(suspendContext);
        }
        DebuggerUtils.forEachSafe(this.myDebugProcess.myDebugProcessListeners, it -> it.paused((SuspendContext)suspendContext));
    }

    @Override
    public void voteResume(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(22);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resume voted for " + String.valueOf((Object)suspendContext));
        }
        this.processVote(suspendContext);
    }

    @Override
    public void voteSuspend(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SuspendManagerImpl.$$$reportNull$$$0(23);
        }
        suspendContext.myIsVotedForResume = false;
        this.processVote(suspendContext);
    }

    @Override
    @NotNull
    public List<SuspendContextImpl> getPausedContexts() {
        List<SuspendContextImpl> list = List.copyOf(this.myPausedContexts);
        if (list == null) {
            SuspendManagerImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    public boolean hasPausedContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myPausedContexts.contains((Object)suspendContext);
    }

    String getStateForDiagnostics() {
        return "myEventContexts=" + String.valueOf(this.myEventContexts) + "\nmyPausedContexts=" + String.valueOf(this.myPausedContexts) + "\nmyFrozenThreads=" + String.valueOf(this.myFrozenThreads) + "\nmyExplicitlyResumedThreads=" + String.valueOf(this.myExplicitlyResumedThreads) + "\nsuspends=" + this.suspends + "\n";
    }

    DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    void resumeAllSuspendAllContexts(@Nullable EventSet eventSet) {
        if (!DebuggerUtils.isNewThreadSuspendStateTracking()) {
            return;
        }
        List<SuspendContextImpl> suspendAllContexts = this.getSuspendAllContexts();
        if (!suspendAllContexts.isEmpty()) {
            if (eventSet == null) {
                LOG.warn("There were " + suspendAllContexts.size() + " suspend all context(s). Resuming them all");
                for (SuspendContextImpl context : suspendAllContexts) {
                    LOG.warn("  Resuming suspend all context: " + String.valueOf((Object)context));
                }
            } else if (DebugProcessImpl.isResumeOnlyCurrentThread() && suspendAllContexts.size() == 1) {
                boolean isCorrect = SuspendManagerImpl.checkResumeOnlyCurrentThreadStepping(eventSet, suspendAllContexts);
                if (!isCorrect) {
                    this.logError("Incorrect resume only current thread stepping, for " + String.valueOf(eventSet) + " in " + String.valueOf((Object)suspendAllContexts.get(0)));
                }
            } else {
                this.logError("There were " + suspendAllContexts.size() + " suspend all context(s) and new suspend all event set " + String.valueOf(eventSet) + " arrived");
            }
        }
        for (SuspendContextImpl context : suspendAllContexts) {
            this.resume(context);
        }
    }

    private static boolean checkResumeOnlyCurrentThreadStepping(@NotNull EventSet eventSet, @NotNull List<SuspendContextImpl> suspendAllContexts) {
        ThreadReferenceProxyImpl resumeOneSteppingIn;
        if (eventSet == null) {
            SuspendManagerImpl.$$$reportNull$$$0(25);
        }
        if (suspendAllContexts == null) {
            SuspendManagerImpl.$$$reportNull$$$0(26);
        }
        if ((resumeOneSteppingIn = suspendAllContexts.get((int)0).mySteppingThreadForResumeOneSteppingCurrentMode) == null) {
            return false;
        }
        StepEvent stepEvent = (StepEvent)ContainerUtil.findInstance((Iterable)eventSet, StepEvent.class);
        if (stepEvent == null) {
            return false;
        }
        ThreadReference thread = stepEvent.thread();
        return thread == resumeOneSteppingIn.getThreadReference();
    }

    @TestOnly
    public void addExplicitlyResumedThread(@NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            SuspendManagerImpl.$$$reportNull$$$0(27);
        }
        this.myExplicitlyResumedThreads.add(thread);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventSet";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendAllContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pushSuspendContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendAllContexts";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPausedContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pushSuspendContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resume";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resumeOld";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resumeNew";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "popFrame";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFrozen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSuspended";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suspendThread";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resumeThread";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performIfNoNewInvocationWatcherTrackThisContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "freezeThread";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unfreezeThread";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processVote";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scheduleResume";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "notifyPaused";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "voteResume";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "voteSuspend";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkResumeOnlyCurrentThreadStepping";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitlyResumedThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 8, 24 -> new IllegalStateException(string);
        };
    }
}

