/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.ParametersForSuspendAllReplacing;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SingleAlarm;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SuspendOtherThreadsRequestor
implements FilteredRequestor {
    @NotNull
    private final DebugProcessImpl myProcess;
    @NotNull
    private final ParametersForSuspendAllReplacing myParameters;

    private SuspendOtherThreadsRequestor(@NotNull DebugProcessImpl process, @NotNull ParametersForSuspendAllReplacing parameters) {
        if (process == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(1);
        }
        this.myProcess = process;
        this.myParameters = parameters;
    }

    public static boolean initiateTransferToSuspendAll(@NotNull SuspendContextImpl suspendContext, @NotNull @NotNull Function<@NotNull SuspendContextImpl, Boolean> performOnSuspendAll) {
        if (suspendContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(2);
        }
        if (performOnSuspendAll == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(3);
        }
        if (suspendContext.getSuspendPolicy() != 1) {
            suspendContext.getDebugProcess().logError("Replacing for all-thread mode can be done only from the suspend-thread mode. suspendContext = " + String.valueOf((Object)suspendContext));
            return false;
        }
        @NotNull DebugProcessImpl process = suspendContext.getDebugProcess();
        if (process.myPreparingToSuspendAll) {
            process.mySuspendAllListeners.add(() -> {
                process.getSuspendManager().voteResume(suspendContext);
                suspendContext.getDebugProcess().notifyStoppedOtherThreads();
            });
            return true;
        }
        process.myPreparingToSuspendAll = true;
        DebuggerUtils.HowToSwitchToSuspendAll how = DebuggerUtils.howToSwitchToSuspendAll();
        switch (how) {
            case METHOD_BREAKPOINT: {
                process.myParametersForSuspendAllReplacing = new ParametersForSuspendAllReplacing(suspendContext, performOnSuspendAll);
                EvaluationListener listener2 = SuspendOtherThreadsRequestor.addFinishEvaluationListener(process);
                boolean isSuccessTry = SuspendOtherThreadsRequestor.tryToIssueSuspendContextReplacement(process);
                if (!isSuccessTry) break;
                process.removeEvaluationListener(listener2);
                break;
            }
            case PAUSE_WAITING_EVALUATION: {
                SuspendOtherThreadsRequestor.suspendWhenNoEvaluation(suspendContext, performOnSuspendAll);
                break;
            }
            case IMMEDIATE_PAUSE: {
                suspendContext.getVirtualMachineProxy().suspend();
                SuspendOtherThreadsRequestor.switchToSuspendAll(suspendContext, performOnSuspendAll);
            }
        }
        return true;
    }

    private static void suspendWhenNoEvaluation(final @NotNull SuspendContextImpl suspendContext, final @NotNull @NotNull Function<@NotNull SuspendContextImpl, Boolean> performOnSuspendAll) {
        DebugProcessImpl process;
        if (suspendContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(4);
        }
        if (performOnSuspendAll == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(5);
        }
        if (!SuspendOtherThreadsRequestor.switchContextWithSuspend(process = suspendContext.getDebugProcess(), suspendContext, performOnSuspendAll)) {
            process.addEvaluationListener(new EvaluationListener(){

                @Override
                public void evaluationFinished(SuspendContextImpl context) {
                    if (!process.myPreparingToSuspendAll) {
                        process.removeEvaluationListener(this);
                        return;
                    }
                    if (SuspendOtherThreadsRequestor.switchContextWithSuspend(process, suspendContext, performOnSuspendAll)) {
                        process.removeEvaluationListener(this);
                    } else {
                        suspendContext.getVirtualMachineProxy().resume();
                    }
                }
            });
            suspendContext.getVirtualMachineProxy().resume();
        }
    }

    private static boolean switchContextWithSuspend(@NotNull DebugProcessImpl process, @NotNull SuspendContextImpl suspendContext, @NotNull @NotNull Function<@NotNull SuspendContextImpl, Boolean> performOnSuspendAll) {
        if (process == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(6);
        }
        if (suspendContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(7);
        }
        if (performOnSuspendAll == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(8);
        }
        suspendContext.getVirtualMachineProxy().suspend();
        if (SuspendOtherThreadsRequestor.getNumberOfEvaluations(process) == 0L) {
            SuspendOtherThreadsRequestor.switchToSuspendAll(suspendContext, performOnSuspendAll);
            return true;
        }
        return false;
    }

    static void switchToSuspendAll(@NotNull SuspendContextImpl suspendContext, @NotNull @NotNull Function<@NotNull SuspendContextImpl, Boolean> performOnSuspendAll) {
        if (suspendContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(9);
        }
        if (performOnSuspendAll == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(10);
        }
        DebugProcessImpl process = suspendContext.getDebugProcess();
        final SuspendManager suspendManager = process.getSuspendManager();
        final SuspendContextImpl newSuspendContext = suspendManager.pushSuspendContext(2, 1);
        newSuspendContext.setEventSet(suspendContext.getEventSet());
        newSuspendContext.setThread(suspendContext.getEventThread().getThreadReference());
        if (SuspendOtherThreadsRequestor.processSuspendAll(newSuspendContext, suspendContext, performOnSuspendAll)) {
            newSuspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(newSuspendContext){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DebugProcessEvents.preloadEventInfo(suspendContext.getEventThread().getThreadReference(), null);
                    suspendManager.voteSuspend(newSuspendContext);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/SuspendOtherThreadsRequestor$2", "contextAction"));
                }
            });
        } else {
            suspendManager.resume(newSuspendContext);
        }
    }

    private static void enableRequest(DebugProcessImpl process, @NotNull ParametersForSuspendAllReplacing parameters) {
        if (parameters == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(11);
        }
        SuspendOtherThreadsRequestor requestor2 = new SuspendOtherThreadsRequestor(process, parameters);
        MethodEntryRequest request = process.getRequestsManager().createMethodEntryRequest(requestor2);
        request.setSuspendPolicy(2);
        DebuggerUtilsAsync.setEnabled(request, true);
    }

    @NotNull
    private static EvaluationListener addFinishEvaluationListener(final @NotNull DebugProcessImpl process) {
        if (process == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(12);
        }
        EvaluationListener listener2 = new EvaluationListener(){

            @Override
            public void evaluationFinished(SuspendContextImpl context) {
                SuspendOtherThreadsRequestor.tryToIssueSuspendContextReplacement(process);
                if (process.myParametersForSuspendAllReplacing == null) {
                    process.removeEvaluationListener(this);
                }
            }
        };
        process.addEvaluationListener(listener2);
        EvaluationListener evaluationListener = listener2;
        if (evaluationListener == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(13);
        }
        return evaluationListener;
    }

    private static boolean tryToIssueSuspendContextReplacement(@NotNull DebugProcessImpl process) {
        if (process == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(14);
        }
        if (process.myParametersForSuspendAllReplacing == null) {
            return false;
        }
        long count = SuspendOtherThreadsRequestor.getNumberOfEvaluations(process);
        if (count != 0L) {
            return false;
        }
        ParametersForSuspendAllReplacing needToResume = process.myParametersForSuspendAllReplacing;
        if (needToResume != null) {
            process.myParametersForSuspendAllReplacing = null;
        }
        if (needToResume != null) {
            SuspendOtherThreadsRequestor.enableRequest(process, needToResume);
            return true;
        }
        return false;
    }

    private static long getNumberOfEvaluations(DebugProcessImpl process) {
        SuspendManager suspendManager = process.getSuspendManager();
        return suspendManager.getEventContexts().stream().filter(c -> c.isEvaluating()).count();
    }

    @Override
    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) {
        if (action == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(15);
        }
        this.myProcess.getRequestsManager().deleteRequest(this);
        SuspendContextImpl suspendContext = action.getSuspendContext();
        if (suspendContext == null) {
            return false;
        }
        if (SuspendOtherThreadsRequestor.getNumberOfEvaluations(this.myProcess) != 0L) {
            Logger.getInstance(SuspendOtherThreadsRequestor.class).warn("Fails attempt to switch from suspend-thread context to suspend-all context. Will be rescheduled.");
            new SingleAlarm(() -> suspendContext.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    SuspendOtherThreadsRequestor.enableRequest(SuspendOtherThreadsRequestor.this.myProcess, SuspendOtherThreadsRequestor.this.myParameters);
                }
            }), 200).request();
            return false;
        }
        return SuspendOtherThreadsRequestor.processSuspendAll(suspendContext, this.myParameters.getThreadSuspendContext(), this.myParameters.getPerformOnSuspendAll());
    }

    private static boolean processSuspendAll(@NotNull SuspendContextImpl suspendContext, @NotNull SuspendContextImpl originalContext, @NotNull @NotNull Function<@NotNull SuspendContextImpl, Boolean> performOnSuspendAll) {
        if (suspendContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(16);
        }
        if (originalContext == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(17);
        }
        if (performOnSuspendAll == null) {
            SuspendOtherThreadsRequestor.$$$reportNull$$$0(18);
        }
        if (suspendContext.getSuspendPolicy() != 2) {
            suspendContext.getDebugProcess().logError("Expected here suspend all context, but got " + String.valueOf((Object)suspendContext));
        }
        suspendContext.resetThread(Objects.requireNonNull(originalContext.getEventThread()));
        ((SuspendManagerImpl)originalContext.getDebugProcess().getSuspendManager()).scheduleResume(originalContext);
        suspendContext.mySuspendAllSwitchedContext = true;
        DebugProcessImpl process = suspendContext.getDebugProcess();
        for (Runnable listener2 : process.mySuspendAllListeners) {
            listener2.run();
        }
        process.mySuspendAllListeners.clear();
        process.myPreparingToSuspendAll = false;
        return performOnSuspendAll.apply(suspendContext);
    }

    @Override
    public String getSuspendPolicy() {
        return "SuspendAll";
    }

    @Override
    public boolean shouldIgnoreThreadFiltering() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performOnSuspendAll";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendOtherThreadsRequestor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendOtherThreadsRequestor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addFinishEvaluationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initiateTransferToSuspendAll";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suspendWhenNoEvaluation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "switchContextWithSuspend";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "switchToSuspendAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFinishEvaluationListener";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToIssueSuspendContextReplacement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processLocatableEvent";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSuspendAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

