/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface JdiValueInfo {
    public static final Set<String> COLLECTIONS_WITH_SIZE_FIELD = Set.of("java.util.ArrayList", "java.util.LinkedList", "java.util.HashMap", "java.util.TreeMap", "java.util.ImmutableCollections$SetN", "java.util.ImmutableCollections$MapN");

    @Nullable
    public static JdiValueInfo from(@NotNull Value value, @NotNull Predicate<? super ClassLoaderReference> classLoaderFilter) {
        if (value == null) {
            JdiValueInfo.$$$reportNull$$$0(0);
        }
        if (classLoaderFilter == null) {
            JdiValueInfo.$$$reportNull$$$0(1);
        }
        return JdiValueInfo.from(value, classLoaderFilter, true);
    }

    @Nullable
    private static JdiValueInfo from(@NotNull Value value, @NotNull Predicate<? super ClassLoaderReference> classLoaderFilter, boolean fillSpecial) {
        DfaAssistProvider.BoxedValue boxedValue;
        DfConstantType<?> wrappedConstant;
        DfConstantType<?> constant;
        if (value == null) {
            JdiValueInfo.$$$reportNull$$$0(2);
        }
        if (classLoaderFilter == null) {
            JdiValueInfo.$$$reportNull$$$0(3);
        }
        if ((constant = JdiValueInfo.primitiveConstant(value)) != null) {
            return new PrimitiveConstant(constant);
        }
        if (value instanceof StringReference) {
            StringReference stringReference = (StringReference)value;
            return new StringConstant(stringReference.value());
        }
        if (value instanceof DfaAssistProvider.BoxedValue && (wrappedConstant = JdiValueInfo.primitiveConstant((boxedValue = (DfaAssistProvider.BoxedValue)value).getValue())) != null) {
            return new ObjectWithSpecialField(boxedValue.getType(), SpecialField.UNBOX, new PrimitiveConstant(wrappedConstant));
        }
        if (value instanceof ObjectReference) {
            ObjectReference ref = (ObjectReference)value;
            ReferenceType type = ref.referenceType();
            if (!classLoaderFilter.test(type.classLoader())) {
                return null;
            }
            String name = type.name();
            String enumConstantName = JdiValueInfo.getEnumConstantName(ref);
            if (enumConstantName != null) {
                return new EnumConstant(type, enumConstantName);
            }
            if (fillSpecial) {
                JdiValueInfo wrappedInfo;
                Value wrappedValue;
                if (value instanceof ArrayReference) {
                    PrimitiveConstant length = new PrimitiveConstant((DfConstantType<?>)DfTypes.intValue((int)((ArrayReference)value).length()));
                    return new ObjectWithSpecialField(type, SpecialField.ARRAY_LENGTH, length);
                }
                if (name.startsWith("java.util.Collections$Empty")) {
                    return JdiValueInfo.collectionWithSize(type, 0);
                }
                if (name.startsWith("java.util.Collections$Singleton")) {
                    return JdiValueInfo.collectionWithSize(type, 1);
                }
                if (COLLECTIONS_WITH_SIZE_FIELD.contains(name)) {
                    Value size = JdiValueInfo.getField(ref, "size");
                    if (size instanceof IntegerValue) {
                        return JdiValueInfo.collectionWithSize(type, ((IntegerValue)size).value());
                    }
                } else if ("java.util.ImmutableCollections$ListN".equals(name)) {
                    Value elements = JdiValueInfo.getField(ref, "elements");
                    if (elements instanceof ArrayReference) {
                        return JdiValueInfo.collectionWithSize(type, ((ArrayReference)elements).length());
                    }
                } else if ("java.util.Arrays$ArrayList".equals(name)) {
                    Value elements = JdiValueInfo.getField(ref, "a");
                    if (elements instanceof ArrayReference) {
                        return JdiValueInfo.collectionWithSize(type, ((ArrayReference)elements).length());
                    }
                } else if ("java.util.HashSet".equals(name) || "java.util.TreeSet".equals(name)) {
                    Value size;
                    Value map2 = JdiValueInfo.getField(ref, "java.util.HashSet".equals(name) ? "map" : "m");
                    if (map2 instanceof ObjectReference && (size = JdiValueInfo.getField((ObjectReference)map2, "size")) instanceof IntegerValue) {
                        return JdiValueInfo.collectionWithSize(type, ((IntegerValue)size).value());
                    }
                } else if (TypeConversionUtil.isPrimitiveWrapper((String)name)) {
                    DfConstantType<?> wrappedConstant2 = JdiValueInfo.primitiveConstant(JdiValueInfo.getField(ref, "value"));
                    if (wrappedConstant2 != null) {
                        return new ObjectWithSpecialField(type, SpecialField.UNBOX, new PrimitiveConstant(wrappedConstant2));
                    }
                } else if ("java.util.Optional".equals(name) && (wrappedValue = JdiValueInfo.getField(ref, "value")) != null && (wrappedInfo = JdiValueInfo.from(wrappedValue, classLoaderFilter, false)) != null) {
                    return new ObjectWithSpecialField(type, SpecialField.OPTIONAL_VALUE, wrappedInfo);
                }
            }
            return new ObjectRef(type);
        }
        return null;
    }

    @NotNull
    private static ObjectWithSpecialField collectionWithSize(ReferenceType type, int size) {
        PrimitiveConstant length = new PrimitiveConstant((DfConstantType<?>)DfTypes.intValue((int)size));
        return new ObjectWithSpecialField(type, SpecialField.COLLECTION_SIZE, length);
    }

    @Nullable
    private static Value getField(@NotNull ObjectReference object, @NotNull String name) {
        Field field;
        if (object == null) {
            JdiValueInfo.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JdiValueInfo.$$$reportNull$$$0(5);
        }
        if ((field = DebuggerUtils.findField((ReferenceType)object.referenceType(), (String)name)) == null) {
            return null;
        }
        return object.getValue(field);
    }

    private static String getEnumConstantName(ObjectReference ref) {
        ReferenceType type = ref.referenceType();
        if (!(type instanceof ClassType) || !((ClassType)type).isEnum()) {
            return null;
        }
        ClassType superclass = ((ClassType)type).superclass();
        if (superclass == null) {
            return null;
        }
        if (!superclass.name().equals("java.lang.Enum")) {
            superclass = superclass.superclass();
        }
        if (superclass == null || !superclass.name().equals("java.lang.Enum")) {
            return null;
        }
        Field nameField = DebuggerUtils.findField((ReferenceType)superclass, (String)"name");
        if (nameField == null) {
            return null;
        }
        Value nameValue = ref.getValue(nameField);
        return nameValue instanceof StringReference ? ((StringReference)nameValue).value() : null;
    }

    @Nullable
    private static DfConstantType<?> primitiveConstant(@Nullable Value jdiValue) {
        if (jdiValue == DfaAssistProvider.NullConst) {
            return DfTypes.NULL;
        }
        if (jdiValue instanceof BooleanValue) {
            return DfTypes.booleanValue((boolean)((BooleanValue)jdiValue).value());
        }
        if (jdiValue instanceof LongValue) {
            return DfTypes.longValue((long)((LongValue)jdiValue).longValue());
        }
        if (jdiValue instanceof ShortValue || jdiValue instanceof CharValue || jdiValue instanceof ByteValue || jdiValue instanceof IntegerValue) {
            return DfTypes.intValue((int)((PrimitiveValue)jdiValue).intValue());
        }
        if (jdiValue instanceof FloatValue) {
            return DfTypes.floatValue((float)((FloatValue)jdiValue).floatValue());
        }
        if (jdiValue instanceof DoubleValue) {
            return DfTypes.doubleValue((double)((DoubleValue)jdiValue).doubleValue());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoaderFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "from";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PrimitiveConstant
    implements JdiValueInfo {
        private final DfConstantType<?> myDfType;

        private PrimitiveConstant(DfConstantType<?> type) {
            this.myDfType = type;
        }

        public DfConstantType<?> getDfType() {
            return this.myDfType;
        }
    }

    public static class StringConstant
    implements JdiValueInfo {
        @NotNull
        private final String myValue;

        StringConstant(@NotNull String value) {
            if (value == null) {
                StringConstant.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                StringConstant.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$StringConstant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$StringConstant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class ObjectWithSpecialField
    extends ObjectRef {
        @NotNull
        private final SpecialField myField;
        @NotNull
        private final JdiValueInfo myValue;

        ObjectWithSpecialField(@NotNull ReferenceType type, @NotNull SpecialField field, @NotNull JdiValueInfo value) {
            if (type == null) {
                ObjectWithSpecialField.$$$reportNull$$$0(0);
            }
            if (field == null) {
                ObjectWithSpecialField.$$$reportNull$$$0(1);
            }
            if (value == null) {
                ObjectWithSpecialField.$$$reportNull$$$0(2);
            }
            super(type);
            this.myField = field;
            this.myValue = value;
        }

        @NotNull
        public SpecialField getField() {
            SpecialField specialField = this.myField;
            if (specialField == null) {
                ObjectWithSpecialField.$$$reportNull$$$0(3);
            }
            return specialField;
        }

        @NotNull
        public JdiValueInfo getValue() {
            JdiValueInfo jdiValueInfo = this.myValue;
            if (jdiValueInfo == null) {
                ObjectWithSpecialField.$$$reportNull$$$0(4);
            }
            return jdiValueInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$ObjectWithSpecialField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$ObjectWithSpecialField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class EnumConstant
    extends ObjectRef {
        @NotNull
        private final String myName;

        EnumConstant(@NotNull ReferenceType type, @NotNull String name) {
            if (type == null) {
                EnumConstant.$$$reportNull$$$0(0);
            }
            if (name == null) {
                EnumConstant.$$$reportNull$$$0(1);
            }
            super(type);
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                EnumConstant.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$EnumConstant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$EnumConstant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ObjectRef
    implements JdiValueInfo {
        @NotNull
        private final String mySignature;

        ObjectRef(@NotNull ReferenceType type) {
            if (type == null) {
                ObjectRef.$$$reportNull$$$0(0);
            }
            this.mySignature = type.signature();
        }

        @NotNull
        public String getSignature() {
            String string = this.mySignature;
            if (string == null) {
                ObjectRef.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$ObjectRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/JdiValueInfo$ObjectRef";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

