/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PatternEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeconstructionPatternEvaluator
extends PatternEvaluator {
    @NotNull
    private final List<PatternEvaluator> myComponentEvaluators;
    @NotNull
    private final List<String> myRecordComponentNames;

    public DeconstructionPatternEvaluator(@NotNull TypeEvaluator typeEvaluator, @Nullable SyntheticVariableEvaluator variableEvaluator, @NotNull List<PatternEvaluator> componentEvaluators, @NotNull List<String> recordComponentNames) {
        if (typeEvaluator == null) {
            DeconstructionPatternEvaluator.$$$reportNull$$$0(0);
        }
        if (componentEvaluators == null) {
            DeconstructionPatternEvaluator.$$$reportNull$$$0(1);
        }
        if (recordComponentNames == null) {
            DeconstructionPatternEvaluator.$$$reportNull$$$0(2);
        }
        super(typeEvaluator, variableEvaluator);
        this.myComponentEvaluators = componentEvaluators;
        this.myRecordComponentNames = recordComponentNames;
    }

    @Override
    boolean match(Value value, EvaluationContextImpl context) throws EvaluateException {
        if (value instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value;
            if (this.myComponentEvaluators.size() == this.myRecordComponentNames.size()) {
                assert (this.myTypeEvaluator != null);
                ReferenceType refType = objRef.referenceType();
                boolean res = DebuggerUtilsImpl.instanceOf(refType, this.myTypeEvaluator.evaluate(context));
                for (int i = 0; i < this.myComponentEvaluators.size() && res; ++i) {
                    PatternEvaluator componentEvaluator = this.myComponentEvaluators.get(i);
                    Field field = DebuggerUtils.findField((ReferenceType)refType, (String)this.myRecordComponentNames.get(i));
                    res = componentEvaluator.match(objRef.getValue(field), context);
                }
                if (res && this.myVariableEvaluator != null) {
                    AssignmentEvaluator.assign(this.myVariableEvaluator.evaluateModifiable(context).getModifier(), value, context);
                }
                return res;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (PatternEvaluator componentEvaluator : this.myComponentEvaluators) {
            joiner.add(componentEvaluator.toString());
        }
        return String.valueOf(this.myTypeEvaluator) + "(" + String.valueOf(joiner) + ") " + String.valueOf(this.myVariableEvaluator != null ? this.myVariableEvaluator : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "typeEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "componentEvaluators";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "recordComponentNames";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/DeconstructionPatternEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

