/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExternalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance(ExpressionEvaluator.class);
    private final Evaluator myEvaluator;

    public ExpressionEvaluatorImpl(Evaluator evaluator) {
        this.myEvaluator = evaluator;
    }

    public Modifier getModifier() {
        return this.myEvaluator.getModifier();
    }

    public Value evaluate(EvaluationContext context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]));
        }
        try {
            if (context.getFrameProxy() == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)context;
            Object value = evaluationContextImpl.isMayRetryEvaluation() ? DebuggerUtils.getInstance().processCollectibleValue(() -> this.myEvaluator.evaluate(evaluationContextImpl), r -> {
                if (r instanceof Value) {
                    Value v = (Value)r;
                    evaluationContextImpl.keep(v);
                }
                return r;
            }, context) : this.myEvaluator.evaluate(evaluationContextImpl);
            if (value != null && !(value instanceof Value)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{""}));
            }
            return (Value)value;
        }
        catch (ReturnEvaluator.ReturnException r2) {
            return (Value)r2.getReturnValue();
        }
        catch (Throwable e) {
            LOG.debug(e);
            if (e instanceof EvaluateException) {
                throw (EvaluateException)e;
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public boolean isExternalEvaluator() {
        return this.myEvaluator instanceof ExternalExpressionEvaluator;
    }
}

