/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluatorBase;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class ForeachStatementEvaluator
implements Evaluator {
    private final Evaluator myIterationParameterEvaluator;
    private final Evaluator myIterableEvaluator;
    private final Evaluator myBodyEvaluator;
    private final String myLabelName;

    public ForeachStatementEvaluator(Evaluator iterationParameterEvaluator, Evaluator iterableEvaluator, Evaluator bodyEvaluator, String labelName) {
        this.myIterationParameterEvaluator = iterationParameterEvaluator;
        this.myIterableEvaluator = DisableGC.create(iterableEvaluator);
        this.myBodyEvaluator = bodyEvaluator;
        this.myLabelName = labelName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        final Object iterable = this.myIterableEvaluator.evaluate(context);
        if (!(iterable instanceof ObjectReference)) {
            throw new EvaluateException("Unable to do foreach for" + String.valueOf(iterable));
        }
        if (iterable instanceof ArrayReference) {
            return new ForStatementEvaluatorBase(this.myLabelName, this.myBodyEvaluator){
                private int myCurrentIndex;
                private int myArrayLength;
                private Evaluator myNextEvaluator;
                {
                    super(labelName, bodyEvaluator);
                    this.myCurrentIndex = 0;
                    this.myArrayLength = -1;
                }

                @Override
                protected Object evaluateInitialization(EvaluationContextImpl context, Object value) throws EvaluateException {
                    this.myArrayLength = ((ArrayReference)iterable).length();
                    this.myNextEvaluator = new AssignmentEvaluator(ForeachStatementEvaluator.this.myIterationParameterEvaluator, new Evaluator(){

                        @Override
                        public Object evaluate(EvaluationContextImpl context) {
                            return ((ArrayReference)iterable).getValue(myCurrentIndex++);
                        }
                    });
                    return value;
                }

                @Override
                protected Object evaluateCondition(EvaluationContextImpl context) {
                    return this.myCurrentIndex < this.myArrayLength;
                }

                @Override
                protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
                    this.myNextEvaluator.evaluate(context);
                    super.evaluateBody(context);
                }
            }.evaluate(context);
        }
        return new ForStatementEvaluatorBase(this.myLabelName, this.myBodyEvaluator){
            private MethodEvaluator myConditionEvaluator;
            private AssignmentEvaluator myNextEvaluator;

            @Override
            protected Object evaluateInitialization(EvaluationContextImpl context, Object value) throws EvaluateException {
                Object iterator = new MethodEvaluator(new IdentityEvaluator((Value)iterable), JVMNameUtil.getJVMRawText("java.lang.Iterable"), "iterator", null, new Evaluator[0]).evaluate(context);
                IdentityEvaluator iteratorEvaluator = new IdentityEvaluator((Value)iterator);
                this.myConditionEvaluator = new MethodEvaluator(iteratorEvaluator, JVMNameUtil.getJVMRawText("java.util.Iterator"), "hasNext", null, new Evaluator[0]);
                this.myNextEvaluator = new AssignmentEvaluator(ForeachStatementEvaluator.this.myIterationParameterEvaluator, new MethodEvaluator(iteratorEvaluator, JVMNameUtil.getJVMRawText("java.util.Iterator"), "next", null, new Evaluator[0]));
                return value;
            }

            @Override
            protected Object evaluateCondition(EvaluationContextImpl context) throws EvaluateException {
                return this.myConditionEvaluator.evaluate(context);
            }

            @Override
            protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
                this.myNextEvaluator.evaluate(context);
                super.evaluateBody(context);
            }
        }.evaluate(context);
    }
}

