/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jdi.MethodImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class MethodEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(MethodEvaluator.class);
    private final JVMName myClassName;
    private final JVMName myMethodSignature;
    private final String myMethodName;
    private final Evaluator[] myArgumentEvaluators;
    private final Evaluator myObjectEvaluator;
    private final boolean myMustBeVararg;
    private final boolean myLastArgumentIsNotArray;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators) {
        this(objectEvaluator, className, methodName, signature, argumentEvaluators, false, false);
    }

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators, boolean mustBeVararg, boolean lastArgumentIsNotArray) {
        this.myObjectEvaluator = DisableGC.create(objectEvaluator);
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myMethodSignature = signature;
        this.myArgumentEvaluators = argumentEvaluators;
        this.myMustBeVararg = mustBeVararg;
        this.myLastArgumentIsNotArray = lastArgumentIsNotArray;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        boolean requiresSuperObject = DisableGC.unwrap(this.myObjectEvaluator) instanceof SuperEvaluator;
        Object object = this.myObjectEvaluator.evaluate(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MethodEvaluator: object = " + String.valueOf(object));
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !MethodEvaluator.isInvokableType(object)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.myMethodName}));
        }
        ArrayList<Value> args = new ArrayList<Value>(this.myArgumentEvaluators.length);
        for (Evaluator evaluator : this.myArgumentEvaluators) {
            args.add((Value)evaluator.evaluate(context));
        }
        try {
            String signature;
            ReferenceType referenceType = null;
            if (object instanceof ObjectReference) {
                referenceType = ((ObjectReference)object).referenceType();
            } else if (MethodEvaluator.isInvokableType(object)) {
                referenceType = (ReferenceType)object;
            }
            if (referenceType == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.myMethodName})));
            }
            String string = signature = this.myMethodSignature != null ? this.myMethodSignature.getName(debugProcess) : null;
            if (requiresSuperObject && referenceType instanceof ClassType) {
                String className;
                referenceType = ((ClassType)referenceType).superclass();
                String string2 = className = this.myClassName != null ? this.myClassName.getName(debugProcess) : null;
                if (referenceType == null || className != null && !className.equals(referenceType.name())) {
                    referenceType = debugProcess.findClass(context, className, context.getClassLoader());
                }
            }
            Method jdiMethod = null;
            if (signature == null) {
                List matchingMethods = ((StreamEx)StreamEx.of(referenceType.methodsByName(this.myMethodName)).filter(m -> m.argumentTypeNames().size() == args.size())).toList();
                if (matchingMethods.size() == 1) {
                    jdiMethod = (Method)matchingMethods.get(0);
                } else if (matchingMethods.size() > 1) {
                    jdiMethod = (Method)ContainerUtil.find((Iterable)matchingMethods, m -> MethodEvaluator.matchArgs(m, args));
                }
            }
            if (jdiMethod == null) {
                jdiMethod = DebuggerUtils.findMethod((ReferenceType)referenceType, (String)this.myMethodName, (String)signature);
            }
            if (jdiMethod == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{this.myMethodName}));
            }
            if (this.myMustBeVararg || jdiMethod.isVarArgs()) {
                this.handleVarargs(jdiMethod, args, context);
            }
            if (signature == null) {
                MethodEvaluator.argsConversions(jdiMethod, args, context);
            }
            if (MethodEvaluator.isInvokableType(object)) {
                if (MethodEvaluator.isInvokableType(referenceType) && jdiMethod.isStatic()) {
                    if (referenceType instanceof ClassType) {
                        return debugProcess.invokeMethod((EvaluationContext)context, (ClassType)referenceType, jdiMethod, args);
                    }
                    return debugProcess.invokeMethod((EvaluationContext)context, (InterfaceType)referenceType, jdiMethod, args);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{DebuggerUtilsEx.methodName(referenceType.name(), this.myMethodName, signature)}));
            }
            ObjectReference objRef = (ObjectReference)object;
            if (requiresSuperObject) {
                return debugProcess.invokeInstanceMethod(context, objRef, jdiMethod, args, 2);
            }
            return debugProcess.invokeMethod((EvaluationContext)context, objRef, jdiMethod, args);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private void handleVarargs(@NotNull Method jdiMethod, @NotNull List<Value> args, @NotNull EvaluationContextImpl context) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
        Type nthArgType;
        if (jdiMethod == null) {
            MethodEvaluator.$$$reportNull$$$0(0);
        }
        if (args == null) {
            MethodEvaluator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MethodEvaluator.$$$reportNull$$$0(2);
        }
        int paramCount = jdiMethod.argumentTypeNames().size();
        ArrayType lastParamType = MethodEvaluator.getLastParameterArrayType(jdiMethod, context);
        int argCount = args.size();
        if (argCount < paramCount - 1) {
            return;
        }
        if (argCount == paramCount - 1) {
            args.add(DebuggerUtilsEx.mirrorOfArray(lastParamType, 0, (EvaluationContext)context));
            return;
        }
        Value nthArgValue = args.get(paramCount - 1);
        if (nthArgValue == null && argCount == paramCount) {
            if (this.myLastArgumentIsNotArray) {
                args.set(paramCount - 1, DebuggerUtilsEx.mirrorOfArray(lastParamType, 1, (EvaluationContext)context));
            }
            return;
        }
        Type type = nthArgType = nthArgValue == null ? null : nthArgValue.type();
        if (nthArgType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)nthArgType;
            if (argCount == paramCount && DebuggerUtilsImpl.instanceOf(arrayType, lastParamType)) {
                return;
            }
        }
        int count = argCount - paramCount + 1;
        ArrayReference argArray = DebuggerUtilsEx.mirrorOfArray(lastParamType, count, (EvaluationContext)context);
        argArray.setValues(0, args, paramCount - 1, count);
        args.set(paramCount - 1, argArray);
        if (argCount > paramCount) {
            args.subList(paramCount, argCount).clear();
        }
    }

    private static ArrayType getLastParameterArrayType(@NotNull Method jdiMethod, @NotNull EvaluationContextImpl context) throws ClassNotLoadedException, EvaluateException, InvalidTypeException {
        if (jdiMethod == null) {
            MethodEvaluator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            MethodEvaluator.$$$reportNull$$$0(4);
        }
        int paramCount = jdiMethod.argumentTypeNames().size();
        if (jdiMethod instanceof MethodImpl) {
            MethodImpl methodImpl = (MethodImpl)jdiMethod;
            try {
                String paramSignature = (String)methodImpl.argumentSignatures().get(paramCount - 1);
                return (ArrayType)methodImpl.findType(paramSignature);
            }
            catch (ClassNotLoadedException e) {
                try {
                    return (ArrayType)context.getDebugProcess().loadClass(context, e, jdiMethod.declaringType().classLoader());
                }
                catch (IncompatibleThreadStateException | InvocationException ex) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)ex);
                }
            }
        }
        return (ArrayType)jdiMethod.argumentTypes().get(paramCount - 1);
    }

    private static boolean matchArgs(Method m, List<Value> args) {
        try {
            List<Type> argumentTypes = m.argumentTypes();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Type argType;
                Type expectedArgType = argumentTypes.get(i);
                if (expectedArgType.equals(argType = args.get(i).type()) || expectedArgType instanceof ReferenceType && (argType == null || !(argType instanceof PrimitiveType) && argType instanceof ReferenceType && DebuggerUtilsImpl.instanceOf((ReferenceType)argType, (ReferenceType)expectedArgType))) continue;
                return false;
            }
        }
        catch (ClassNotLoadedException ignored) {
            return false;
        }
        return true;
    }

    private static void argsConversions(Method jdiMethod, List<Value> args, EvaluationContextImpl context) throws EvaluateException {
        List<String> typeNames;
        int size;
        if (!jdiMethod.isVarArgs() && (size = (typeNames = jdiMethod.argumentTypeNames()).size()) == args.size()) {
            for (int i = 0; i < size; ++i) {
                Value arg = args.get(i);
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)typeNames.get(i));
                if (primitiveType == null && arg.type() instanceof PrimitiveType) {
                    args.set(i, (Value)BoxingEvaluator.box(arg, context));
                    continue;
                }
                if (primitiveType == null || arg.type() instanceof PrimitiveType) continue;
                args.set(i, (Value)UnBoxingEvaluator.unbox(arg, context));
            }
        }
    }

    private static boolean isInvokableType(Object type) {
        return type instanceof ClassType || type instanceof InterfaceType;
    }

    public String toString() {
        return "call " + this.myMethodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/MethodEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleVarargs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastParameterArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

