/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class NewClassInstanceEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(NewClassInstanceEvaluator.class);
    private final TypeEvaluator myClassTypeEvaluator;
    private final JVMName myConstructorSignature;
    private final Evaluator[] myParamsEvaluators;

    NewClassInstanceEvaluator(TypeEvaluator classTypeEvaluator, JVMName constructorSignature, Evaluator[] argumentEvaluators) {
        this.myClassTypeEvaluator = classTypeEvaluator;
        this.myConstructorSignature = constructorSignature;
        this.myParamsEvaluators = argumentEvaluators;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        ObjectReference objRef;
        List arguments;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        ReferenceType obj = this.myClassTypeEvaluator.evaluate(context);
        if (!(obj instanceof ClassType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.class.type", (Object[])new Object[0]));
        }
        ClassType classType = (ClassType)obj;
        Method method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"<init>", (String)this.myConstructorSignature.getName(debugProcess));
        if (method == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{this.myConstructorSignature.getDisplayName(debugProcess)}));
        }
        if (!ArrayUtil.isEmpty((Object[])this.myParamsEvaluators)) {
            arguments = new ArrayList(this.myParamsEvaluators.length);
            for (Evaluator evaluator : this.myParamsEvaluators) {
                Object res = evaluator.evaluate(context);
                if (!(res instanceof Value) && res != null) {
                    LOG.error("Unable to call newInstance, evaluator " + String.valueOf(evaluator) + " result is not Value, but " + String.valueOf(res));
                }
                arguments.add((Value)res);
            }
        } else {
            arguments = Collections.emptyList();
        }
        try {
            objRef = debugProcess.newInstance(context, classType, method, arguments);
        }
        catch (EvaluateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        return objRef;
    }
}

