/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.PatternLabelEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SwitchEvaluator
implements Evaluator {
    private final Evaluator myExpressionEvaluator;
    private final Evaluator[] myBodyEvaluators;
    private final String myLabelName;

    public SwitchEvaluator(Evaluator expressionEvaluator, Evaluator[] bodyEvaluators, @Nullable String labelName) {
        this.myExpressionEvaluator = expressionEvaluator;
        this.myBodyEvaluators = bodyEvaluators;
        this.myLabelName = labelName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object res;
        block10: {
            Object switchValue = this.myExpressionEvaluator.evaluate(context);
            Object unboxedSwitchValue = switchValue != null ? UnBoxingEvaluator.unbox(switchValue, context) : null;
            res = null;
            try {
                Evaluator e;
                Evaluator evaluator;
                int i;
                boolean caseFound = false;
                int defaultLabelNum = -1;
                for (i = 0; i < this.myBodyEvaluators.length; ++i) {
                    evaluator = this.myBodyEvaluators[i];
                    if (caseFound) {
                        res = evaluator.evaluate(context);
                        continue;
                    }
                    e = DisableGC.unwrap(evaluator);
                    if (!(e instanceof SwitchCaseEvaluator)) continue;
                    SwitchCaseEvaluator caseEvaluator = (SwitchCaseEvaluator)e;
                    if (caseEvaluator.myDefaultCase) {
                        defaultLabelNum = i;
                        continue;
                    }
                    res = caseEvaluator.match(unboxedSwitchValue, context);
                    if (Boolean.TRUE.equals(res)) {
                        caseFound = true;
                        continue;
                    }
                    if (!(res instanceof Value)) continue;
                    return res;
                }
                if (!caseFound && defaultLabelNum != -1) {
                    for (i = defaultLabelNum; i < this.myBodyEvaluators.length; ++i) {
                        evaluator = this.myBodyEvaluators[i];
                        if (caseFound) {
                            res = evaluator.evaluate(context);
                            continue;
                        }
                        caseFound = true;
                        e = DisableGC.unwrap(evaluator);
                        if (!(e instanceof SwitchCaseEvaluator) || !((res = ((SwitchCaseEvaluator)e).match(unboxedSwitchValue, context)) instanceof Value)) continue;
                        return res;
                    }
                }
            }
            catch (YieldException e) {
                return e.getValue();
            }
            catch (BreakException e) {
                if (Objects.equals(e.getLabelName(), this.myLabelName)) break block10;
                throw e;
            }
        }
        return res;
    }

    static class SwitchCaseEvaluator
    implements Evaluator {
        final List<? extends Evaluator> myEvaluators;
        @Nullable
        final Evaluator myGuardEvaluator;
        final boolean myDefaultCase;

        SwitchCaseEvaluator(List<? extends Evaluator> evaluators, @Nullable Evaluator guardEvaluator, boolean defaultCase) {
            this.myEvaluators = evaluators;
            this.myGuardEvaluator = guardEvaluator;
            this.myDefaultCase = defaultCase;
        }

        Object match(Object value, EvaluationContextImpl context) throws EvaluateException {
            if (this.myDefaultCase && value != null) {
                return true;
            }
            for (Evaluator evaluator : this.myEvaluators) {
                Object labelValue;
                Object unboxedLabelValue;
                BooleanValue bool;
                Object object;
                if (!(evaluator instanceof PatternLabelEvaluator ? ((BooleanValue)evaluator.evaluate(context)).booleanValue() && (this.myGuardEvaluator == null || (object = this.myGuardEvaluator.evaluate(context)) instanceof BooleanValue && (bool = (BooleanValue)object).booleanValue()) : SwitchCaseEvaluator.resultsEquals(value, unboxedLabelValue = (labelValue = evaluator.evaluate(context)) != null ? UnBoxingEvaluator.unbox(labelValue, context) : null))) continue;
                return true;
            }
            return false;
        }

        static boolean resultsEquals(Object val1, Object val2) {
            if (val1 == null || val2 == null) {
                return val1 == val2;
            }
            if (val1 instanceof StringReference && val2 instanceof StringReference) {
                return ((StringReference)val1).value().equals(((StringReference)val2).value());
            }
            return val1.equals(val2);
        }

        @Override
        public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
            return null;
        }
    }

    static class YieldException
    extends EvaluateException {
        final Object myValue;

        YieldException(Object value) {
            super("Yield");
            this.myValue = value;
        }

        public Object getValue() {
            return this.myValue;
        }
    }

    static class YieldEvaluator
    implements Evaluator {
        @Nullable
        final Evaluator myValueEvaluator;

        YieldEvaluator(@Nullable Evaluator valueEvaluator) {
            this.myValueEvaluator = valueEvaluator;
        }

        @Override
        public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
            Object value = this.myValueEvaluator == null ? context.getVirtualMachineProxy().mirrorOfVoid() : this.myValueEvaluator.evaluate(context);
            throw new YieldException(value);
        }
    }

    static class SwitchCaseRuleEvaluator
    extends SwitchCaseEvaluator {
        final Evaluator myBodyEvaluator;

        SwitchCaseRuleEvaluator(List<? extends Evaluator> evaluators, @Nullable Evaluator guardEvaluator, boolean defaultCase, Evaluator bodyEvaluator) {
            super(evaluators, guardEvaluator, defaultCase);
            this.myBodyEvaluator = bodyEvaluator;
        }

        @Override
        Object match(Object value, EvaluationContextImpl context) throws EvaluateException {
            Object res = super.match(value, context);
            if (Boolean.TRUE.equals(res)) {
                return this.myBodyEvaluator.evaluate(context);
            }
            return res;
        }
    }
}

