/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(TypeEvaluator.class);
    private final JVMName myTypeName;

    public TypeEvaluator(@NotNull JVMName typeName) {
        if (typeName == null) {
            TypeEvaluator.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
    }

    @Override
    @NotNull
    public ReferenceType evaluate(EvaluationContextImpl context) throws EvaluateException {
        ReferenceType type;
        ClassLoaderReference classLoader = context.getClassLoader();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        String typeName = this.myTypeName.getName(debugProcess);
        try {
            type = debugProcess.findClass(context, typeName, classLoader);
        }
        catch (EvaluateException e) {
            ReferenceType singleLoadedClass = (ReferenceType)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter(context.getVirtualMachineProxy().classesByName(typeName), ReferenceType::isPrepared));
            if (singleLoadedClass == null) {
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to find or load class " + typeName + " in the requested classloader " + String.valueOf(classLoader) + ", will use the single loaded class " + String.valueOf(singleLoadedClass) + " from " + String.valueOf(singleLoadedClass.classLoader()));
            }
            type = singleLoadedClass;
        }
        if (type == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{typeName}));
        }
        ReferenceType referenceType = type;
        if (referenceType == null) {
            TypeEvaluator.$$$reportNull$$$0(1);
        }
        return referenceType;
    }

    public String toString() {
        return "Type " + String.valueOf(this.myTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/TypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/TypeEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

