/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.InstrumentationBreakpointState;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.StepRequestor;
import com.intellij.debugger.engine.requests.SuspendingRequestor;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestManagerImpl
extends DebugProcessAdapterImpl
implements RequestManager {
    private static final Logger LOG = Logger.getInstance(RequestManagerImpl.class);
    private static final Key CLASS_NAME = Key.create((String)"ClassName");
    private static final Key<Requestor> REQUESTOR = Key.create((String)"Requestor");
    private final DebugProcessImpl myDebugProcess;
    private final Map<Requestor, String> myRequestWarnings = new HashMap<Requestor, String>();
    private final Map<Requestor, Set<EventRequest>> myRequestorToBelongedRequests = new HashMap<Requestor, Set<EventRequest>>();
    private EventRequestManager myEventRequestManager;
    private final Map<Requestor, InstrumentationBreakpointState> myInstrumentationInfo = new HashMap<Requestor, InstrumentationBreakpointState>();
    @Nullable
    private LightOrRealThreadInfo myFilterThread;

    public RequestManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
        this.myDebugProcess.addDebugProcessListener(this);
    }

    public EventRequestManager getVMRequestManager() {
        return this.myEventRequestManager;
    }

    @Nullable
    public LightOrRealThreadInfo getFilterThread() {
        return this.myFilterThread;
    }

    @Nullable
    public ThreadReference getFilterRealThread() {
        return this.myFilterThread != null ? this.myFilterThread.getRealThread() : null;
    }

    public void setThreadFilter(@Nullable LightOrRealThreadInfo filter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread filter is set to " + String.valueOf(filter));
        }
        this.myFilterThread = filter;
    }

    public Set<EventRequest> findRequests(Requestor requestor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set<EventRequest> requestSet = this.myRequestorToBelongedRequests.get(requestor2);
        if (requestSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(requestSet);
    }

    @Nullable
    public static Requestor findRequestor(EventRequest request) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return request != null ? (Requestor)request.getProperty(REQUESTOR) : null;
    }

    public static boolean hasSuspendAllRequestor(@NotNull EventSet eventSet) {
        if (eventSet == null) {
            RequestManagerImpl.$$$reportNull$$$0(0);
        }
        return ContainerUtil.exists((Iterable)eventSet, e -> {
            SuspendingRequestor sr;
            Requestor requestor2 = RequestManagerImpl.findRequestor(e.request());
            return requestor2 instanceof SuspendingRequestor && "SuspendAll".equals((sr = (SuspendingRequestor)requestor2).getSuspendPolicy());
        });
    }

    private static void addClassFilter(EventRequest request, String pattern) {
        if (request instanceof ExceptionRequest) {
            ((ExceptionRequest)request).addClassFilter(pattern);
        } else if (request instanceof MethodEntryRequest) {
            ((MethodEntryRequest)request).addClassFilter(pattern);
        } else if (request instanceof MethodExitRequest) {
            ((MethodExitRequest)request).addClassFilter(pattern);
        } else if (request instanceof WatchpointRequest) {
            ((WatchpointRequest)request).addClassFilter(pattern);
        }
    }

    private static void addClassExclusionFilter(EventRequest request, String pattern) {
        if (request instanceof ExceptionRequest) {
            ((ExceptionRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof MethodEntryRequest) {
            ((MethodEntryRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof MethodExitRequest) {
            ((MethodExitRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof WatchpointRequest) {
            ((WatchpointRequest)request).addClassExclusionFilter(pattern);
        }
    }

    private void addLocatableRequest(FilteredRequestor requestor2, EventRequest request) {
        if ("SuspendAll".equals(requestor2.getSuspendPolicy())) {
            if (DebuggerUtils.isAlwaysSuspendThreadBeforeSwitch()) {
                request.setSuspendPolicy(1);
            } else {
                request.setSuspendPolicy(2);
            }
        } else {
            request.setSuspendPolicy(1);
        }
        if (requestor2.isCountFilterEnabled() && !requestor2.isConditionEnabled()) {
            request.addCountFilter(requestor2.getCountFilter());
        }
        if (requestor2.isClassFiltersEnabled() && !(request instanceof BreakpointRequest)) {
            this.addClassFilters(request, requestor2.getClassFilters(), requestor2.getClassExclusionFilters());
        }
        this.registerRequestInternal(requestor2, request);
    }

    public void addClassFilters(EventRequest request, ClassFilter[] classFilters, ClassFilter[] classExclusionFilters) {
        if (DebuggerUtilsEx.getEnabledNumber(classFilters) == 1) {
            for (ClassFilter filter : classFilters) {
                if (!filter.isEnabled()) continue;
                JVMName jvmClassName = (JVMName)ReadAction.compute(() -> {
                    PsiClass psiClass = DebuggerUtils.findClass((String)filter.getPattern(), (Project)this.myDebugProcess.getProject(), (GlobalSearchScope)this.myDebugProcess.getSearchScope());
                    if (psiClass == null) {
                        return null;
                    }
                    return JVMNameUtil.getJVMQualifiedName(psiClass);
                });
                String pattern = filter.getPattern();
                try {
                    if (jvmClassName != null) {
                        pattern = jvmClassName.getName(this.myDebugProcess);
                    }
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
                RequestManagerImpl.addClassFilter(request, pattern);
                break;
            }
        }
        for (ClassFilter filter : classExclusionFilters) {
            if (!filter.isEnabled()) continue;
            RequestManagerImpl.addClassExclusionFilter(request, filter.getPattern());
        }
    }

    public void registerRequestInternal(Requestor requestor2, EventRequest request) {
        this.registerRequest(requestor2, request);
        request.putProperty(REQUESTOR, requestor2);
    }

    public void registerRequest(Requestor requestor2, EventRequest request) {
        this.myRequestorToBelongedRequests.computeIfAbsent(requestor2, r -> new HashSet()).add(request);
    }

    @Nullable
    public ClassPrepareRequest createClassPrepareRequest(ClassPrepareRequestor requestor2, String pattern) {
        if (this.myEventRequestManager == null) {
            return null;
        }
        ClassPrepareRequest classPrepareRequest = this.myEventRequestManager.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(1);
        if (!StringUtil.isEmpty((String)pattern)) {
            classPrepareRequest.addClassFilter(pattern);
            classPrepareRequest.putProperty(CLASS_NAME, pattern);
        }
        this.registerRequestInternal((Requestor)requestor2, classPrepareRequest);
        return classPrepareRequest;
    }

    public ExceptionRequest createExceptionRequest(FilteredRequestor requestor2, ReferenceType referenceType, boolean notifyCaught, boolean notifyUnCaught) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ExceptionRequest req = this.myEventRequestManager.createExceptionRequest(referenceType, notifyCaught, notifyUnCaught);
        this.addLocatableRequest(requestor2, req);
        return req;
    }

    public MethodEntryRequest createMethodEntryRequest(FilteredRequestor requestor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodEntryRequest req = this.myEventRequestManager.createMethodEntryRequest();
        this.addLocatableRequest(requestor2, req);
        return req;
    }

    public MethodExitRequest createMethodExitRequest(FilteredRequestor requestor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodExitRequest req = this.myEventRequestManager.createMethodExitRequest();
        this.addLocatableRequest(requestor2, req);
        return req;
    }

    public BreakpointRequest createBreakpointRequest(FilteredRequestor requestor2, Location location) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        BreakpointRequest req = this.myEventRequestManager.createBreakpointRequest(location);
        this.addLocatableRequest(requestor2, req);
        this.myRequestWarnings.remove(requestor2);
        return req;
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(FilteredRequestor requestor2, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        AccessWatchpointRequest req = this.myEventRequestManager.createAccessWatchpointRequest(field);
        this.addLocatableRequest(requestor2, req);
        return req;
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(FilteredRequestor requestor2, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ModificationWatchpointRequest req = this.myEventRequestManager.createModificationWatchpointRequest(field);
        this.addLocatableRequest(requestor2, req);
        return req;
    }

    public void deleteRequest(Requestor requestor2) {
        InstrumentationBreakpointState instrumentationInfo = this.getInstrumentationInfo(requestor2);
        if (instrumentationInfo != null) {
            instrumentationInfo.updateInstrumentationModeEnabled((RequestManager)this, false);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRequestWarnings.remove(requestor2);
        if (!this.myDebugProcess.isAttached()) {
            return;
        }
        Set<EventRequest> requests = this.myRequestorToBelongedRequests.remove(requestor2);
        if (requests == null) {
            return;
        }
        for (EventRequest request : requests) {
            try {
                Set<EventRequest> allTargetRequestorRequests;
                Requestor targetRequestor = (Requestor)request.getProperty(REQUESTOR);
                if (targetRequestor != requestor2 && (allTargetRequestorRequests = this.myRequestorToBelongedRequests.get(targetRequestor)) != null) {
                    allTargetRequestorRequests.remove(request);
                    if (allTargetRequestorRequests.isEmpty()) {
                        this.myRequestorToBelongedRequests.remove(targetRequestor);
                    }
                }
                DebuggerUtilsAsync.deleteEventRequest(this.myEventRequestManager, request);
            }
            catch (InvalidRequestStateException targetRequestor) {
            }
            catch (InternalException e) {
                if (e.errorCode() == 41) continue;
                LOG.info((Throwable)e);
            }
        }
    }

    private static Function<EventRequest, CompletableFuture<Void>> getEventRequestEnabler(boolean sync) {
        if (sync) {
            return r -> {
                r.enable();
                return CompletableFuture.completedFuture(null);
            };
        }
        return request -> DebuggerUtilsAsync.setEnabled(request, true);
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor2, SourcePosition classPosition) {
        this.callbackOnPrepareClasses(requestor2, classPosition, RequestManagerImpl.getEventRequestEnabler(true));
    }

    public CompletableFuture<Void> callbackOnPrepareClassesAsync(ClassPrepareRequestor requestor2, SourcePosition classPosition) {
        return this.callbackOnPrepareClasses(requestor2, classPosition, RequestManagerImpl.getEventRequestEnabler(false));
    }

    private CompletableFuture<Void> callbackOnPrepareClasses(ClassPrepareRequestor requestor2, SourcePosition classPosition, Function<EventRequest, CompletableFuture<Void>> enabler) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.checkReadOnly((Requestor)requestor2)) {
            return CompletableFuture.completedFuture(null);
        }
        List<ClassPrepareRequest> prepareRequests = this.myDebugProcess.getPositionManager().createPrepareRequests(requestor2, classPosition);
        if (prepareRequests.isEmpty()) {
            this.setInvalid((Requestor)requestor2, JavaDebuggerBundle.message((String)"status.invalid.breakpoint.out.of.class", (Object[])new Object[0]));
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf((CompletableFuture[])((StreamEx)StreamEx.of(prepareRequests).nonNull().peek(r -> this.registerRequest((Requestor)requestor2, (EventRequest)r))).map(enabler).toArray(CompletableFuture[]::new));
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor2, String classOrPatternToBeLoaded) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.checkReadOnly((Requestor)requestor2)) {
            return;
        }
        ClassPrepareRequest classPrepareRequest = this.createClassPrepareRequest(requestor2, classOrPatternToBeLoaded);
        if (classPrepareRequest != null) {
            this.registerRequest((Requestor)requestor2, classPrepareRequest);
            classPrepareRequest.enable();
            if (LOG.isDebugEnabled()) {
                LOG.debug("classOrPatternToBeLoaded = " + classOrPatternToBeLoaded);
            }
        }
    }

    public void enableRequest(EventRequest request) {
        this.enableRequest(request, RequestManagerImpl.getEventRequestEnabler(true));
    }

    public CompletableFuture<Void> enableRequestAsync(EventRequest request) {
        return this.enableRequest(request, RequestManagerImpl.getEventRequestEnabler(false));
    }

    private CompletableFuture<Void> enableRequest(EventRequest request, Function<EventRequest, CompletableFuture<Void>> enabler) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LOG.assertTrue(RequestManagerImpl.findRequestor(request) != null);
        try {
            ThreadReference filterThread;
            ThreadReference threadReference = filterThread = this.myFilterThread == null ? null : this.myFilterThread.getRealThread();
            if (filterThread != null && DebuggerSession.filterBreakpointsDuringSteppingUsingDebuggerEngine()) {
                if (request instanceof BreakpointRequest) {
                    ((BreakpointRequest)request).addThreadFilter(filterThread);
                } else if (request instanceof MethodEntryRequest) {
                    ((MethodEntryRequest)request).addThreadFilter(filterThread);
                } else if (request instanceof MethodExitRequest) {
                    ((MethodExitRequest)request).addThreadFilter(filterThread);
                }
            }
            return enabler.apply(request);
        }
        catch (InternalException e) {
            switch (e.errorCode()) {
                case 40: {
                    LOG.info((Throwable)e);
                    break;
                }
                case 41: {
                    break;
                }
                default: {
                    LOG.error((Throwable)e);
                }
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    public void setInvalid(Requestor requestor2, String message) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isVerified(requestor2)) {
            this.myRequestWarnings.put(requestor2, message);
        }
    }

    @Nullable
    public String getWarning(Requestor requestor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myRequestWarnings.get(requestor2);
    }

    public boolean isVerified(Requestor requestor2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return ContainerUtil.exists(this.findRequests(requestor2), r -> !(r instanceof ClassPrepareRequest));
    }

    @Override
    public void processDetached(DebugProcessImpl process, boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEventRequestManager = null;
        this.myRequestWarnings.clear();
        this.myRequestorToBelongedRequests.clear();
    }

    @Override
    public void processAttached(DebugProcessImpl process) {
        VirtualMachineProxyImpl vmProxy = VirtualMachineProxyImpl.getCurrent();
        if (vmProxy.canBeModified()) {
            this.myEventRequestManager = vmProxy.eventRequestManager();
        }
    }

    public void processClassPrepared(ClassPrepareEvent event, Set<ClassPrepareRequestor> notifiedRequestors) {
        if (!this.myDebugProcess.isAttached()) {
            return;
        }
        ReferenceType refType = event.referenceType();
        if (refType instanceof ClassType || refType instanceof InterfaceType) {
            ClassPrepareRequestor requestor2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("signature = " + refType.signature());
            }
            if ((requestor2 = (ClassPrepareRequestor)event.request().getProperty(REQUESTOR)) != null) {
                if (notifiedRequestors.add(requestor2)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("requestor found " + refType.signature());
                    }
                    requestor2.processClassPrepare((DebugProcess)this.myDebugProcess, refType);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("requestor " + String.valueOf(requestor2) + " already notified " + refType.signature());
                }
            }
        }
    }

    public void clearWarnings() {
        this.myRequestWarnings.clear();
    }

    public boolean checkReadOnly(Requestor requestor2) {
        if (!VirtualMachineProxyImpl.getCurrent().canBeModified()) {
            this.setInvalid(requestor2, "Not available in read only mode");
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void deleteAllStepRequests() {
        List stepRequestors = ContainerUtil.filter(this.myRequestorToBelongedRequests.keySet(), request -> request instanceof StepRequestor);
        for (Requestor request2 : stepRequestors) {
            this.deleteRequest(request2);
        }
    }

    @ApiStatus.Internal
    public void addInstrumentationInfo(@NotNull Requestor requestor2, @NotNull InstrumentationBreakpointState info) {
        if (requestor2 == null) {
            RequestManagerImpl.$$$reportNull$$$0(1);
        }
        if (info == null) {
            RequestManagerImpl.$$$reportNull$$$0(2);
        }
        this.myInstrumentationInfo.put(requestor2, info);
    }

    @ApiStatus.Internal
    @Nullable
    public InstrumentationBreakpointState getInstrumentationInfo(@NotNull Requestor requestor2) {
        if (requestor2 == null) {
            RequestManagerImpl.$$$reportNull$$$0(3);
        }
        return this.myInstrumentationInfo.get(requestor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventSet";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/requests/RequestManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuspendAllRequestor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstrumentationInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstrumentationInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

