/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a'\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001aS\u0010\u0005\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0001\"\f\b\u0001\u0010\u0006*\u00060\u0007j\u0002`\b2\b\u0010\t\u001a\u0004\u0018\u0001H\u00012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001aG\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u0001*\u00020\u0010\"\u0004\b\u0001\u0010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u000f0\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a<\u0010\u001a\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001b\u00a2\u0006\u0002\b\u001eH\u0000\u00a2\u0006\u0002\u0010\u001f\u001a\u0012\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"wrapIncompatibleThreadStateException", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "suppressExceptions", "E", "Ljava/lang/Exception;", "Lkotlin/Exception;", "defaultValue", "rethrow", "Ljava/lang/Class;", "supplier", "(Ljava/lang/Object;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "computeSafeIfAny", "R", "", "ep", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "processor", "Lkotlin/Function1;", "(Lcom/intellij/openapi/extensions/ExtensionPointName;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "preloadAllClasses", "", "vm", "Lcom/sun/jdi/VirtualMachine;", "runBlockingAssertNotInReadAction", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "instanceOf", "", "Lcom/sun/jdi/Type;", "className", "", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nDebugUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugUtils.kt\ncom/intellij/debugger/impl/DebugUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,148:1\n57#2:149\n35#2,2:150\n57#2:152\n35#2,2:153\n35#2,2:155\n57#2:157\n35#2,2:158\n57#2:160\n35#2,2:161\n57#2:163\n35#2,2:164\n*S KotlinDebug\n*F\n+ 1 DebugUtils.kt\ncom/intellij/debugger/impl/DebugUtilsKt\n*L\n70#1:149\n70#1:150,2\n76#1:152\n76#1:153,2\n70#1:155,2\n76#1:157\n76#1:158,2\n93#1:160\n93#1:161,2\n143#1:163\n143#1:164,2\n*E\n"})
public final class DebugUtilsKt {
    @Nullable
    public static final <T> T wrapIncompatibleThreadStateException(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$wrapIncompatibleThreadStateException = false;
        try {
            object = block.invoke();
        }
        catch (EvaluateException e) {
            if (!(e.getCause() instanceof IncompatibleThreadStateException)) {
                throw e;
            }
            object = null;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public static final <T, E extends Exception> T suppressExceptions(@Nullable T defaultValue, @Nullable Class<E> rethrow, @NotNull Function0<? extends T> supplier) {
        Object object;
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        boolean $i$f$suppressExceptions = false;
        try {
            object = supplier.invoke();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ProcessCanceledException || throwable instanceof CancellationException || throwable instanceof VMDisconnectedException || throwable instanceof ObjectCollectedException) {
                throw e;
            }
            if (throwable instanceof InternalException) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info(e);
            } else if (throwable instanceof Exception || throwable instanceof AssertionError) {
                if (rethrow != null && rethrow.isInstance(e)) {
                    throw e;
                }
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e);
            } else {
                throw e;
            }
            object = defaultValue;
        }
        return (T)object;
    }

    public static /* synthetic */ Object suppressExceptions$default(Object defaultValue, Class rethrow, Function0 supplier, int n, Object object) {
        if ((n & 2) != 0) {
            rethrow = null;
        }
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
        boolean $i$f$suppressExceptions = false;
        try {
            object = supplier.invoke();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ProcessCanceledException || throwable instanceof CancellationException || throwable instanceof VMDisconnectedException || throwable instanceof ObjectCollectedException) {
                throw e;
            }
            if (throwable instanceof InternalException) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info(e);
            } else if (throwable instanceof Exception || throwable instanceof AssertionError) {
                if (rethrow != null && rethrow.isInstance(e)) {
                    throw e;
                }
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e);
            } else {
                throw e;
            }
            object = defaultValue;
        }
        return object;
    }

    @Nullable
    public static final <T, R> R computeSafeIfAny(@NotNull ExtensionPointName<T> ep, @NotNull Function1<? super T, ? extends R> processor) {
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter(ep, (String)"ep");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            boolean $i$f$computeSafeIfAny = false;
            for (Object t : (Iterable)ep.getExtensionList()) {
                Object object2;
                Object object3;
                boolean bl = false;
                try {
                    object3 = processor.invoke(t);
                }
                catch (Exception e) {
                    if (e instanceof ProcessCanceledException || e instanceof VMDisconnectedException || e instanceof CancellationException) {
                        throw e;
                    }
                    boolean $i$f$fileLogger = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    Logger logger = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error((Throwable)e);
                    object3 = null;
                }
                if ((object2 = object3) == null) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        return (R)object;
    }

    public static final void preloadAllClasses(@NotNull VirtualMachine vm) {
        CompletableFuture<List<ReferenceType>> allClasses;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        CompletableFuture<List<ReferenceType>> completableFuture = allClasses = Registry.Companion.is("debugger.preload.types.async", true) ? DebuggerUtilsAsync.allCLasses(vm) : CompletableFuture.completedFuture(vm.allClasses());
        if (!Registry.Companion.is("debugger.preload.types.hierarchy", true) || DebuggerUtils.isAndroidVM((VirtualMachine)vm)) {
            return;
        }
        Channel channel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        try {
            Function1 function1 = arg_0 -> DebugUtilsKt.preloadAllClasses$lambda$0(channel, arg_0);
            DebugProcessEvents.enableNonSuspendingRequest(vm.eventRequestManager().createClassPrepareRequest(), arg_0 -> DebugUtilsKt.preloadAllClasses$lambda$1(function1, arg_0));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        DebuggerManagerThreadImpl managerThread = DebuggerManagerThreadImpl.Companion.getCurrentThread();
        BuildersKt.launch$default((CoroutineScope)managerThread.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<ReferenceType>)channel, allClasses, managerThread, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int I$1;
            int I$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Channel<ReferenceType> $channel;
            final /* synthetic */ CompletableFuture<List<ReferenceType>> $allClasses;
            final /* synthetic */ DebuggerManagerThreadImpl $managerThread;
            {
                this.$channel = $channel;
                this.$allClasses = $allClasses;
                this.$managerThread = $managerThread;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$allClasses, this.$channel, null){
                            int label;
                            final /* synthetic */ CompletableFuture<List<ReferenceType>> $allClasses;
                            final /* synthetic */ Channel<ReferenceType> $channel;
                            {
                                this.$allClasses = $allClasses;
                                this.$channel = $channel;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var3_3 = this.$allClasses;
                                        Intrinsics.checkNotNull(var3_3);
                                        this.label = 1;
                                        v0 = FutureKt.await((CompletionStage)var3_3, (Continuation)((Continuation)this));
                                        if (v0 == var5_2) {
                                            return var5_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        classes = (List)v0;
                                        for (ReferenceType type : classes) {
                                            Intrinsics.checkNotNull((Object)type);
                                            this.$channel.trySend-JP2dKIU((Object)type);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        var3_4 = (ReceiveChannel)this.$channel;
                        var4_5 = this.$managerThread;
                        $i$f$consumeEach = 0;
                        $this$consume$iv$iv = $this$consumeEach$iv;
                        $i$f$consume = 0;
                        cause$iv$iv = null;
                        try {
                            $this$consumeEach_u24lambda_u240$iv = $this$consume$iv$iv;
                            $i$a$-consume-ChannelsKt__Channels_commonKt$consumeEach$2$iv = 0;
                            var11_14 = $this$consumeEach_u24lambda_u240$iv.iterator();
                        }
                        catch (Throwable e$iv$iv) {
                            try {
                                cause$iv$iv = e$iv$iv;
                                throw e$iv$iv;
                            }
                            catch (Throwable var10_13) {
                                ChannelsKt.cancelConsumed((ReceiveChannel)$this$consume$iv$iv, (Throwable)cause$iv$iv);
                                throw var10_13;
                            }
                        }
lbl27:
                        // 2 sources

                        while (true) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$consumeEach$iv);
                            this.L$2 = var4_5;
                            this.L$3 = $this$consume$iv$iv;
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$consumeEach_u24lambda_u240$iv);
                            this.L$5 = var11_14;
                            this.I$0 = $i$f$consumeEach;
                            this.I$1 = $i$f$consume;
                            this.I$2 = $i$a$-consume-ChannelsKt__Channels_commonKt$consumeEach$2$iv;
                            this.label = 1;
                            v0 = var11_14.hasNext((Continuation)this);
                            if (v0 == var15_3) {
                                return var15_3;
                            }
                            ** GOTO lbl55
                            break;
                        }
                    }
                    case 1: {
                        $i$a$-consume-ChannelsKt__Channels_commonKt$consumeEach$2$iv = this.I$2;
                        $i$f$consume = this.I$1;
                        $i$f$consumeEach = this.I$0;
                        var11_14 = (ChannelIterator)this.L$5;
                        $this$consumeEach_u24lambda_u240$iv = (ReceiveChannel)this.L$4;
                        cause$iv$iv = null;
                        $this$consume$iv$iv = (ReceiveChannel)this.L$3;
                        var4_5 = (DebuggerManagerThreadImpl)this.L$2;
                        $this$consumeEach$iv = (ReceiveChannel)this.L$1;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl55:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) {
                                e$iv = var11_14.next();
                                type = (ReferenceType)e$iv;
                                $i$a$-consumeEach-DebugUtilsKt$preloadAllClasses$3$2 = false;
                                var4_5.schedule(PrioritizedTask.Priority.LOWEST, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0$0(com.sun.jdi.ReferenceType ), ()V)((ReferenceType)type));
                                ** continue;
                            }
                            var9_10 = Unit.INSTANCE;
                        }
                        ChannelsKt.cancelConsumed((ReceiveChannel)$this$consume$iv$iv, (Throwable)cause$iv$iv);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0$0(ReferenceType $type) {
                try {
                    DebuggerUtilsAsync.supertypes($type);
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
            }
        }), (int)3, null);
    }

    public static final <T> T runBlockingAssertNotInReadAction(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (ApplicationManager.getApplication().isInternal() && ApplicationManager.getApplication().isReadAccessAllowed() && !ProgressManager.getInstance().hasProgressIndicator()) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Call runBlocking from read action without indicator");
        }
        return (T)CoroutinesKt.runBlockingMaybeCancellable(block);
    }

    public static final boolean instanceOf(@NotNull Type $this$instanceOf, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)$this$instanceOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return DebuggerUtils.instanceOf((Type)$this$instanceOf, (String)className);
    }

    private static final Unit preloadAllClasses$lambda$0(Channel $channel, Event event) {
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type com.sun.jdi.event.ClassPrepareEvent");
        ReferenceType referenceType = ((ClassPrepareEvent)event).referenceType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType(...)");
        $channel.trySend-JP2dKIU((Object)referenceType);
        return Unit.INSTANCE;
    }

    private static final void preloadAllClasses$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

