/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.debugger.DebuggerGlobalSearchScope;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodInvokeUtils;
import com.intellij.debugger.engine.RemoteConnectionStub;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.HelperClassNotAvailableException;
import com.intellij.debugger.impl.MethodNotFoundException;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.rt.debugger.ExceptionDebugHelper;
import com.intellij.rt.execution.CommandLineWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    public static final Key<PsiType> PSI_TYPE_KEY = Key.create((String)"PSI_TYPE_KEY");
    private static final Logger LOG = Logger.getInstance(DebuggerUtilsImpl.class);
    private static final Key<Method> TO_STRING_METHOD_KEY = new Key("CachedToStringMethod");
    private static final String ARRAY_CLASS_NAME = "__Dummy_Array__";
    private static final String ARRAY_CLASS_TEXT = "public class __Dummy_Array__<T> {  public final int length;  private __Dummy_Array__(int l) {length = l;}  public T[] clone() {return null;}}";

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis((PsiElement)expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text) {
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text.toExternalForm());
        element.setAttribute("type", text.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        LOG.assertTrue("TextWithImports".equals(element.getName()));
        String text = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text);
    }

    public void writeTextWithImports(Element root, String name, TextWithImports value) {
        if (value.getKind() == CodeFragmentKind.EXPRESSION) {
            JDOMExternalizerUtil.writeField((Element)root, (String)name, (String)value.toExternalForm());
        } else {
            Element element = JDOMExternalizerUtil.writeOption((Element)root, (String)name);
            XExpression expression = TextWithImportsImpl.toXExpression(value);
            if (expression != null) {
                XmlSerializer.serializeObjectInto((Object)new XExpressionState(expression), (Element)element);
            }
        }
    }

    public TextWithImports readTextWithImports(Element root, String name) {
        String s = JDOMExternalizerUtil.readField((Element)root, (String)name);
        if (s != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, s);
        }
        Element option = JDOMExternalizerUtil.readOption((Element)root, (String)name);
        if (option != null) {
            XExpressionState state = new XExpressionState();
            XmlSerializer.deserializeInto((Element)option, (Object)state);
            return TextWithImportsImpl.fromXExpression(state.toXExpression());
        }
        return null;
    }

    public TextWithImports createExpressionWithImports(String expression) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    @NotNull
    public static Pair<PsiElement, PsiType> getPsiClassAndType(@Nullable String className, Project project) {
        PsiClass contextClass = null;
        PsiPrimitiveType contextType = null;
        if (!StringUtil.isEmpty((String)className)) {
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)className);
            if (primitiveType != null) {
                contextClass = JavaPsiFacade.getInstance((Project)project).findClass(primitiveType.getBoxedTypeName(), GlobalSearchScope.allScope((Project)project));
                contextType = primitiveType;
            } else {
                contextClass = DebuggerUtilsImpl.findClass((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                if (contextClass != null) {
                    contextClass = contextClass.getNavigationElement();
                }
                if (contextClass instanceof PsiCompiledElement) {
                    contextClass = ((PsiCompiledElement)contextClass).getMirror();
                }
                contextType = DebuggerUtilsImpl.getType((String)className, (Project)project);
            }
            if (contextClass != null) {
                contextClass.putUserData(PSI_TYPE_KEY, (Object)contextType);
            }
        }
        Pair pair = Pair.create(contextClass, contextType);
        if (pair == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(0);
        }
        return pair;
    }

    public PsiClass chooseClassDialog(@NlsContexts.DialogTitle String title, Project project) {
        TreeClassChooser dialog = TreeClassChooserFactory.getInstance((Project)project).createAllProjectScopeChooser(title);
        dialog.showDialog();
        return dialog.getSelected();
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        if (useSockets) {
            int freePort;
            try {
                freePort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(DebugProcessImpl.processError(e));
            }
            return Integer.toString(freePort);
        }
        ListeningConnector connector = (ListeningConnector)DebugProcessImpl.findConnector(false, true);
        try {
            return DebuggerUtilsImpl.tryShmemConnect(connector, "");
        }
        catch (Exception e) {
            int tryNum = 0;
            while (true) {
                try {
                    return DebuggerUtilsImpl.tryShmemConnect(connector, "javadebug_" + (int)(Math.random() * 1000.0));
                }
                catch (Exception ex) {
                    if (tryNum++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(ex));
                }
                break;
            }
        }
    }

    private static String tryShmemConnect(ListeningConnector connector, String address) throws IOException, IllegalConnectorArgumentsException {
        Map<String, Connector.Argument> map2 = connector.defaultArguments();
        map2.get("name").setValue(address);
        address = connector.startListening(map2);
        connector.stopListening(map2);
        return address;
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }

    @ApiStatus.Internal
    @NotNull
    public VirtualMachineProxy getVmProxy() {
        DebuggerManagerThreadImpl managerThread = DebuggerManagerThreadImpl.getCurrentThread();
        VirtualMachineProxy virtualMachineProxy = Objects.requireNonNull(managerThread.getVmProxy(), "VM is not set in DMT");
        if (virtualMachineProxy == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(1);
        }
        return virtualMachineProxy;
    }

    protected void logErrorImpl(@NotNull Throwable e) {
        if (e == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(2);
        }
        DebuggerUtilsImpl.logError(e);
    }

    public static void logError(@NotNull Throwable e) {
        if (e == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(3);
        }
        DebuggerUtilsImpl.logIfNeeded(e, false, arg_0 -> ((Logger)LOG).error(arg_0));
    }

    public static void logError(String message, Throwable e) {
        DebuggerUtilsImpl.logIfNeeded(e, false, t -> LOG.error(message, t));
    }

    public static void logError(String message, @Nullable Throwable e, String ... details) {
        if (details == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(4);
        }
        DebuggerUtilsImpl.logIfNeeded(e, false, t -> LOG.error(message, t, details));
    }

    static void logError(String message, Throwable e, boolean wrapIntoThrowable) {
        DebuggerUtilsImpl.logIfNeeded(e, wrapIntoThrowable, t -> LOG.error(message, t));
    }

    private static void logIfNeeded(Throwable e, boolean wrapIntoThrowable, Consumer<Throwable> action) {
        if (e instanceof VMDisconnectedException || e instanceof ProcessCanceledException) {
            throw (RuntimeException)e;
        }
        if (e instanceof InterruptedException) {
            throw new RuntimeException(e);
        }
        action.accept(wrapIntoThrowable ? new Throwable(e) : e);
    }

    @NlsContexts.Label
    public static String getConnectionWaitStatus(@NotNull RemoteConnection connection) {
        if (connection == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(5);
        }
        String connectionName = (String)ObjectUtils.doIfNotNull((Object)connection, DebuggerUtilsImpl::getConnectionDisplayName);
        return connection instanceof RemoteConnectionStub ? JavaDebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[0]) : (connection.isServerMode() ? JavaDebuggerBundle.message((String)"status.listening", (Object[])new Object[]{connectionName}) : JavaDebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{connectionName}));
    }

    public static String getConnectionDisplayName(@NotNull RemoteConnection connection) {
        if (connection == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(6);
        }
        if (connection instanceof PidRemoteConnection) {
            return "pid " + ((PidRemoteConnection)connection).getPid();
        }
        String addressDisplayName = JavaDebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
        String transportName = JavaDebuggerBundle.getTransportName((RemoteConnection)connection);
        return JavaDebuggerBundle.message((String)"string.connection", (Object[])new Object[]{addressDisplayName, transportName});
    }

    public static boolean instanceOf(@Nullable ReferenceType type, @NotNull ReferenceType superType) {
        if (superType == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(7);
        }
        if (type instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)type;
            return referenceTypeImpl.isAssignableTo(superType);
        }
        if (type == null) {
            return false;
        }
        if (superType.equals(type)) {
            return true;
        }
        if (type instanceof InterfaceType && "java.lang.Object".equals(superType.name())) {
            return true;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (superType instanceof ArrayType) {
                ArrayType superArrayType = (ArrayType)superType;
                try {
                    Type componentType = arrayType.componentType();
                    Type superComponentType = superArrayType.componentType();
                    if (componentType instanceof PrimitiveType) {
                        return componentType.equals(superComponentType);
                    }
                    if (superComponentType instanceof PrimitiveType) {
                        return false;
                    }
                    return DebuggerUtilsImpl.instanceOf((ReferenceType)componentType, (ReferenceType)superComponentType);
                }
                catch (ClassNotLoadedException e) {
                    LOG.info((Throwable)e);
                    return false;
                }
            }
            String superName = superType.name();
            return "java.lang.Cloneable".equals(superName) || "java.io.Serializable".equals(superName) || "java.lang.Object".equals(superName);
        }
        if (superType instanceof ClassType) {
            if (type instanceof InterfaceType) {
                return false;
            }
            if (type instanceof ClassType) {
                ClassType classType = (ClassType)type;
                ClassType superclass = classType.superclass();
                return superclass != null && DebuggerUtilsImpl.instanceOf(superclass, superType);
            }
        }
        return DebuggerUtilsImpl.supertypes(type).anyMatch(t -> DebuggerUtilsImpl.instanceOf(t, superType));
    }

    public static Stream<? extends ReferenceType> supertypes(ReferenceType type) {
        if (type instanceof InterfaceType) {
            return ((InterfaceType)type).superinterfaces().stream();
        }
        if (type instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type).superclass()).prepend(((ClassType)type).interfaces());
        }
        return StreamEx.empty();
    }

    public static byte @Nullable [] readBytesArray(Value bytesArray) {
        if (bytesArray instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)bytesArray).getValues();
            byte[] res = new byte[values.size()];
            int idx = 0;
            for (Value value : values) {
                if (value instanceof ByteValue) {
                    res[idx++] = ((ByteValue)value).value();
                    continue;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    protected Location getLocation(SuspendContext context) {
        return ((SuspendContextImpl)context).getLocation();
    }

    public <R, T> R processCollectibleValue(@NotNull ThrowableComputable<? extends T, ? extends EvaluateException> valueComputable, @NotNull Function<? super T, ? extends R> processor, @NotNull EvaluationContext evaluationContext) throws EvaluateException {
        if (valueComputable == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(9);
        }
        if (evaluationContext == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(10);
        }
        return DebuggerUtilsImpl.processCollectibleValue(valueComputable, processor, ((EvaluationContextImpl)evaluationContext).getSuspendContext());
    }

    protected String getValueAsStringImpl(@NotNull EvaluationContext evaluationContext, @Nullable Value value) throws EvaluateException {
        if (evaluationContext == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(11);
        }
        try {
            if (value == null) {
                return "null";
            }
            if (value instanceof StringReference) {
                DebuggerUtilsImpl.ensureNotInsideObjectConstructor((ObjectReference)((ObjectReference)value), (EvaluationContext)evaluationContext);
                return ((StringReference)value).value();
            }
            if (DebuggerUtilsImpl.isInteger((Value)value)) {
                return String.valueOf(((PrimitiveValue)value).longValue());
            }
            if (value instanceof FloatValue) {
                return String.valueOf(((FloatValue)value).floatValue());
            }
            if (value instanceof DoubleValue) {
                return String.valueOf(((DoubleValue)value).doubleValue());
            }
            if (value instanceof BooleanValue) {
                return String.valueOf(((PrimitiveValue)value).booleanValue());
            }
            if (value instanceof CharValue) {
                return String.valueOf(((PrimitiveValue)value).charValue());
            }
            if (value instanceof ObjectReference) {
                ObjectReference objRef = (ObjectReference)value;
                EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
                VirtualMachineProxyImpl virtualMachineProxy = evaluationContextImpl.getVirtualMachineProxy();
                Method toStringMethod = (Method)virtualMachineProxy.getUserData(TO_STRING_METHOD_KEY);
                if (toStringMethod == null) {
                    try {
                        ReferenceType refType = DebuggerUtilsImpl.getObjectClassType((VirtualMachine)objRef.virtualMachine());
                        toStringMethod = DebuggerUtilsImpl.findMethod((ReferenceType)refType, (String)"toString", (String)"()Ljava/lang/String;");
                        virtualMachineProxy.putUserData(TO_STRING_METHOD_KEY, toStringMethod);
                    }
                    catch (Exception ignored) {
                        throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{objRef.referenceType().name()}));
                    }
                }
                if (toStringMethod == null) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{objRef.referenceType().name()}));
                }
                Method finalToStringMethod = toStringMethod;
                return this.processCollectibleValue(() -> evaluationContextImpl.getDebugProcess().invokeInstanceMethod(evaluationContext, objRef, finalToStringMethod, Collections.emptyList(), 0, true), result -> {
                    if (result == null) {
                        return "null";
                    }
                    return result instanceof StringReference ? ((StringReference)result).value() : result.toString();
                }, evaluationContext);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.unsupported.expression.type", (Object[])new Object[0]));
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    protected PsiClass createArrayClass(Project project, LanguageLevel level) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("__Dummy_Array__." + JavaFileType.INSTANCE.getDefaultExtension(), JavaFileType.INSTANCE.getLanguage(), (CharSequence)ARRAY_CLASS_TEXT);
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)psiFile, (Object)level);
        return ((PsiJavaFile)psiFile).getClasses()[0];
    }

    @Nullable
    protected GlobalSearchScope getFallbackAllScope(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(13);
        }
        if (scope instanceof DebuggerGlobalSearchScope) {
            return ((DebuggerGlobalSearchScope)scope).fallbackAllScope();
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        return !allScope.equals(scope) ? allScope : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String getIdeaRtPath() {
        block8: {
            if (PluginManagerCore.isRunningFromSources()) {
                String string;
                block7: {
                    Class<CommandLineWrapper> aClass = CommandLineWrapper.class;
                    try {
                        String resourcePath = aClass.getName().replace('.', '/') + ".class";
                        Enumeration<URL> urls = aClass.getClassLoader().getResources(resourcePath);
                        while (urls.hasMoreElements()) {
                            String testResourcePath;
                            String path;
                            String testPath;
                            URL url = urls.nextElement();
                            if (!url.getProtocol().equals("file") || !StringUtilRt.endsWithIgnoreCase((CharSequence)(testPath = FileUtil.toSystemIndependentName((String)(path = URLUtil.urlToFile((URL)url).getPath()))), (CharSequence)(testResourcePath = FileUtil.toSystemIndependentName((String)resourcePath)))) continue;
                            string = path.substring(0, path.length() - resourcePath.length() - 1);
                            break block7;
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        break block8;
                    }
                }
                if (string == null) {
                    DebuggerUtilsImpl.$$$reportNull$$$0(14);
                }
                return string;
            }
        }
        String string = JavaSdkUtil.getIdeaRtJarPath();
        if (string == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        int chunkSize;
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        int total = list.size();
        for (int loaded = 0; loaded < total; loaded += chunkSize) {
            chunkSize = Math.min(size, total - loaded);
            res.add(list.subList(loaded, loaded + chunkSize));
        }
        return res;
    }

    private static CompletableFuture<NodeRenderer> getFirstApplicableRenderer(List<CompletableFuture<Boolean>> futures, int index, List<NodeRenderer> renderers) {
        if (index >= futures.size()) {
            return CompletableFuture.completedFuture(null);
        }
        return futures.get(index).thenCompose(res -> {
            if (res.booleanValue()) {
                return CompletableFuture.completedFuture((NodeRenderer)renderers.get(index));
            }
            return DebuggerUtilsImpl.getFirstApplicableRenderer(futures, index + 1, renderers);
        });
    }

    @NotNull
    public static CompletableFuture<NodeRenderer> getFirstApplicableRenderer(List<NodeRenderer> renderers, Type type) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CompletableFuture<NodeRenderer> completableFuture = DebuggerUtilsImpl.getFirstApplicableRenderer(ContainerUtil.map(renderers, r -> r.isApplicableAsync(type)), 0, renderers);
        if (completableFuture == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @NotNull
    public static CompletableFuture<List<NodeRenderer>> getApplicableRenderers(List<? extends NodeRenderer> renderers, Type type) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CompletableFuture[] futures = (CompletableFuture[])renderers.stream().map(r -> r.isApplicableAsync(type)).toArray(CompletableFuture[]::new);
        CompletionStage completionStage = CompletableFuture.allOf(futures).thenApply(__ -> {
            SmartList res = new SmartList();
            for (int i = 0; i < futures.length; ++i) {
                try {
                    if (!((Boolean)futures[i].join()).booleanValue()) continue;
                    res.add((NodeRenderer)renderers.get(i));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return res;
        });
        if (completionStage == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(17);
        }
        return completionStage;
    }

    @Nullable
    public static XValueMarkers<?, ?> getValueMarkers(@Nullable DebugProcess process) {
        XDebugSession session;
        if (process instanceof DebugProcessImpl && (session = ((DebugProcessImpl)process).getSession().getXDebugSession()) instanceof XDebugSessionImpl) {
            return ((XDebugSessionImpl)session).getValueMarkers();
        }
        return null;
    }

    @Nullable
    public static Value invokeClassMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType type, @NotNull String methodName, @Nullable String signature, @NotNull List<Value> arguments) throws EvaluateException {
        Method method;
        if (evaluationContext == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(18);
        }
        if (type == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(20);
        }
        if (arguments == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(21);
        }
        if ((method = DebuggerUtilsImpl.findMethod((ReferenceType)type, (String)methodName, (String)signature)) == null) {
            throw new MethodNotFoundException("Method " + methodName + ", signature " + signature + " not found in class " + type.name());
        }
        return evaluationContext.getDebugProcess().invokeMethod(evaluationContext, type, method, arguments);
    }

    @Nullable
    public static Value invokeObjectMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value, @NotNull String methodName, @Nullable String signature, @NotNull List<Value> arguments) throws EvaluateException {
        ReferenceType type;
        Method method;
        if (evaluationContext == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(22);
        }
        if (value == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(23);
        }
        if (methodName == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(24);
        }
        if (arguments == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(25);
        }
        if ((method = DebuggerUtilsImpl.findMethod((ReferenceType)(type = value.referenceType()), (String)methodName, (String)signature)) == null) {
            throw new MethodNotFoundException("Method " + methodName + ", signature " + signature + " not found in class " + type.name());
        }
        return evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)evaluationContext, value, method, arguments);
    }

    public static Value invokeHelperMethod(EvaluationContextImpl evaluationContext, Class<?> cls, String methodName, List<Value> arguments, boolean keepResult, String ... additionalClassesToLoad) throws EvaluateException {
        ClassType helperClass = ClassLoadingUtils.getHelperClass(cls, evaluationContext, additionalClassesToLoad);
        if (helperClass == null) {
            throw new HelperClassNotAvailableException("Unable to load helper class " + cls.getName());
        }
        Method method = DebuggerUtilsImpl.findMethod((ReferenceType)helperClass, (String)methodName, null);
        if (method == null) {
            throw new MethodNotFoundException("Unable to find helper class " + cls.getName() + " method " + methodName);
        }
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        ThrowableComputable invoker = () -> debugProcess.invokeMethod(evaluationContext, helperClass, method, arguments, 1024, true);
        return keepResult ? evaluationContext.computeAndKeep(invoker) : (Value)invoker.compute();
    }

    public static Value invokeHelperMethod(EvaluationContextImpl evaluationContext, Class<?> cls, String methodName, List<Value> arguments) throws EvaluateException {
        return DebuggerUtilsImpl.invokeHelperMethod(evaluationContext, cls, methodName, arguments, true, new String[0]);
    }

    @Nullable
    public static String getExceptionText(EvaluationContextImpl evaluationContext, @NotNull ObjectReference exceptionObject) throws EvaluateException {
        if (exceptionObject == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(26);
        }
        try {
            Value value = DebuggerUtilsImpl.invokeHelperMethod(evaluationContext, ExceptionDebugHelper.class, "getThrowableText", Collections.singletonList(exceptionObject));
            return ((StringReference)value).value();
        }
        catch (HelperClassNotAvailableException | MethodNotFoundException e) {
            LOG.error((Throwable)e);
            return MethodInvokeUtils.getExceptionTextViaArray(evaluationContext, exceptionObject);
        }
    }

    @Nullable
    public static ArrayReference invokeThrowableGetStackTrace(@NotNull ObjectReference exceptionObj, @NotNull EvaluationContextImpl evaluationContext, boolean keepResult) throws EvaluateException {
        if (exceptionObj == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(27);
        }
        if (evaluationContext == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(28);
        }
        if (DebuggerUtilsImpl.instanceOf((Type)exceptionObj.type(), (String)"java.lang.Throwable")) {
            Method method = DebuggerUtilsImpl.findMethod((ReferenceType)exceptionObj.referenceType(), (String)"getStackTrace", (String)"()[Ljava/lang/StackTraceElement;");
            DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
            ThrowableComputable invoker = () -> (ArrayReference)debugProcess.invokeInstanceMethod(evaluationContext, exceptionObj, Objects.requireNonNull(method), Collections.emptyList(), 0, true);
            return keepResult ? (ArrayReference)evaluationContext.computeAndKeep(invoker) : (ArrayReference)invoker.compute();
        }
        return null;
    }

    @ApiStatus.Internal
    public static String getRequestorStringForUser(Requestor requestor2) {
        String string;
        if (requestor2 instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)requestor2;
            string = breakpoint.getDisplayName();
        } else {
            string = requestor2.getClass().getSimpleName();
        }
        return string;
    }

    @ApiStatus.Internal
    public static boolean askAboutPauseOnException(Project project, String displayName, String exceptionMessage, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            DebuggerUtilsImpl.$$$reportNull$$$0(29);
        }
        boolean[] considerRequestHit = new boolean[]{true};
        DebuggerInvocationUtil.invokeAndWait(project, () -> {
            String message = JavaDebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{displayName, exceptionMessage});
            considerRequestHit[0] = Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
        }, ModalityState.nonModal());
        boolean r = considerRequestHit[0];
        return r;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueComputable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionObject";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionObj";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassAndType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmProxy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaRtPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstApplicableRenderer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableRenderers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logErrorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionWaitStatus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCollectibleValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsStringImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackAllScope";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invokeClassMethod";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "invokeObjectMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "invokeThrowableGetStackTrace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "askAboutPauseOnException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }
}

