/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatistics;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class HotSwapManager {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap<DebuggerSession, Long>();
    private static final String CLASS_EXTENSION = ".class";

    private long getTimeStamp(DebuggerSession session) {
        Long tStamp = this.myTimeStamps.get(session);
        return tStamp != null ? tStamp : 0L;
    }

    private void setTimeStamp(DebuggerSession session, long tStamp) {
        this.myTimeStamps.put(session, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(@NotNull DebuggerSession session, @Nullable NotNullLazyValue<? extends List<String>> outputPaths, @NotNull HotSwapProgress progress) {
        if (session == null) {
            HotSwapManager.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            HotSwapManager.$$$reportNull$$$0(1);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long timeStamp = this.getTimeStamp(session);
        HashMap<String, HotSwapFile> modifiedClasses = new HashMap<String, HotSwapFile>();
        List paths = outputPaths != null ? (List)outputPaths.getValue() : (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])OrderEnumerator.orderEntries((Project)session.getProject()).classes().getRoots(), o -> o.isDirectory() && !o.getFileSystem().isReadOnly() ? o.getPath() : null));
        for (String path : paths) {
            String rootPath = FileUtil.toCanonicalPath((String)path);
            HotSwapManager.collectModifiedClasses(new File(path), rootPath, rootPath.length() + 1, modifiedClasses, progress, timeStamp);
        }
        return modifiedClasses;
    }

    private static boolean collectModifiedClasses(File file, String filePath, int rootPathLength, Map<String, HotSwapFile> container, HotSwapProgress progress, long timeStamp) {
        if (progress.isCancelled()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (HotSwapManager.collectModifiedClasses(child, filePath + "/" + child.getName(), rootPathLength, container, progress, timeStamp)) continue;
                return false;
            }
        } else {
            String qualifiedName = HotSwapManager.getQualifiedName(filePath, rootPathLength);
            if (qualifiedName != null && file.lastModified() > timeStamp) {
                progress.setText(JavaDebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
                container.put(qualifiedName, new HotSwapFile(file));
            }
        }
        return true;
    }

    private static HotSwapManager getInstance(Project project) {
        return (HotSwapManager)project.getService(HotSwapManager.class);
    }

    private void reloadClasses(DebuggerSession session, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session, progress).reloadClasses(classesToReload);
        if (progress.isCancelled()) {
            session.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(session, newSwapTime);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<DebuggerSession> sessions, Map<String, Collection<String>> generatedPaths) {
        HashMap<DebuggerSession, Map<String, HotSwapFile>> result = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> sessionWithStamps = new ArrayList<Pair>();
        for (DebuggerSession debuggerSession : sessions) {
            sessionWithStamps.add(new Pair((Object)debuggerSession, (Object)HotSwapManager.getInstance(debuggerSession.getProject()).getTimeStamp(debuggerSession)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File root = new File((String)entry.getKey());
            for (String relativePath : (Collection)entry.getValue()) {
                String qualifiedName = HotSwapManager.getQualifiedName(relativePath, 0);
                if (qualifiedName == null) continue;
                HotSwapFile hotswapFile = new HotSwapFile(new File(root, relativePath));
                long fileStamp = hotswapFile.file.lastModified();
                for (Pair pair : sessionWithStamps) {
                    DebuggerSession session = (DebuggerSession)pair.first;
                    if (fileStamp <= (Long)pair.second) continue;
                    result.computeIfAbsent(session, k -> new HashMap()).put(qualifiedName, hotswapFile);
                }
            }
        }
        return result;
    }

    private static String getQualifiedName(String filePath, int rootPathLength) {
        boolean isClassFile;
        boolean bl = isClassFile = SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)filePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)CLASS_EXTENSION);
        if (!isClassFile) {
            return null;
        }
        String withoutExtension = filePath.substring(rootPathLength, filePath.length() - CLASS_EXTENSION.length());
        return withoutExtension.replace('/', '.');
    }

    @NotNull
    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(@NotNull List<DebuggerSession> sessions, @NotNull HotSwapProgress swapProgress) {
        if (sessions == null) {
            HotSwapManager.$$$reportNull$$$0(2);
        }
        if (swapProgress == null) {
            HotSwapManager.$$$reportNull$$$0(3);
        }
        return HotSwapManager.scanForModifiedClasses(sessions, null, swapProgress);
    }

    @NotNull
    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(@NotNull List<DebuggerSession> sessions, final @Nullable NotNullLazyValue<? extends List<String>> outputPaths, final @NotNull HotSwapProgress swapProgress) {
        if (sessions == null) {
            HotSwapManager.$$$reportNull$$$0(4);
        }
        if (swapProgress == null) {
            HotSwapManager.$$$reportNull$$$0(5);
        }
        final HashMap<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(() -> scanClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, (NotNullLazyValue<? extends List<String>>)outputPaths, swapProgress);
                    if (!sessionClasses.isEmpty()) {
                        modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(JavaDebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession session : sessions) {
                session.setModifiedClassesScanRequired(true);
            }
            Map<DebuggerSession, Map<String, HotSwapFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                HotSwapManager.$$$reportNull$$$0(6);
            }
            return map2;
        }
        HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = modifiedClasses;
        if (hashMap == null) {
            HotSwapManager.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public static void reloadModifiedClasses(final @NotNull Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final @NotNull HotSwapProgress reloadClassesProgress) {
        if (modifiedClasses == null) {
            HotSwapManager.$$$reportNull$$$0(8);
        }
        if (reloadClassesProgress == null) {
            HotSwapManager.$$$reportNull$$$0(9);
        }
        MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(() -> reloadClassesCommand.cancel());
        int totalClasses = modifiedClasses.values().stream().mapToInt(e -> e.size()).sum();
        HotSwapStatistics.logClassesReloaded((Project)reloadClassesProgress.getProject(), (int)totalClasses);
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(JavaDebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
        ActionsCollectorImpl.recordCustomActionInvoked((Project)reloadClassesProgress.getProject(), (String)"Reload Classes", null, HotSwapManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessions";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swapProgress";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/HotSwapManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedClasses";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadClassesProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/HotSwapManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForModifiedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scanForModifiedClasses";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reloadModifiedClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class HotSwapDebuggerManagerListener
    implements DebuggerManagerListener {
        private final Project myProject;

        public HotSwapDebuggerManagerListener(Project project) {
            this.myProject = project;
        }

        @Override
        public void sessionCreated(DebuggerSession session) {
            HotSwapManager.getInstance(this.myProject).setTimeStamp(session, System.currentTimeMillis());
        }

        @Override
        public void sessionRemoved(DebuggerSession session) {
            HotSwapManager.getInstance((Project)this.myProject).myTimeStamps.remove(session);
        }
    }
}

