/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil$getAttachedPids$;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.openapi.project.Project;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007J\u001e\u0010\b\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/impl/attach/JavaDebuggerAttachUtil;", "", "<init>", "()V", "canAttach", "", "processHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "attach", "project", "Lcom/intellij/openapi/project/Project;", "getAttachedPids", "", "", "attachVirtualMachine", "Lcom/sun/tools/attach/VirtualMachine;", "id", "isAttachable", "testAttachable", "", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nJavaDebuggerAttachUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDebuggerAttachUtil.kt\ncom/intellij/debugger/impl/attach/JavaDebuggerAttachUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n479#2:82\n1#3:83\n*S KotlinDebug\n*F\n+ 1 JavaDebuggerAttachUtil.kt\ncom/intellij/debugger/impl/attach/JavaDebuggerAttachUtil\n*L\n36#1:82\n*E\n"})
public final class JavaDebuggerAttachUtil {
    @NotNull
    public static final JavaDebuggerAttachUtil INSTANCE = new JavaDebuggerAttachUtil();

    private JavaDebuggerAttachUtil() {
    }

    @JvmStatic
    public static final boolean canAttach(@NotNull BaseProcessHandler<?> processHandler) {
        Intrinsics.checkNotNullParameter(processHandler, (String)"processHandler");
        return JavaAttachDebuggerProvider.getProcessAttachInfo(processHandler) != null;
    }

    @JvmStatic
    public static final boolean attach(@NotNull BaseProcessHandler<?> processHandler, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(processHandler, (String)"processHandler");
        JavaAttachDebuggerProvider.LocalAttachInfo info = JavaAttachDebuggerProvider.getProcessAttachInfo(processHandler);
        if (info != null) {
            JavaAttachDebuggerProvider.attach(info, project);
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Set<String> getAttachedPids(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection<DebuggerSession> collection = DebuggerManagerEx.getInstanceEx(project).getSessions();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSessions(...)");
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), JavaDebuggerAttachUtil::getAttachedPids$lambda$0);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getAttachedPids$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)sequence, JavaDebuggerAttachUtil::getAttachedPids$lambda$1));
    }

    @JvmStatic
    @NotNull
    public static final VirtualMachine attachVirtualMachine(@NotNull String id) throws IOException, AttachNotSupportedException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        INSTANCE.testAttachable(id);
        VirtualMachine virtualMachine = VirtualMachine.attach(id);
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"attach(...)");
        return virtualMachine;
    }

    @JvmStatic
    public static final boolean isAttachable(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            INSTANCE.testAttachable(id);
            return true;
        }
        catch (AttachNotSupportedException attachNotSupportedException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testAttachable(String id) throws AttachNotSupportedException {
        MonitoredVm vm = null;
        try {
            MonitoredHost host = MonitoredHost.getMonitoredHost(new HostIdentifier(null));
            vm = host.getMonitoredVm(new VmIdentifier(id));
            if (!MonitoredVmUtil.isAttachable(vm)) {
                throw new AttachNotSupportedException("Vm is not attachable");
            }
        }
        catch (Throwable e) {
            AttachNotSupportedException attachNotSupportedException;
            AttachNotSupportedException $this$testAttachable_u24lambda_u240 = attachNotSupportedException = new AttachNotSupportedException("Unable to attach");
            boolean bl = false;
            $this$testAttachable_u24lambda_u240.initCause(e);
            throw (Throwable)attachNotSupportedException;
        }
        finally {
            MonitoredVm monitoredVm = vm;
            if (monitoredVm != null) {
                monitoredVm.detach();
            }
        }
    }

    private static final RemoteConnection getAttachedPids$lambda$0(DebuggerSession it) {
        return it.getDebugEnvironment().getRemoteConnection();
    }

    private static final String getAttachedPids$lambda$1(PidRemoteConnection it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getPid();
    }
}

