/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.JavaDebuggerActionsCollector;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDebuggerConsoleFilterProvider
implements ConsoleFilterProvider {
    static final Pattern PATTERN = Pattern.compile("Listening for transport (\\S+) at address: (\\S+)");

    public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
        if (project == null) {
            JavaDebuggerConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        Filter[] filterArray = new Filter[]{new JavaDebuggerAttachFilter(project)};
        if (filterArray == null) {
            JavaDebuggerConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    public static Matcher getConnectionMatcher(String line) {
        Matcher matcher;
        if (line.contains("Listening for transport") && (matcher = PATTERN.matcher(line)).find()) {
            return matcher;
        }
        return null;
    }

    private static boolean isDebuggerAttached(String transport, String address, Project project) {
        return DebuggerManagerEx.getInstanceEx(project).getSessions().stream().map(s -> s.getDebugEnvironment().getRemoteConnection()).anyMatch(c -> address.equals(c.getApplicationAddress()) && "dt_shmem".equals(transport) != c.isUseSockets());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class JavaDebuggerAttachFilter
    implements Filter {
        @NotNull
        Project myProject;

        private JavaDebuggerAttachFilter(@NotNull Project project) {
            if (project == null) {
                JavaDebuggerAttachFilter.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            Matcher matcher;
            if (line == null) {
                JavaDebuggerAttachFilter.$$$reportNull$$$0(1);
            }
            if ((matcher = JavaDebuggerConsoleFilterProvider.getConnectionMatcher(line)) == null) {
                return null;
            }
            String transport = matcher.group(1);
            String address = matcher.group(2);
            int start = entireLength - line.length();
            if (Registry.is((String)"debugger.auto.attach.from.any.console") && !JavaDebuggerConsoleFilterProvider.isDebuggerAttached(transport, address, this.myProject)) {
                ApplicationManager.getApplication().invokeLater(() -> JavaAttachDebuggerProvider.attach(transport, address, null, this.myProject), ModalityState.any());
            }
            return new Filter.Result(Arrays.asList(new Filter.ResultItem[]{new AttachInlayResult(start + matcher.start(), start + matcher.end(), transport, address), new Filter.ResultItem(0, 0, null)}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider$JavaDebuggerAttachFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AttachInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myTransport;
        private final String myAddress;

        AttachInlayResult(int highlightStartOffset, int highlightEndOffset, String transport, String address) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myTransport = transport;
            this.myAddress = address;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            JavaDebuggerActionsCollector.attachFromConsoleInlayShown.log();
            PresentationFactory factory = new PresentationFactory(editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText("Attach debugger")), (event, point) -> {
                JavaDebuggerActionsCollector.attachFromConsoleInlay.log();
                JavaAttachDebuggerProvider.attach(this.myTransport, this.myAddress, null, editor.getProject());
            });
            return new PresentationRenderer(presentation);
        }
    }
}

