/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ObjectReferenceProxyImpl
extends JdiProxy {
    private final ObjectReference myObjectReference;
    private ReferenceType myReferenceType;
    private Type myType;
    private final AtomicReference<ThreeState> myIsCollected;

    public ObjectReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, @NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            ObjectReferenceProxyImpl.$$$reportNull$$$0(0);
        }
        super(virtualMachineProxy);
        this.myIsCollected = new AtomicReference<ThreeState>(ThreeState.UNSURE);
        this.myObjectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        this.checkValid();
        return this.myObjectReference;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public ReferenceType referenceType() {
        this.checkValid();
        if (this.myReferenceType == null) {
            this.myReferenceType = this.getObjectReference().referenceType();
        }
        return this.myReferenceType;
    }

    public Type type() {
        this.checkValid();
        if (this.myType == null) {
            this.myType = this.getObjectReference().type();
        }
        return this.myType;
    }

    @NonNls
    public String toString() {
        ObjectReference objectReference = this.getObjectReference();
        String objRefString = objectReference != null ? objectReference.toString() : "[referenced object collected]";
        return "ObjectReferenceProxyImpl: " + objRefString + " " + super.toString();
    }

    public Map<Field, Value> getValues(List<? extends Field> list) {
        return this.getObjectReference().getValues(list);
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.getObjectReference().setValue(field, value);
    }

    public boolean isCollected() {
        this.checkValid();
        switch (this.myIsCollected.get()) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        try {
            boolean res = VirtualMachineProxyImpl.isCollected(this.myObjectReference);
            this.myIsCollected.set(ThreeState.fromBoolean((boolean)res));
            return res;
        }
        catch (VMDisconnectedException ignored) {
            this.myIsCollected.set(ThreeState.YES);
            return true;
        }
    }

    public long uniqueID() {
        return this.getObjectReference().uniqueID();
    }

    public @Unmodifiable List<ThreadReferenceProxyImpl> waitingThreads() throws IncompatibleThreadStateException {
        return ContainerUtil.map(this.getObjectReference().waitingThreads(), this.getVirtualMachineProxy()::getThreadReferenceProxy);
    }

    public ThreadReferenceProxyImpl owningThread() throws IncompatibleThreadStateException {
        return this.getVirtualMachineProxy().getThreadReferenceProxy(this.getObjectReference().owningThread());
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.getObjectReference().entryCount();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ObjectReferenceProxyImpl)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return this.myObjectReference.equals(((ObjectReferenceProxyImpl)o).myObjectReference);
    }

    public int hashCode() {
        return this.myObjectReference.hashCode();
    }

    @Override
    protected void clearCaches() {
        this.myIsCollected.compareAndSet(ThreeState.NO, ThreeState.UNSURE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/debugger/jdi/ObjectReferenceProxyImpl", "<init>"));
    }
}

