/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerDiagnosticsUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger LOG = Logger.getInstance(ThreadReferenceProxyImpl.class);
    private String myName;
    private volatile int myFrameCount = -1;
    private final LinkedList<StackFrameProxyImpl> myFramesFromBottom = new LinkedList();
    private List<StackFrameProxyImpl> myFrames = null;
    private ThreadGroupReferenceProxyImpl myThreadGroupProxy;
    private ThreeState myResumeOnHotSwap = ThreeState.UNSURE;
    private final EventDispatcher<ThreadListener> myListeners = EventDispatcher.create(ThreadListener.class);
    private volatile boolean myIsEvaluating = false;
    private int myModelSuspendCount = 0;
    private boolean myIsIgnoreModelSuspendCount = false;
    public static final Comparator<ThreadReferenceProxyImpl> ourComparator = (th1, th2) -> {
        int res = Boolean.compare(th2.isSuspended(), th1.isSuspended());
        if (res == 0) {
            return th1.name().compareToIgnoreCase(th2.name());
        }
        return res;
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadReference threadReference) {
        super(virtualMachineProxy, threadReference);
    }

    public ThreadReference getThreadReference() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (ThreadReference)this.getObjectReference();
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(0);
        }
        return virtualMachineProxyImpl;
    }

    @NotNull
    public String name() {
        this.checkValid();
        if (this.myName == null) {
            try {
                this.myName = this.getThreadReference().name();
                LOG.assertTrue(this.myName != null);
            }
            catch (ObjectCollectedException ignored) {
                this.myName = "";
            }
            catch (IllegalThreadStateException ignored) {
                this.myName = "zombie";
            }
        }
        String string = this.myName;
        if (string == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getSuspendCount() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException ignored) {
            return 0;
        }
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.suspendImpl();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
        ((ThreadListener)this.myListeners.getMulticaster()).threadSuspended();
    }

    @ApiStatus.Internal
    public void suspendImpl() {
        ++this.myModelSuspendCount;
        this.getThreadReference().suspend();
    }

    @Override
    @NonNls
    public String toString() {
        try {
            String name = DebuggerDiagnosticsUtil.needAnonymizedReports() ? "Thread(uniqueID=" + this.getThreadReference().uniqueID() + ")" : this.name();
            return name + ": " + DebuggerUtilsEx.getThreadStatusText(this.status());
        }
        catch (ObjectCollectedException ignored) {
            return "[thread collected]";
        }
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before resume" + String.valueOf(this.getThreadReference()));
        }
        this.getVirtualMachineProxy().clearCaches();
        this.resumeImpl();
        ((ThreadListener)this.myListeners.getMulticaster()).threadResumed();
    }

    @ApiStatus.Internal
    public void resumeImpl() {
        --this.myModelSuspendCount;
        DebuggerUtilsAsync.resume(this.getThreadReference());
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myName = null;
        this.myFrames = null;
        this.myFrameCount = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException | IllegalThreadStateException e) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myThreadGroupProxy == null) {
            ThreadGroupReference threadGroupRef;
            try {
                threadGroupRef = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException ignored) {
                threadGroupRef = null;
            }
            this.myThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupRef);
        }
        return this.myThreadGroupProxy;
    }

    public int frameCount() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameCount == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.myFrameCount = threadReference.frameCount();
            }
            catch (ObjectCollectedException ignored) {
                this.myFrameCount = 0;
            }
            catch (IncompatibleThreadStateException e) {
                boolean isSuspended;
                try {
                    isSuspended = threadReference.isSuspended();
                }
                catch (Throwable ignored) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                if (!isSuspended) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                this.myFrameCount = 0;
            }
            catch (InternalException e) {
                LOG.info((Throwable)e);
                this.myFrameCount = 0;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug((Throwable)e);
                    this.myFrameCount = 0;
                }
                throw e;
            }
        }
        return this.myFrameCount;
    }

    public CompletableFuture<Integer> frameCountAsync() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameCount == -1) {
            ThreadReference threadReference = this.getThreadReference();
            return ((CompletableFuture)DebuggerUtilsAsync.frameCount(threadReference).exceptionally(throwable -> {
                if (throwable instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)throwable;
                    throw cancellationException;
                }
                Throwable unwrap = DebuggerUtilsAsync.unwrap(throwable);
                if (unwrap instanceof ObjectCollectedException) {
                    return 0;
                }
                if (unwrap instanceof IncompatibleThreadStateException) {
                    boolean isSuspended;
                    try {
                        isSuspended = threadReference.isSuspended();
                    }
                    catch (Throwable ignored) {
                        throw new CompletionException(EvaluateExceptionUtil.createEvaluateException((Throwable)unwrap));
                    }
                    if (!isSuspended) {
                        throw new CompletionException(EvaluateExceptionUtil.createEvaluateException((Throwable)unwrap));
                    }
                    return 0;
                }
                if (unwrap instanceof InternalException) {
                    LOG.info(unwrap);
                    return 0;
                }
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug(unwrap);
                    return 0;
                }
                throw (RuntimeException)throwable;
            })).thenApply(r -> {
                this.myFrameCount = r;
                return this.myFrameCount;
            });
        }
        return CompletableFuture.completedFuture(this.myFrameCount);
    }

    @NotNull
    public List<StackFrameProxyImpl> forceFrames() throws EvaluateException {
        block7: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ThreadReference threadRef = this.getThreadReference();
            try {
                this.checkValid();
                if (this.myFrames != null) break block7;
                try {
                    List<StackFrame> frames = threadRef.frames();
                    this.myFrameCount = frames.size();
                    this.myFrames = new ArrayList<StackFrameProxyImpl>(this.myFrameCount);
                    this.myFramesFromBottom.clear();
                    int idx = 0;
                    for (StackFrame frame : frames) {
                        StackFrameProxyImpl frameProxy = new StackFrameProxyImpl(this, frame, this.myFrameCount - idx);
                        this.myFrames.add(frameProxy);
                        this.myFramesFromBottom.addFirst(frameProxy);
                        ++idx;
                    }
                }
                catch (IncompatibleThreadStateException | InternalException e) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
            }
            catch (ObjectCollectedException ignored) {
                List<StackFrameProxyImpl> list = Collections.emptyList();
                if (list == null) {
                    ThreadReferenceProxyImpl.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List<StackFrameProxyImpl> list = this.myFrames;
        if (list == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<StackFrameProxyImpl> frames() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadRef = this.getThreadReference();
        try {
            this.checkValid();
            if (this.myFrames == null) {
                this.checkFrames(threadRef);
                this.myFrames = ContainerUtil.reverse(new ArrayList(this.myFramesFromBottom.subList(0, this.frameCount())));
            }
        }
        catch (ObjectCollectedException ignored) {
            List<StackFrameProxyImpl> list = Collections.emptyList();
            if (list == null) {
                ThreadReferenceProxyImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<StackFrameProxyImpl> list = this.myFrames;
        if (list == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void checkFrames(@NotNull ThreadReference threadRef) throws EvaluateException {
        if (threadRef == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(6);
        }
        int frameCount = this.frameCount();
        if (this.myFramesFromBottom.size() < frameCount) {
            List<StackFrame> frames;
            try {
                frames = threadRef.frames(0, frameCount - this.myFramesFromBottom.size());
            }
            catch (IncompatibleThreadStateException | InternalException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            int index = this.myFramesFromBottom.size() + 1;
            ListIterator<StackFrame> iterator = frames.listIterator(frameCount - this.myFramesFromBottom.size());
            while (iterator.hasPrevious()) {
                this.myFramesFromBottom.add(new StackFrameProxyImpl(this, iterator.previous(), index));
                ++index;
            }
        } else {
            while (this.myFramesFromBottom.size() > frameCount) {
                this.myFramesFromBottom.removeLast();
            }
        }
    }

    public StackFrameProxyImpl frame(int i) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
            this.checkFrames(threadReference);
            int frameCount = this.frameCount();
            if (frameCount == 0) {
                return null;
            }
            return this.myFramesFromBottom.get(frameCount - i - 1);
        }
        catch (ObjectCollectedException | IllegalThreadStateException ignored) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrame) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().popFrames(stackFrame.getStackFrame());
        }
        catch (InvalidStackFrameException | ObjectCollectedException runtimeException) {
        }
        catch (InternalException e) {
            if (e.errorCode() == 32) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"drop.frame.error.no.information", (Object[])new Object[0]));
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void forceEarlyReturn(Value value) throws ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().forceEarlyReturn(value);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void stop(ObjectReference exception) throws InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().stop(exception);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException e) {
            LOG.info((Throwable)e);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getThreadReference().isAtBreakpoint();
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isResumeOnHotSwap() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myResumeOnHotSwap == ThreeState.UNSURE) {
            this.myResumeOnHotSwap = ThreeState.fromBoolean((boolean)this.name().startsWith("YJPAgent-"));
        }
        return this.myResumeOnHotSwap.toBoolean();
    }

    public int getWholeSuspendModelNumber() {
        return this.myModelSuspendCount + this.getVirtualMachine().getModelSuspendCount();
    }

    @ApiStatus.Internal
    public void threadWasSuspended() {
        ++this.myModelSuspendCount;
    }

    @ApiStatus.Internal
    public void threadWasResumed() {
        --this.myModelSuspendCount;
    }

    public void addListener(ThreadListener listener2, Disposable disposable) {
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void removeListener(ThreadListener listener2) {
        this.myListeners.removeListener((EventListener)listener2);
    }

    @ApiStatus.Internal
    public boolean isEvaluating() {
        return this.myIsEvaluating;
    }

    @ApiStatus.Internal
    public void setEvaluating(boolean evaluating) {
        this.myIsEvaluating = evaluating;
        if (evaluating) {
            this.threadWasResumed();
        } else {
            this.threadWasSuspended();
        }
    }

    @ApiStatus.Internal
    public boolean isIgnoreModelSuspendCount() {
        return this.myIsIgnoreModelSuspendCount;
    }

    @ApiStatus.Internal
    public void setIgnoreModelSuspendCount(boolean ignoreModelSuspendCount) {
        this.myIsIgnoreModelSuspendCount = ignoreModelSuspendCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forceFrames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "frames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFrames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6 -> new IllegalArgumentException(string);
        };
    }

    public static interface ThreadListener
    extends EventListener {
        default public void threadSuspended() {
        }

        default public void threadResumed() {
        }
    }
}

