/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.memory.action.ClassesActionBase;
import com.intellij.debugger.memory.action.DebuggerActionUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToTypeSourceAction
extends ClassesActionBase {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        PsiClass psiClass = this.getPsiClass(e, true);
        return super.isEnabled(e) && psiClass != null && psiClass.isPhysical();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JumpToTypeSourceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    protected void perform(AnActionEvent e) {
        PsiClass psiClass = this.getPsiClass(e, false);
        if (psiClass != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)psiClass);
        }
    }

    @Nullable
    private PsiClass getPsiClass(AnActionEvent e, boolean fromUpdate) {
        ReferenceType selectedClass = fromUpdate ? (ReferenceType)e.getUpdateSession().compute((Object)this, "selectedClass", ActionUpdateThread.EDT, () -> DebuggerActionUtil.getSelectedClass(e)) : DebuggerActionUtil.getSelectedClass(e);
        Project project = e.getProject();
        if (selectedClass == null || project == null) {
            return null;
        }
        ReferenceType targetClass = JumpToTypeSourceAction.getObjectType(selectedClass);
        if (targetClass != null) {
            return DebuggerUtils.findClass((String)targetClass.name(), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    private static ReferenceType getObjectType(@NotNull ReferenceType ref) {
        if (ref == null) {
            JumpToTypeSourceAction.$$$reportNull$$$0(1);
        }
        if (!(ref instanceof ArrayType)) {
            return ref;
        }
        String elementTypeName = ref.name().replace("[]", "");
        VirtualMachine vm = ref.virtualMachine();
        List<ReferenceType> referenceTypes = vm.classesByName(elementTypeName);
        if (referenceTypes.size() == 1) {
            return referenceTypes.get(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/action/JumpToTypeSourceAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/action/JumpToTypeSourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

