/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.agent.CalculationTimeoutReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentActionResult;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentProgressPoint;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.extractor.ProxyExtractor;
import com.intellij.debugger.memory.agent.parsers.BooleanParser;
import com.intellij.debugger.memory.agent.parsers.ErrorCodeParser;
import com.intellij.debugger.memory.agent.parsers.GcRootsPathsParser;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.ShallowAndRetainedSizeParser;
import com.intellij.debugger.memory.agent.parsers.SizeAndHeldObjectsParser;
import com.intellij.debugger.memory.agent.parsers.SizesAndObjectsOfClassParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class IdeaNativeAgentProxyMirror {
    private static final Logger LOG = Logger.getInstance(IdeaNativeAgentProxyMirror.class);
    private static final String PROXY_CLASS_NAME = "com.intellij.memory.agent.IdeaNativeAgentProxy";
    private static final String IS_LOADED = "isLoaded";
    private static final String CAN_ESTIMATE_OBJECT_SIZE = "canEstimateObjectSize";
    private static final String CAN_ESTIMATE_OBJECTS_SIZES = "canEstimateObjectsSizes";
    private static final String CAN_GET_SHALLOW_SIZE_BY_CLASSES = "canGetShallowSizeByClasses";
    private static final String CAN_GET_RETAINED_SIZE_BY_CLASSES = "canGetRetainedSizeByClasses";
    private static final String CAN_FIND_PATHS_TO_CLOSEST_GC_ROOTS = "canFindPathsToClosestGcRoots";
    private static final String ESTIMATE_OBJECT_SIZE = "size";
    private static final String GET_SHALLOW_AND_RETAINED_SIZE_BY_OBJECTS = "getShallowAndRetainedSizesByObjects";
    private static final String ESTIMATE_OBJECTS_SIZES_BY_CLASS = "getSortedShallowAndRetainedSizesByClass";
    private static final String FIND_PATHS_TO_CLOSEST_GC_ROOTS = "findPathsToClosestGcRoots";
    private static final String GET_SHALLOW_SIZE_BY_CLASSES = "getShallowSizeByClasses";
    private static final String GET_RETAINED_SIZE_BY_CLASSES = "getRetainedSizeByClasses";
    private static final String GET_SHALLOW_AND_RETAINED_SIZE_BY_CLASSES = "getShallowAndRetainedSizeByClasses";
    private static final String PROXY_CONSTRUCTOR_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;J)V";
    private final String myCancellationFileName;
    private final String myProgressFileName;
    private ClassType myProxyType;

    public IdeaNativeAgentProxyMirror(@NotNull String cancellationFileName, @NotNull String progressFileName) {
        if (cancellationFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(0);
        }
        if (progressFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(1);
        }
        this.myProxyType = null;
        this.myCancellationFileName = cancellationFileName;
        this.myProgressFileName = progressFileName;
    }

    public String getCancellationFileName() {
        return this.myCancellationFileName;
    }

    public String getProgressFileName() {
        return this.myProgressFileName;
    }

    @NotNull
    public MemoryAgentActionResult<Pair<long[], ObjectReference[]>> estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, long timeoutInMillis) throws EvaluateException {
        Pair sizesAndObjects;
        Value result;
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult;
        MemoryAgentActionResult.ErrorCode errCode;
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(3);
        }
        if ((errCode = (MemoryAgentActionResult.ErrorCode)((Object)(errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result = this.callMethod(evaluationContext, ESTIMATE_OBJECT_SIZE, timeoutInMillis, reference))).getFirst())) != MemoryAgentActionResult.ErrorCode.OK) {
            sizesAndObjects = new Pair((Object)new long[0], (Object)new ObjectReference[0]);
        } else {
            Pair<Long[], ObjectReference[]> parsingResult = SizeAndHeldObjectsParser.INSTANCE.parse((Value)errCodeAndResult.getSecond());
            sizesAndObjects = new Pair((Object)Arrays.stream((Long[])parsingResult.getFirst()).mapToLong(Long::longValue).toArray(), (Object)((ObjectReference[])parsingResult.getSecond()));
        }
        return new MemoryAgentActionResult<Pair<long[], ObjectReference[]>>(sizesAndObjects, errCode);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MemoryAgentActionResult<MemoryAgent.ObjectsAndSizes> getShallowAndRetainedSizeByClass(@NotNull EvaluationContextImpl evaluationContext, @NotNull ReferenceType classType, long objectsLimit, long l) throws EvaluateException {
        void timeoutInMillis;
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(4);
        }
        if (classType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(5);
        }
        LongValue objectsLimitValue = evaluationContext.getVirtualMachineProxy().mirrorOf(objectsLimit);
        Value result = this.callMethod(evaluationContext, ESTIMATE_OBJECTS_SIZES_BY_CLASS, (long)timeoutInMillis, classType.classObject(), objectsLimitValue);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        MemoryAgentActionResult.ErrorCode errCode = (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst());
        MemoryAgent.ObjectsAndSizes objectsAndSizes = errCode != MemoryAgentActionResult.ErrorCode.OK ? new MemoryAgent.ObjectsAndSizes(new ObjectReference[0], new long[0], new long[0]) : SizesAndObjectsOfClassParser.INSTANCE.parse((Value)errCodeAndResult.getSecond());
        return new MemoryAgentActionResult<MemoryAgent.ObjectsAndSizes>(objectsAndSizes, errCode);
    }

    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizesByObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(6);
        }
        if (references == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(7);
        }
        ArrayReference array = IdeaNativeAgentProxyMirror.wrapWithArray(evaluationContext, references);
        Value result = this.callMethod(evaluationContext, GET_SHALLOW_AND_RETAINED_SIZE_BY_OBJECTS, timeoutInMillis, array);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        if (errCodeAndResult.getFirst() != MemoryAgentActionResult.ErrorCode.OK) {
            return new MemoryAgentActionResult<Pair<long[], long[]>>(new Pair((Object)new long[0], (Object)new long[0]), (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst()));
        }
        return IdeaNativeAgentProxyMirror.getShallowAndRetainedSizesResult(errCodeAndResult);
    }

    @NotNull
    public MemoryAgentActionResult<long[]> getShallowSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(8);
        }
        if (classes == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(9);
        }
        ArrayReference array = IdeaNativeAgentProxyMirror.wrapWithArray(evaluationContext, ContainerUtil.map(classes, ReferenceType::classObject));
        Value result = this.callMethod(evaluationContext, GET_SHALLOW_SIZE_BY_CLASSES, timeoutInMillis, array);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        return new MemoryAgentActionResult<long[]>(LongArrayParser.INSTANCE.parse((Value)errCodeAndResult.getSecond()).stream().mapToLong(Long::longValue).toArray(), (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst()));
    }

    @NotNull
    public MemoryAgentActionResult<long[]> getRetainedSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(10);
        }
        if (classes == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(11);
        }
        ArrayReference array = IdeaNativeAgentProxyMirror.wrapWithArray(evaluationContext, ContainerUtil.map(classes, ReferenceType::classObject));
        Value result = this.callMethod(evaluationContext, GET_RETAINED_SIZE_BY_CLASSES, timeoutInMillis, array);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        return new MemoryAgentActionResult<long[]>(LongArrayParser.INSTANCE.parse((Value)errCodeAndResult.getSecond()).stream().mapToLong(Long::longValue).toArray(), (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst()));
    }

    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(12);
        }
        if (classes == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(13);
        }
        ArrayReference array = IdeaNativeAgentProxyMirror.wrapWithArray(evaluationContext, ContainerUtil.map(classes, ReferenceType::classObject));
        Value result = this.callMethod(evaluationContext, GET_SHALLOW_AND_RETAINED_SIZE_BY_CLASSES, timeoutInMillis, array);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        return IdeaNativeAgentProxyMirror.getShallowAndRetainedSizesResult(errCodeAndResult);
    }

    @NotNull
    private static MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizesResult(Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult) {
        Pair<List<Long>, List<Long>> shallowAndRetainedSizes = ShallowAndRetainedSizeParser.INSTANCE.parse((Value)errCodeAndResult.getSecond());
        return new MemoryAgentActionResult<Pair<long[], long[]>>(new Pair((Object)((List)shallowAndRetainedSizes.getFirst()).stream().mapToLong(Long::longValue).toArray(), (Object)((List)shallowAndRetainedSizes.getSecond()).stream().mapToLong(Long::longValue).toArray()), (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst()));
    }

    @NotNull
    public MemoryAgentActionResult<ReferringObjectsInfo> findPathsToClosestGCRoots(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int pathsNumber, int objectsNumber, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(14);
        }
        if (reference == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(15);
        }
        IntegerValue pathsNumberValue = evaluationContext.getVirtualMachineProxy().mirrorOf(pathsNumber);
        IntegerValue objectsNumberValue = evaluationContext.getVirtualMachineProxy().mirrorOf(objectsNumber);
        Value result = this.callMethod(evaluationContext, FIND_PATHS_TO_CLOSEST_GC_ROOTS, timeoutInMillis, reference, pathsNumberValue, objectsNumberValue);
        Pair<MemoryAgentActionResult.ErrorCode, Value> errCodeAndResult = ErrorCodeParser.INSTANCE.parse(result);
        MemoryAgentActionResult.ErrorCode errCode = (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst());
        ReferringObjectsInfo returnValue = errCode != MemoryAgentActionResult.ErrorCode.OK ? new ReferringObjectsInfo(Collections.singletonList(reference), Collections.singletonList(Collections.singletonList(new CalculationTimeoutReferringObject()))) : GcRootsPathsParser.INSTANCE.parse((Value)errCodeAndResult.getSecond());
        return new MemoryAgentActionResult<ReferringObjectsInfo>(returnValue, (MemoryAgentActionResult.ErrorCode)((Object)errCodeAndResult.getFirst()));
    }

    public MemoryAgentCapabilities initializeCapabilities(@NotNull EvaluationContextImpl context) throws EvaluateException {
        ClassType proxyType;
        boolean isAgentLoaded;
        if (context == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(16);
        }
        if (!(isAgentLoaded = IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType = this.getProxyType(context), IS_LOADED))) {
            return MemoryAgentCapabilities.DISABLED;
        }
        MemoryAgentCapabilities.Builder builder = new MemoryAgentCapabilities.Builder();
        return builder.setCanEstimateObjectSize(IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType, CAN_ESTIMATE_OBJECT_SIZE)).setCanEstimateObjectsSizes(IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType, CAN_ESTIMATE_OBJECTS_SIZES)).setCanGetShallowSizeByClasses(IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType, CAN_GET_SHALLOW_SIZE_BY_CLASSES)).setCanGetRetainedSizeByClasses(IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType, CAN_GET_RETAINED_SIZE_BY_CLASSES)).setCanFindPathsToClosestGcRoots(IdeaNativeAgentProxyMirror.checkAgentCapability(context, proxyType, CAN_FIND_PATHS_TO_CLOSEST_GC_ROOTS)).buildLoaded();
    }

    @Nullable
    public MemoryAgentProgressPoint checkProgress() {
        if (!FileUtil.exists((String)this.myProgressFileName)) {
            return null;
        }
        try {
            return MemoryAgentProgressPoint.fromJson(this.myProgressFileName);
        }
        catch (IOException ex) {
            LOG.error("Failed to read progress point from file", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            LOG.error("Failed to create valid progress point class", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ClassType getProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(17);
        }
        if (this.myProxyType == null) {
            boolean valueBefore = evaluationContext.isAutoLoadClasses();
            ClassType classType = this.getOrLoadProxyType(evaluationContext);
            ClassType classType2 = classType;
            if (classType2 == null) {
                IdeaNativeAgentProxyMirror.$$$reportNull$$$0(18);
            }
            return classType2;
            finally {
                evaluationContext.setAutoLoadClasses(valueBefore);
            }
        }
        ClassType classType = this.myProxyType;
        if (classType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(19);
        }
        return classType;
    }

    @NotNull
    private static ObjectReference getProxyInstance(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull ObjectReference cancellationFileName, @NotNull ObjectReference progressFileName, @NotNull LongValue timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(20);
        }
        if (proxyType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(21);
        }
        if (cancellationFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(22);
        }
        if (progressFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(23);
        }
        if (timeoutInMillis == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(24);
        }
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        Method constructor = DebuggerUtils.findMethod((ReferenceType)proxyType, (String)"<init>", (String)PROXY_CONSTRUCTOR_SIGNATURE);
        if (constructor == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"No appropriate constructor found for proxy class");
        }
        ObjectReference objectReference = debugProcess.newInstance(evaluationContext, proxyType, constructor, Arrays.asList(cancellationFileName, progressFileName, timeoutInMillis), 0, true);
        if (objectReference == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(25);
        }
        return objectReference;
    }

    private ClassType getOrLoadProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(26);
        }
        ClassObjectReference classObjectReference = (ClassObjectReference)evaluationContext.computeAndKeep(() -> {
            long start = System.currentTimeMillis();
            ReferenceType referenceType = IdeaNativeAgentProxyMirror.loadUtilityClass(evaluationContext);
            if (referenceType == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load memory agent proxy class");
            }
            long duration = System.currentTimeMillis() - start;
            LOG.info("Loading of agent proxy class took " + duration + " ms");
            return referenceType.classObject();
        });
        this.myProxyType = (ClassType)classObjectReference.reflectedType();
        return this.myProxyType;
    }

    private static boolean checkAgentCapability(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String capabilityMethodName) {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(27);
        }
        if (proxyType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(28);
        }
        if (capabilityMethodName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(29);
        }
        try {
            Value value = IdeaNativeAgentProxyMirror.callMethod(evaluationContext, proxyType, capabilityMethodName, Collections.emptyList());
            return BooleanParser.INSTANCE.parse(value);
        }
        catch (EvaluateException e) {
            LOG.warn("Exception while capability checking: ", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private static LongValue getLongValue(@NotNull EvaluationContextImpl evaluationContext, long timeoutInMillis) {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(30);
        }
        LongValue longValue = evaluationContext.getVirtualMachineProxy().mirrorOf(timeoutInMillis);
        if (longValue == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(31);
        }
        return longValue;
    }

    @NotNull
    private static StringReference getStringReference(@NotNull EvaluationContextImpl evaluationContext, @NotNull String string) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(32);
        }
        if (string == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(33);
        }
        StringReference stringReference = DebuggerUtilsEx.mirrorOfString(string, evaluationContext);
        if (stringReference == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(34);
        }
        return stringReference;
    }

    @NotNull
    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(35);
        }
        if (proxyType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(36);
        }
        if (methodName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(37);
        }
        if (args == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(38);
        }
        return IdeaNativeAgentProxyMirror.callMethod(evaluationContext, proxyType, methodName, IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, ""), IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, ""), IdeaNativeAgentProxyMirror.getLongValue(evaluationContext, -1L), args);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull String methodName, long timeoutInMillis, Value ... valueArray) throws EvaluateException {
        void args;
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(39);
        }
        if (methodName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(40);
        }
        ClassType proxyType = this.getProxyType(evaluationContext);
        return IdeaNativeAgentProxyMirror.callMethod(evaluationContext, proxyType, methodName, IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, this.myCancellationFileName), IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, this.myProgressFileName), IdeaNativeAgentProxyMirror.getLongValue(evaluationContext, timeoutInMillis), Arrays.asList(args));
    }

    @NotNull
    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String methodName, @NotNull ObjectReference cancellationFileName, @NotNull ObjectReference progressFileName, @NotNull LongValue timeoutInMillis, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(41);
        }
        if (proxyType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(42);
        }
        if (methodName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(43);
        }
        if (cancellationFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(44);
        }
        if (progressFileName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(45);
        }
        if (timeoutInMillis == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(46);
        }
        if (args == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(47);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long start = System.currentTimeMillis();
        List<Method> methods = DebuggerUtilsEx.declaredMethodsByName(proxyType, methodName);
        if (methods.isEmpty()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Could not find method with such name: " + methodName));
        }
        if (methods.size() > 1) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Too many methods \"" + methodName + "\" found. Count: " + methods.size()));
        }
        Method method = methods.get(0);
        Object result = evaluationContext.computeAndKeep(() -> {
            DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
            ObjectReference proxyInstance = IdeaNativeAgentProxyMirror.getProxyInstance(evaluationContext, proxyType, cancellationFileName, progressFileName, timeoutInMillis);
            return debugProcess.invokeInstanceMethod(evaluationContext, proxyInstance, method, args, 1, true);
        });
        LOG.info("Memory agent's method \"" + methodName + "\" took " + (System.currentTimeMillis() - start) + " ms");
        Object t = result;
        if (t == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(48);
        }
        return t;
    }

    private static byte @NotNull [] readUtilityClass() {
        byte[] byArray = new ProxyExtractor().extractProxy();
        if (byArray == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(49);
        }
        return byArray;
    }

    @Nullable
    private static ReferenceType loadUtilityClass(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(50);
        }
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        byte[] bytes = IdeaNativeAgentProxyMirror.readUtilityClass();
        evaluationContext.setAutoLoadClasses(true);
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(evaluationContext, debugProcess);
        ClassLoadingUtils.defineClass(PROXY_CLASS_NAME, bytes, evaluationContext, classLoader);
        try {
            ClassType systemClassType = (ClassType)debugProcess.findClass(evaluationContext, "java.lang.System", null);
            if (systemClassType == null) {
                return null;
            }
            String javaHomePath = IdeaNativeAgentProxyMirror.getPropertyValue(evaluationContext, systemClassType, "java.home");
            if (javaHomePath == null) {
                return null;
            }
            JdkVersionDetector.JdkVersionInfo info = JdkVersionDetector.getInstance().detectJdkVersionInfo(javaHomePath);
            if (info == null) {
                return null;
            }
            String agentPath = IdeaNativeAgentProxyMirror.getMemoryAgentPath(info.arch);
            if (agentPath == null) {
                return null;
            }
            IdeaNativeAgentProxyMirror.setAgentPathPropertyValue(evaluationContext, systemClassType, agentPath);
            return debugProcess.loadClass(evaluationContext, PROXY_CLASS_NAME, classLoader);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load proxy class", (Throwable)e);
        }
    }

    private static void setAgentPathPropertyValue(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType systemClassType, @NotNull String agentPath) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(51);
        }
        if (systemClassType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(52);
        }
        if (agentPath == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(53);
        }
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        Method setPropertyMethod = DebuggerUtils.findMethod((ReferenceType)systemClassType, (String)"setProperty", (String)"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        if (setPropertyMethod == null) {
            return;
        }
        StringReference agentPathMirror = IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, agentPath);
        StringReference propertyNameMirror = IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, "intellij.memory.agent.path");
        debugProcess.invokeMethod(evaluationContext, systemClassType, setPropertyMethod, Arrays.asList(propertyNameMirror, agentPathMirror), true);
    }

    @Nullable
    private static String getMemoryAgentPath(CpuArch arch) throws ExecutionException, InterruptedException, TimeoutException {
        return MemoryAgentUtil.getAgentFilePathAsString(Registry.is((String)"debugger.memory.agent.debug"), MemoryAgentUtil.detectAgentKindByArch(arch));
    }

    @Nullable
    private static String getPropertyValue(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType systemClassType, @NotNull String propertyName) throws EvaluateException {
        if (evaluationContext == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(54);
        }
        if (systemClassType == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(55);
        }
        if (propertyName == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(56);
        }
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        Method getPropertyMethod = DebuggerUtils.findMethod((ReferenceType)systemClassType, (String)"getProperty", (String)"(Ljava/lang/String;)Ljava/lang/String;");
        if (getPropertyMethod == null) {
            return null;
        }
        StringReference propertyNameMirror = IdeaNativeAgentProxyMirror.getStringReference(evaluationContext, propertyName);
        StringReference propertyValueRef = (StringReference)evaluationContext.computeAndKeep(() -> debugProcess.invokeMethod(evaluationContext, systemClassType, getPropertyMethod, Collections.singletonList(propertyNameMirror), true));
        return propertyValueRef == null ? null : propertyValueRef.value();
    }

    @NotNull
    private static ArrayReference wrapWithArray(@NotNull EvaluationContextImpl context, @NotNull List<ObjectReference> references) throws EvaluateException {
        if (context == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(57);
        }
        if (references == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(58);
        }
        long start = System.currentTimeMillis();
        ArrayType longArray = (ArrayType)context.getDebugProcess().findClass(context, "java.lang.Object[]", context.getClassLoader());
        ArrayReference instancesArray = DebuggerUtilsEx.mirrorOfArray(longArray, references, (EvaluationContext)context);
        LOG.info("Wrapping values with array took " + (System.currentTimeMillis() - start) + " ms");
        ArrayReference arrayReference = instancesArray;
        if (arrayReference == null) {
            IdeaNativeAgentProxyMirror.$$$reportNull$$$0(59);
        }
        return arrayReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 25, 31, 34, 48, 49, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationFileName";
                break;
            }
            case 1: 
            case 23: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressFileName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 50: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 7: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 19: 
            case 25: 
            case 31: 
            case 34: 
            case 48: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/IdeaNativeAgentProxyMirror";
                break;
            }
            case 21: 
            case 28: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyType";
                break;
            }
            case 24: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeoutInMillis";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilityMethodName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 38: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemClassType";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentPath";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/IdeaNativeAgentProxyMirror";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyInstance";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongValue";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringReference";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "callMethod";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "readUtilityClass";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectSize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShallowAndRetainedSizeByClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = GET_SHALLOW_AND_RETAINED_SIZE_BY_OBJECTS;
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = GET_SHALLOW_SIZE_BY_CLASSES;
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = GET_RETAINED_SIZE_BY_CLASSES;
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = GET_SHALLOW_AND_RETAINED_SIZE_BY_CLASSES;
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPathsToClosestGCRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initializeCapabilities";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProxyType";
                break;
            }
            case 18: 
            case 19: 
            case 25: 
            case 31: 
            case 34: 
            case 48: 
            case 49: 
            case 59: {
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProxyInstance";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadProxyType";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkAgentCapability";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLongValue";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStringReference";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "callMethod";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "loadUtilityClass";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setAgentPathPropertyValue";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 25, 31, 34, 48, 49, 59 -> new IllegalStateException(string);
        };
    }
}

