/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MemoryAgentCapabilities {
    static final MemoryAgentCapabilities DISABLED = new MemoryAgentCapabilities(false, EnumSet.noneOf(Capability.class));
    private final boolean myIsLoaded;
    private final Set<Capability> myCapabilities;

    private MemoryAgentCapabilities(boolean isLoaded, @NotNull EnumSet<Capability> capabilitySet) {
        if (capabilitySet == null) {
            MemoryAgentCapabilities.$$$reportNull$$$0(0);
        }
        this.myIsLoaded = isLoaded;
        this.myCapabilities = EnumSet.copyOf(capabilitySet);
    }

    public boolean isDisabled() {
        return this == DISABLED;
    }

    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    public boolean canEstimateObjectSize() {
        return this.check(Capability.OBJECT_SIZE);
    }

    public boolean canEstimateObjectsSizes() {
        return this.check(Capability.OBJECTS_SIZES);
    }

    public boolean canFindPathsToClosestGcRoots() {
        return this.check(Capability.PATHS_TO_CLOSEST_GC_ROOTS);
    }

    public boolean canGetShallowSizeByClasses() {
        return this.check(Capability.SHALLOW_SIZE_BY_CLASSES);
    }

    public boolean canGetRetainedSizeByClasses() {
        return this.check(Capability.RETAINED_SIZE_BY_CLASSES);
    }

    private boolean check(Capability capability) {
        return this.myCapabilities.contains((Object)capability);
    }

    public String toString() {
        return "Agent capabilities: " + this.myCapabilities.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilitySet", "com/intellij/debugger/memory/agent/MemoryAgentCapabilities", "<init>"));
    }

    private static enum Capability {
        PATHS_TO_CLOSEST_GC_ROOTS,
        OBJECT_SIZE,
        OBJECTS_SIZES,
        SHALLOW_SIZE_BY_CLASSES,
        RETAINED_SIZE_BY_CLASSES;

    }

    static class Builder {
        private final EnumSet<Capability> myCapabilities = EnumSet.noneOf(Capability.class);

        Builder() {
        }

        public Builder setCanEstimateObjectSize(boolean value) {
            return this.update(Capability.OBJECT_SIZE, value);
        }

        public Builder setCanEstimateObjectsSizes(boolean value) {
            return this.update(Capability.OBJECTS_SIZES, value);
        }

        public Builder setCanGetShallowSizeByClasses(boolean value) {
            return this.update(Capability.SHALLOW_SIZE_BY_CLASSES, value);
        }

        public Builder setCanGetRetainedSizeByClasses(boolean value) {
            return this.update(Capability.RETAINED_SIZE_BY_CLASSES, value);
        }

        public Builder setCanFindPathsToClosestGcRoots(boolean value) {
            return this.update(Capability.PATHS_TO_CLOSEST_GC_ROOTS, value);
        }

        public MemoryAgentCapabilities buildLoaded() {
            return new MemoryAgentCapabilities(true, this.myCapabilities);
        }

        private Builder update(@NotNull Capability capability, boolean value) {
            if (capability == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (!value) {
                this.myCapabilities.remove((Object)capability);
            } else {
                this.myCapabilities.add(capability);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capability", "com/intellij/debugger/memory/agent/MemoryAgentCapabilities$Builder", "update"));
        }
    }
}

