/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.IdeaNativeAgentProxyMirror;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentActionResult;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentProgressPoint;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryAgentImpl
implements MemoryAgent {
    private static final Logger LOG = Logger.getInstance(MemoryAgentImpl.class);
    static final MemoryAgent DISABLED = new MemoryAgentImpl();
    private final IdeaNativeAgentProxyMirror myProxy;
    private MemoryAgentProgressTracker myProgressTracker;
    private MemoryAgentCapabilities myCapabilities;
    private MemoryAgentActionState myState;
    private File myCancellationFile;
    private ProgressIndicator myProgressIndicator;

    public static MemoryAgent createMemoryAgent(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(0);
        }
        MemoryAgentImpl memoryAgent = new MemoryAgentImpl();
        memoryAgent.myCapabilities = memoryAgent.initializeCapabilities(evaluationContext);
        if (memoryAgent.myCapabilities.isDisabled()) {
            return DISABLED;
        }
        return memoryAgent;
    }

    private MemoryAgentImpl() {
        String tempDir = FileUtil.getTempDirectory() + "/";
        int version = new Random().nextInt();
        this.myProxy = new IdeaNativeAgentProxyMirror(tempDir + "memoryAgentCancellationFile" + version, tempDir + "memoryAgentProgressFile" + version + ".json");
        this.myCapabilities = MemoryAgentCapabilities.DISABLED;
        this.myState = MemoryAgentActionState.FINISHED;
        this.myProgressTracker = MemoryAgentProgressTracker.DISABLED;
    }

    @NotNull
    private MemoryAgentCapabilities initializeCapabilities(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(1);
        }
        MemoryAgentCapabilities memoryAgentCapabilities = this.myProxy.initializeCapabilities(evaluationContext);
        if (memoryAgentCapabilities == null) {
            MemoryAgentImpl.$$$reportNull$$$0(2);
        }
        return memoryAgentCapabilities;
    }

    private <T> MemoryAgentActionResult<T> executeOperation(Callable<MemoryAgentActionResult<T>> callable) throws EvaluateException {
        if (this.myState == MemoryAgentActionState.RUNNING) {
            throw new EvaluateException("Some action is already running");
        }
        if (this.myCancellationFile != null) {
            FileUtil.delete((File)this.myCancellationFile);
            this.myCancellationFile = null;
        }
        this.myProgressTracker = this.myProgressIndicator != null ? new MemoryAgentProgressTrackerImpl(this, this.myProgressIndicator) : MemoryAgentProgressTracker.DISABLED;
        try {
            this.myState = MemoryAgentActionState.RUNNING;
            this.myProgressTracker.startMonitoringProgress();
            MemoryAgentActionResult<T> memoryAgentActionResult = callable.call();
            return memoryAgentActionResult;
        }
        catch (Exception ex) {
            throw new EvaluateException(ex.getMessage());
        }
        finally {
            this.myProgressTracker.stopMonitoringProgress();
            this.myProgressIndicator = null;
            this.myProgressTracker = MemoryAgentProgressTracker.DISABLED;
            FileUtil.delete((File)new File(this.myProxy.getProgressFileName()));
            this.myState = MemoryAgentActionState.FINISHED;
        }
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<Pair<long[], ObjectReference[]>> estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            MemoryAgentImpl.$$$reportNull$$$0(4);
        }
        if (!this.myCapabilities.canEstimateObjectSize()) {
            throw new UnsupportedOperationException("Memory agent can't estimate object size");
        }
        MemoryAgentActionResult<Pair<long[], ObjectReference[]>> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.estimateObjectSize(evaluationContext, reference, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(5);
        }
        return memoryAgentActionResult;
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizesByObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(6);
        }
        if (references == null) {
            MemoryAgentImpl.$$$reportNull$$$0(7);
        }
        if (!this.myCapabilities.canEstimateObjectsSizes()) {
            throw new UnsupportedOperationException("Memory agent can't estimate objects sizes");
        }
        MemoryAgentActionResult<Pair<long[], long[]>> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.getShallowAndRetainedSizesByObjects(evaluationContext, references, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(8);
        }
        return memoryAgentActionResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MemoryAgentActionResult<MemoryAgent.ObjectsAndSizes> getSortedShallowAndRetainedSizesByClass(@NotNull EvaluationContextImpl evaluationContext, @NotNull ReferenceType classType, long objectsLimit, long l) throws EvaluateException {
        void timeoutInMillis;
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(9);
        }
        if (classType == null) {
            MemoryAgentImpl.$$$reportNull$$$0(10);
        }
        if (!this.myCapabilities.canEstimateObjectsSizes()) {
            throw new UnsupportedOperationException("Memory agent can't estimate objects sizes");
        }
        MemoryAgentActionResult<MemoryAgent.ObjectsAndSizes> memoryAgentActionResult = this.executeOperation(() -> this.lambda$getSortedShallowAndRetainedSizesByClass$2(evaluationContext, classType, objectsLimit, (long)timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(11);
        }
        return memoryAgentActionResult;
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<long[]> getShallowSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(12);
        }
        if (classes == null) {
            MemoryAgentImpl.$$$reportNull$$$0(13);
        }
        if (!this.myCapabilities.canGetShallowSizeByClasses()) {
            throw new UnsupportedOperationException("Memory agent can't get shallow size by classes");
        }
        MemoryAgentActionResult<long[]> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.getShallowSizeByClasses(evaluationContext, classes, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(14);
        }
        return memoryAgentActionResult;
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<long[]> getRetainedSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(15);
        }
        if (classes == null) {
            MemoryAgentImpl.$$$reportNull$$$0(16);
        }
        if (!this.myCapabilities.canGetRetainedSizeByClasses()) {
            throw new UnsupportedOperationException("Memory agent can't get retained size by classes");
        }
        MemoryAgentActionResult<long[]> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.getRetainedSizeByClasses(evaluationContext, classes, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(17);
        }
        return memoryAgentActionResult;
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizeByClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ReferenceType> classes, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(18);
        }
        if (classes == null) {
            MemoryAgentImpl.$$$reportNull$$$0(19);
        }
        if (!this.myCapabilities.canGetRetainedSizeByClasses() || !this.myCapabilities.canGetShallowSizeByClasses()) {
            throw new UnsupportedOperationException("Memory agent can't get shallow and retained size by classes");
        }
        MemoryAgentActionResult<Pair<long[], long[]>> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.getShallowAndRetainedSizeByClasses(evaluationContext, classes, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(20);
        }
        return memoryAgentActionResult;
    }

    @Override
    @NotNull
    public MemoryAgentActionResult<ReferringObjectsInfo> findPathsToClosestGCRoots(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int pathsNumber, int objectsNumber, long timeoutInMillis) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(21);
        }
        if (reference == null) {
            MemoryAgentImpl.$$$reportNull$$$0(22);
        }
        if (!this.myCapabilities.canFindPathsToClosestGcRoots()) {
            throw new UnsupportedOperationException("Memory agent can't provide paths to closest gc roots");
        }
        MemoryAgentActionResult<ReferringObjectsInfo> memoryAgentActionResult = this.executeOperation(() -> this.myProxy.findPathsToClosestGCRoots(evaluationContext, reference, pathsNumber, objectsNumber, timeoutInMillis));
        if (memoryAgentActionResult == null) {
            MemoryAgentImpl.$$$reportNull$$$0(23);
        }
        return memoryAgentActionResult;
    }

    @Override
    public void cancelAction() {
        if (this.myState == MemoryAgentActionState.RUNNING) {
            try {
                this.myProgressTracker.cancelMonitoringProgress();
                this.myCancellationFile = FileUtil.createTempFile((String)this.myProxy.getCancellationFileName(), (String)"", (boolean)true);
                this.myState = MemoryAgentActionState.CANCELLED;
            }
            catch (IOException ex) {
                LOG.error("Couldn't create memory agent cancellation file", (Throwable)ex);
            }
        }
    }

    @Override
    public void setProgressIndicator(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            MemoryAgentImpl.$$$reportNull$$$0(24);
        }
        this.myProgressIndicator = progressIndicator;
    }

    @Override
    @Nullable
    public MemoryAgentProgressPoint checkProgress() {
        return this.myProxy.checkProgress();
    }

    @Override
    @NotNull
    public MemoryAgentCapabilities getCapabilities() {
        MemoryAgentCapabilities memoryAgentCapabilities = this.myCapabilities;
        if (memoryAgentCapabilities == null) {
            MemoryAgentImpl.$$$reportNull$$$0(25);
        }
        return memoryAgentCapabilities;
    }

    @Override
    public boolean isDisabled() {
        return this == DISABLED;
    }

    private /* synthetic */ MemoryAgentActionResult lambda$getSortedShallowAndRetainedSizesByClass$2(EvaluationContextImpl evaluationContext, ReferenceType classType, long objectsLimit, long timeoutInMillis) throws Exception {
        return this.myProxy.getShallowAndRetainedSizeByClass(evaluationContext, classType, objectsLimit, timeoutInMillis);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 11, 14, 17, 20, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentImpl";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeCapabilities";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "estimateObjectSize";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShallowAndRetainedSizesByObjects";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedShallowAndRetainedSizesByClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShallowSizeByClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRetainedSizeByClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getShallowAndRetainedSizeByClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathsToClosestGCRoots";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMemoryAgent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeCapabilities";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectSize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShallowAndRetainedSizesByObjects";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSortedShallowAndRetainedSizesByClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getShallowSizeByClasses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRetainedSizeByClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getShallowAndRetainedSizeByClasses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPathsToClosestGCRoots";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setProgressIndicator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 11, 14, 17, 20, 23, 25 -> new IllegalStateException(string);
        };
    }

    private static enum MemoryAgentActionState {
        RUNNING,
        FINISHED,
        CANCELLED;

    }

    private static interface MemoryAgentProgressTracker {
        public static final MemoryAgentProgressTracker DISABLED = new MemoryAgentProgressTracker(){};

        default public void startMonitoringProgress() {
        }

        default public void cancelMonitoringProgress() {
        }

        default public void stopMonitoringProgress() {
        }
    }

    private static class MemoryAgentProgressTrackerImpl
    implements MemoryAgentProgressTracker {
        private static final int PROGRESS_CHECKING_DELAY_MS = 500;
        private final ProgressIndicator myProgressIndicator;
        private final MemoryAgent myAgent;
        private final ReentrantLock myProgressIndicatorLock;
        private ScheduledFuture<?> myProgressCheckingFuture;

        MemoryAgentProgressTrackerImpl(@NotNull MemoryAgent agent, @NotNull ProgressIndicator progressIndicator) {
            if (agent == null) {
                MemoryAgentProgressTrackerImpl.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                MemoryAgentProgressTrackerImpl.$$$reportNull$$$0(1);
            }
            this.myProgressIndicatorLock = new ReentrantLock();
            this.myAgent = agent;
            this.myProgressIndicator = progressIndicator;
        }

        @Override
        public void startMonitoringProgress() {
            this.myProgressIndicator.start();
            this.myProgressCheckingFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::updateProgress, 0L, 500L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void cancelMonitoringProgress() {
            this.stopMonitoringProgress(true);
        }

        @Override
        public void stopMonitoringProgress() {
            this.stopMonitoringProgress(false);
        }

        private void stopMonitoringProgress(boolean cancel) {
            try {
                this.myProgressIndicatorLock.lock();
                if (this.myProgressCheckingFuture != null) {
                    this.myProgressCheckingFuture.cancel(true);
                }
                if (this.myProgressIndicator.isRunning()) {
                    if (cancel) {
                        this.myProgressIndicator.cancel();
                    } else {
                        this.myProgressIndicator.stop();
                    }
                }
                this.myProgressCheckingFuture = null;
            }
            finally {
                this.myProgressIndicatorLock.unlock();
            }
        }

        private void updateProgress() {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            MemoryAgentProgressPoint progressPoint = this.myAgent.checkProgress();
            if (progressPoint == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    this.myProgressIndicatorLock.lock();
                    if (this.myProgressIndicator.isRunning()) {
                        this.myProgressIndicator.setText(progressPoint.getMessage());
                        this.myProgressIndicator.setFraction(progressPoint.getFraction());
                    }
                }
                finally {
                    this.myProgressIndicatorLock.unlock();
                }
            });
            if (progressPoint.isFinished()) {
                this.stopMonitoringProgress();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "agent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "progressIndicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/agent/MemoryAgentImpl$MemoryAgentProgressTrackerImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

