/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.extractor.AgentExtractor;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.SizedReferenceInfo;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryAgentUtil {
    private static final Logger LOG = Logger.getInstance(MemoryAgentUtil.class);
    private static final String MEMORY_AGENT_EXTRACT_DIRECTORY = "memory.agent.extract.dir";

    @Nullable
    static String getAgentFilePathAsString(boolean isInDebugMode, @NotNull AgentExtractor.AgentLibraryType libraryType) throws ExecutionException, InterruptedException, TimeoutException {
        if (libraryType == null) {
            MemoryAgentUtil.$$$reportNull$$$0(0);
        }
        Path agentFile = MemoryAgentUtil.getAgentFile(isInDebugMode, libraryType);
        return JavaExecutionUtil.handleSpacesInAgentPath((String)agentFile.toAbsolutePath().toString(), (String)"debugger-memory-agent", (String)MEMORY_AGENT_EXTRACT_DIRECTORY);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AgentExtractor.AgentLibraryType detectAgentKindByArch(CpuArch arch) {
        LOG.assertTrue(MemoryAgentUtil.isPlatformSupported());
        if (OS.CURRENT == OS.Linux && arch == CpuArch.X86_64) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.LINUX_X64;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(1);
            }
            return agentLibraryType;
        }
        if (OS.CURRENT == OS.Linux && arch == CpuArch.ARM64) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.LINUX_AARCH64;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(2);
            }
            return agentLibraryType;
        }
        if (OS.CURRENT == OS.macOS) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.MACOS;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(3);
            }
            return agentLibraryType;
        }
        if (OS.CURRENT == OS.Windows && arch == CpuArch.ARM64) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.WINDOWS_ARM64;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(4);
            }
            return agentLibraryType;
        }
        if (OS.CURRENT == OS.Windows && arch == CpuArch.X86_64) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.WINDOWS64;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(5);
            }
            return agentLibraryType;
        }
        if (OS.CURRENT == OS.Windows && arch == CpuArch.X86) {
            AgentExtractor.AgentLibraryType agentLibraryType = AgentExtractor.AgentLibraryType.WINDOWS32;
            if (agentLibraryType == null) {
                MemoryAgentUtil.$$$reportNull$$$0(6);
            }
            return agentLibraryType;
        }
        throw new IllegalStateException("Unsupported OS and arch: " + String.valueOf(OS.CURRENT) + " " + String.valueOf(arch));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<JavaReferenceInfo> calculateSizes(@NotNull EvaluationContextImpl context, @NotNull ReferenceType classType, long objectsLimit, @NotNull ProgressIndicator progressIndicator) {
        List list;
        void progressIndicator2;
        if (context == null) {
            MemoryAgentUtil.$$$reportNull$$$0(7);
        }
        if (classType == null) {
            MemoryAgentUtil.$$$reportNull$$$0(8);
        }
        if (progressIndicator == null) {
            MemoryAgentUtil.$$$reportNull$$$0(9);
        }
        MemoryAgent agent = MemoryAgent.get(context);
        agent.setProgressIndicator((ProgressIndicator)progressIndicator2);
        try {
            MemoryAgent.ObjectsAndSizes objectsAndSizes = agent.getSortedShallowAndRetainedSizesByClass(context, classType, objectsLimit, Registry.get((String)"debugger.memory.agent.action.timeout").asInteger()).getResult();
            list = IntStreamEx.range((int)0, (int)objectsAndSizes.getObjects().length).mapToObj(i -> new SizedReferenceInfo(objectsAndSizes.getObjects()[i], objectsAndSizes.getShallowSizes()[i], objectsAndSizes.getRetainedSizes()[i])).toList();
        }
        catch (EvaluateException e) {
            LOG.error("Could not estimate objects sizes", (Throwable)e);
            List<JavaReferenceInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                MemoryAgentUtil.$$$reportNull$$$0(11);
            }
            return list2;
        }
        if (list == null) {
            MemoryAgentUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static List<JavaReferenceInfo> calculateSizesByObjects(@NotNull EvaluationContextImpl context, @NotNull List<ObjectReference> references, @NotNull ProgressIndicator progressIndicator) {
        if (context == null) {
            MemoryAgentUtil.$$$reportNull$$$0(12);
        }
        if (references == null) {
            MemoryAgentUtil.$$$reportNull$$$0(13);
        }
        if (progressIndicator == null) {
            MemoryAgentUtil.$$$reportNull$$$0(14);
        }
        MemoryAgent agent = MemoryAgent.get(context);
        agent.setProgressIndicator(progressIndicator);
        try {
            Pair<long[], long[]> sizes = agent.getShallowAndRetainedSizesByObjects(context, references, Registry.get((String)"debugger.memory.agent.action.timeout").asInteger()).getResult();
            return ((StreamEx)IntStreamEx.range((int)0, (int)references.size()).mapToObj(i -> new SizedReferenceInfo((ObjectReference)references.get(i), ((long[])sizes.first)[i], ((long[])sizes.second)[i])).sortedBy(ref -> -ref.getRetainedSize())).map(ref -> ref).toList();
        }
        catch (EvaluateException e) {
            LOG.error("Could not estimate objects sizes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static boolean isPlatformSupported() {
        return SystemInfo.isWindows && (CpuArch.isIntel32() || CpuArch.isIntel64() || CpuArch.isArm64()) || SystemInfo.isMac && (CpuArch.isIntel64() || CpuArch.isArm64()) || SystemInfo.isLinux && (CpuArch.isIntel64() || CpuArch.isArm64());
    }

    @NotNull
    private static Path getAgentFile(boolean isInDebugMode, @NotNull AgentExtractor.AgentLibraryType libraryType) throws InterruptedException, ExecutionException, TimeoutException {
        String debugAgentPath;
        if (libraryType == null) {
            MemoryAgentUtil.$$$reportNull$$$0(15);
        }
        if (isInDebugMode && !(debugAgentPath = Registry.get((String)"debugger.memory.agent.debug.path").asString()).isEmpty()) {
            LOG.info("Local memory agent will be used: " + debugAgentPath);
            Path path = Paths.get(debugAgentPath, new String[0]);
            if (path == null) {
                MemoryAgentUtil.$$$reportNull$$$0(16);
            }
            return path;
        }
        Path path = (Path)ApplicationManager.getApplication().executeOnPooledThread(() -> AgentExtractor.INSTANCE.extract(libraryType, MemoryAgentUtil.getAgentDirectory())).get(1L, TimeUnit.SECONDS);
        if (path == null) {
            MemoryAgentUtil.$$$reportNull$$$0(17);
        }
        return path;
    }

    @NotNull
    private static Path getAgentDirectory() {
        String agentDirectory = System.getProperty(MEMORY_AGENT_EXTRACT_DIRECTORY);
        if (agentDirectory != null) {
            File file = new File(agentDirectory);
            if (file.exists() || file.mkdirs()) {
                Path path = file.toPath();
                if (path == null) {
                    MemoryAgentUtil.$$$reportNull$$$0(18);
                }
                return path;
            }
            LOG.info("Directory specified in property \"memory.agent.extract.dir\" not found. Default tmp directory will be used");
        }
        Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        if (path == null) {
            MemoryAgentUtil.$$$reportNull$$$0(19);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 10, 11, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentUtil";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAgentKindByArch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSizes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAgentFilePathAsString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateSizes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateSizesByObjects";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAgentFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 10, 11, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

