/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ReferringObjectsInfo {
    private static final Logger LOG = Logger.getInstance(ReferringObjectsInfo.class);
    private final Map<ObjectReference, Integer> myReversedMap;
    private final List<List<ReferringObject>> myReferrers;

    public ReferringObjectsInfo(@NotNull List<? extends ObjectReference> values, @NotNull List<List<ReferringObject>> referrers) {
        if (values == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(0);
        }
        if (referrers == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(1);
        }
        this.myReversedMap = new HashMap<ObjectReference, Integer>();
        for (int i = 0; i < values.size(); ++i) {
            this.myReversedMap.put(values.get(i), i);
        }
        this.myReferrers = referrers;
    }

    public boolean hasReferringObjectsFor(@NotNull ObjectReference reference) {
        if (reference == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(2);
        }
        return this.myReversedMap.containsKey(reference);
    }

    @TestOnly
    @NotNull
    public List<ObjectReference> getAllReferrers(@NotNull ObjectReference value) {
        if (value == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(3);
        }
        List<ObjectReference> list = this.myReferrers.get(this.myReversedMap.get(value)).stream().distinct().map(ReferringObject::getReference).filter(ref -> ref != null).collect(Collectors.toList());
        if (list == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull ObjectReference value, long limit) {
        Integer index;
        if (value == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(5);
        }
        if ((index = this.myReversedMap.get(value)) == null) {
            LOG.error("Could not find referring object for reference " + String.valueOf(value));
            List<ReferringObject> list = Collections.emptyList();
            if (list == null) {
                ReferringObjectsInfo.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<ReferringObject> list = this.myReferrers.get(index).stream().distinct().limit(limit).collect(Collectors.toList());
        if (list == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referrers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/ReferringObjectsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/ReferringObjectsInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferrers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferringObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasReferringObjectsFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllReferrers";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferringObjects";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

