/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.ObjectReferencesParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00030\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/SizeAndHeldObjectsParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "Lcom/intellij/openapi/util/Pair;", "", "", "Lcom/sun/jdi/ObjectReference;", "<init>", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/SizeAndHeldObjectsParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,248:1\n37#2,2:249\n37#2,2:251\n*S KotlinDebug\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/SizeAndHeldObjectsParser\n*L\n159#1:249,2\n160#1:251,2\n*E\n"})
public final class SizeAndHeldObjectsParser
implements ResultParser<Pair<Long[], ObjectReference[]>> {
    @NotNull
    public static final SizeAndHeldObjectsParser INSTANCE = new SizeAndHeldObjectsParser();

    private SizeAndHeldObjectsParser() {
    }

    @Override
    @NotNull
    public Pair<Long[], ObjectReference[]> parse(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueFormatException("Array expected");
        }
        if (((ArrayReference)value).length() < 2) {
            throw new UnexpectedValueFormatException("array of longs and array of objects expected");
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
        Collection $this$toTypedArray$iv = (Collection)LongArrayParser.INSTANCE.parse(value2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long[] longArray = thisCollection$iv.toArray(new Long[0]);
        Value value3 = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
        $this$toTypedArray$iv = (Collection)ObjectReferencesParser.INSTANCE.parse(value3);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return new Pair((Object)longArray, (Object)thisCollection$iv.toArray(new ObjectReference[0]));
    }
}

