/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.ObjectReferencesParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/SizesAndObjectsOfClassParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "Lcom/intellij/debugger/memory/agent/MemoryAgent$ObjectsAndSizes;", "<init>", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/SizesAndObjectsOfClassParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,248:1\n37#2,2:249\n*S KotlinDebug\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/SizesAndObjectsOfClassParser\n*L\n170#1:249,2\n*E\n"})
public final class SizesAndObjectsOfClassParser
implements ResultParser<MemoryAgent.ObjectsAndSizes> {
    @NotNull
    public static final SizesAndObjectsOfClassParser INSTANCE = new SizesAndObjectsOfClassParser();

    private SizesAndObjectsOfClassParser() {
    }

    @Override
    @NotNull
    public MemoryAgent.ObjectsAndSizes parse(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueFormatException("Array expected");
        }
        if (((ArrayReference)value).length() < 3) {
            throw new UnexpectedValueFormatException("two arrays of longs and one array of objects expected");
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
        Collection $this$toTypedArray$iv = (Collection)ObjectReferencesParser.INSTANCE.parse(value2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Value value3 = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
        long[] lArray = CollectionsKt.toLongArray((Collection)((Collection)LongArrayParser.INSTANCE.parse(value3)));
        Value value4 = ((ArrayReference)value).getValue(2);
        Intrinsics.checkNotNullExpressionValue((Object)value4, (String)"getValue(...)");
        return new MemoryAgent.ObjectsAndSizes(thisCollection$iv.toArray(new ObjectReference[0]), lArray, CollectionsKt.toLongArray((Collection)((Collection)LongArrayParser.INSTANCE.parse(value4))));
    }
}

