/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ui.MemoryAgentDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.util.HashSet;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsToClosestGcRootsDialog
extends MemoryAgentDialog {
    public PathsToClosestGcRootsDialog(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, @NotNull String name, @NotNull XValue value, XValueMarkers<?, ?> markers, @Nullable XDebugSession session, boolean rebuildOnSessionEvents) {
        if (project == null) {
            PathsToClosestGcRootsDialog.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PathsToClosestGcRootsDialog.$$$reportNull$$$0(1);
        }
        if (value == null) {
            PathsToClosestGcRootsDialog.$$$reportNull$$$0(2);
        }
        super(project, name, value, session, new XDebuggerTree(project, editorsProvider, sourcePosition, "XDebugger.Inspect.Tree.Popup", markers), rebuildOnSessionEvents);
        this.setTitle(JavaDebuggerBundle.message((String)"paths.to.closest.gc.roots.for", (Object[])new Object[]{name}));
        this.myTree.expandNodesOnLoad(treeNode -> PathsToClosestGcRootsDialog.isInTopSubTree(treeNode));
        if (session != null) {
            this.addProgressIndicator(session);
        }
    }

    private void addProgressIndicator(@NotNull XDebugSession session) {
        XDebugProcess process;
        if (session == null) {
            PathsToClosestGcRootsDialog.$$$reportNull$$$0(3);
        }
        if (!((process = session.getDebugProcess()) instanceof JavaDebugProcess)) {
            return;
        }
        JavaDebugProcess javaDebugProcess = (JavaDebugProcess)process;
        DebugProcessImpl debugProcess = javaDebugProcess.getDebuggerSession().getProcess();
        SuspendContextImpl suspendContext = debugProcess.getSuspendManager().getPausedContext();
        final PathsToClosestGcRootsDialog dialog = this;
        suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(this, suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dialog.isDisposed()) {
                    return;
                }
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext);
                Disposer.register((Disposable)dialog.getDisposable(), () -> memoryAgent.cancelAction());
                memoryAgent.setProgressIndicator(dialog.createProgressIndicator());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/agent/ui/PathsToClosestGcRootsDialog$1", "contextAction"));
            }
        });
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#javadebugger.PathsToClosestGcRootsDialog";
    }

    private static boolean isInTopSubTree(@NotNull TreeNode node) {
        if (node == null) {
            PathsToClosestGcRootsDialog.$$$reportNull$$$0(4);
        }
        HashSet<TreeNode> visited = new HashSet<TreeNode>();
        while (node.getParent() != null) {
            if (!visited.add(node) || visited.size() > 10) {
                return false;
            }
            if (node != node.getParent().getChildAt(0)) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/agent/ui/PathsToClosestGcRootsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgressIndicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInTopSubTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

