/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.component.TrackedStacksContainer;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryViewDebugProcessData {
    public static final Key<MemoryViewDebugProcessData> KEY = Key.create((String)"MemoryView.DebugProcessData");
    private final TrackedStacksContainer myStacksContainer = new MyStackContainer();

    @NotNull
    public TrackedStacksContainer getTrackedStacks() {
        TrackedStacksContainer trackedStacksContainer = this.myStacksContainer;
        if (trackedStacksContainer == null) {
            MemoryViewDebugProcessData.$$$reportNull$$$0(0);
        }
        return trackedStacksContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData", "getTrackedStacks"));
    }

    private static class MyStackContainer
    implements TrackedStacksContainer {
        private final Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> myType2Reference2Stack = new ConcurrentHashMap<ReferenceType, Map<ObjectReference, List<StackFrameItem>>>();
        private final Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> myPinnedType2Reference2Stack = new ConcurrentHashMap<ReferenceType, Map<ObjectReference, List<StackFrameItem>>>();

        private MyStackContainer() {
        }

        @Override
        @Nullable
        public List<StackFrameItem> getStack(@NotNull ObjectReference reference) {
            List<StackFrameItem> stack;
            if (reference == null) {
                MyStackContainer.$$$reportNull$$$0(0);
            }
            return (stack = MyStackContainer.extract(this.myType2Reference2Stack, reference)) != null ? stack : MyStackContainer.extract(this.myPinnedType2Reference2Stack, reference);
        }

        @Override
        public void addStack(@NotNull ObjectReference ref, @NotNull List<StackFrameItem> frames) {
            if (ref == null) {
                MyStackContainer.$$$reportNull$$$0(1);
            }
            if (frames == null) {
                MyStackContainer.$$$reportNull$$$0(2);
            }
            this.myType2Reference2Stack.computeIfAbsent(ref.referenceType(), referenceType -> new ConcurrentHashMap()).put(ref, frames);
        }

        @Override
        public void pinStacks(@NotNull ReferenceType referenceType) {
            Map<ObjectReference, List<StackFrameItem>> ref2Stack;
            if (referenceType == null) {
                MyStackContainer.$$$reportNull$$$0(3);
            }
            if ((ref2Stack = this.myType2Reference2Stack.get(referenceType)) != null) {
                this.myPinnedType2Reference2Stack.put(referenceType, ref2Stack);
            }
        }

        @Override
        public void unpinStacks(@NotNull ReferenceType referenceType) {
            if (referenceType == null) {
                MyStackContainer.$$$reportNull$$$0(4);
            }
            this.myPinnedType2Reference2Stack.remove(referenceType);
        }

        @Override
        public void release() {
            this.myType2Reference2Stack.clear();
        }

        @Override
        public void clear() {
            this.release();
            this.myPinnedType2Reference2Stack.clear();
        }

        @Nullable
        private static List<StackFrameItem> extract(@NotNull Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> map2, @NotNull ObjectReference ref) {
            Map<ObjectReference, List<StackFrameItem>> ref2Stack;
            if (map2 == null) {
                MyStackContainer.$$$reportNull$$$0(5);
            }
            if (ref == null) {
                MyStackContainer.$$$reportNull$$$0(6);
            }
            return (ref2Stack = map2.get(ref.referenceType())) != null ? ref2Stack.get(ref) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frames";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStack";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStack";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pinStacks";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unpinStacks";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

