/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.memory.filtering.InstanceProviderEx;
import com.intellij.debugger.memory.filtering.ProvidersKt;
import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/memory/filtering/ClassInstancesProvider;", "Lcom/intellij/debugger/memory/filtering/InstanceProviderEx;", "referenceType", "Lcom/sun/jdi/ReferenceType;", "<init>", "(Lcom/sun/jdi/ReferenceType;)V", "getInstances", "", "Lcom/intellij/xdebugger/memory/ui/ReferenceInfo;", "limit", "", "returnAllInstancesOfAClass", "", "estimateInstancesCount", "intellij.java.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nproviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 providers.kt\ncom/intellij/debugger/memory/filtering/ClassInstancesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class ClassInstancesProvider
implements InstanceProviderEx {
    @NotNull
    private final ReferenceType referenceType;

    public ClassInstancesProvider(@NotNull ReferenceType referenceType) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        this.referenceType = referenceType;
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        return ProvidersKt.access$mapToInfoList(this.referenceType.instances(limit));
    }

    @Override
    public boolean returnAllInstancesOfAClass() {
        return true;
    }

    @Override
    public int estimateInstancesCount() {
        long it = this.referenceType.virtualMachine().instanceCounts(CollectionsKt.listOf((Object)this.referenceType))[0];
        boolean bl = false;
        return it < 0L || it > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)it;
    }
}

