/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.memory.filtering.InstanceProviderEx;
import com.intellij.debugger.memory.filtering.ProvidersKt;
import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.sun.jdi.ObjectReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/memory/filtering/FixedListProvider;", "Lcom/intellij/debugger/memory/filtering/InstanceProviderEx;", "references", "", "Lcom/sun/jdi/ObjectReference;", "<init>", "(Ljava/util/List;)V", "getInstances", "", "Lcom/intellij/xdebugger/memory/ui/ReferenceInfo;", "limit", "", "returnAllInstancesOfAClass", "", "estimateInstancesCount", "intellij.java.debugger.impl"})
public final class FixedListProvider
implements InstanceProviderEx {
    @NotNull
    private final List<ObjectReference> references;

    public FixedListProvider(@NotNull List<? extends ObjectReference> references) {
        Intrinsics.checkNotNullParameter(references, (String)"references");
        this.references = references;
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        return ProvidersKt.access$mapToInfoList(this.references);
    }

    @Override
    public boolean returnAllInstancesOfAClass() {
        return false;
    }

    @Override
    public int estimateInstancesCount() {
        return this.references.size();
    }
}

