/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

class FilteringProgressView
extends BorderLayoutPanel {
    private final JProgressBar myProgressBar = new JProgressBar();
    private final BorderLayoutPanel myProgressPanel = new BorderLayoutPanel();
    private final JBLabel myStopButton = new JBLabel(StartupUiUtil.isUnderDarcula() ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    private final JBLabel myProgressText = new JBLabel();

    FilteringProgressView() {
        this.myStopButton.setOpaque(true);
        this.myProgressPanel.addToCenter((Component)this.myProgressBar);
        this.myProgressPanel.addToRight((Component)this.myStopButton);
        this.addToTop((Component)this.myProgressText);
        this.addToCenter((Component)this.myProgressPanel);
    }

    ProgressIndicator getProgressIndicator() {
        return new InstancesProgressIndicator();
    }

    void addStopActionListener(final @NotNull Runnable listener2) {
        if (listener2 == null) {
            FilteringProgressView.$$$reportNull$$$0(0);
        }
        this.myStopButton.addMouseListener((MouseListener)new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                listener2.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/debugger/memory/ui/FilteringProgressView", "addStopActionListener"));
    }

    class InstancesProgressIndicator
    extends ProgressIndicatorBase {
        InstancesProgressIndicator() {
        }

        public void start() {
            super.start();
            FilteringProgressView.this.myProgressBar.setMinimum(0);
            FilteringProgressView.this.myProgressBar.setMaximum(100);
            FilteringProgressView.this.myProgressBar.setValue(0);
            FilteringProgressView.this.myProgressPanel.setVisible(true);
        }

        public void stop() {
            super.stop();
            FilteringProgressView.this.myProgressPanel.setVisible(false);
        }

        public void setText(String text) {
            super.setText(text);
            FilteringProgressView.this.myProgressText.setText(text);
        }

        public void setFraction(double fraction) {
            super.setFraction(fraction);
            FilteringProgressView.this.myProgressBar.setMinimum(0);
            FilteringProgressView.this.myProgressBar.setMaximum(100);
            FilteringProgressView.this.myProgressBar.setValue((int)(fraction * 100.0));
        }
    }
}

