/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.sun.jdi.ObjectReference;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InstancesWithStackFrameView {
    private static final float DEFAULT_SPLITTER_PROPORTION = 0.7f;
    private float myHidedProportion;
    private final JBSplitter mySplitter;
    private boolean myIsHided;

    InstancesWithStackFrameView(@NotNull XDebugSession debugSession, @NotNull JComponent component, @NotNull InstancesTree tree, @NotNull StackFrameList list, final @NotNull String className) {
        JBLabel stackTraceLabel;
        if (debugSession == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(0);
        }
        if (component == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(2);
        }
        if (list == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(3);
        }
        if (className == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(4);
        }
        this.mySplitter = new JBSplitter(false, 0.7f);
        this.myIsHided = false;
        this.mySplitter.setFirstComponent(component);
        Project project = debugSession.getProject();
        list.setEmptyText(JavaDebuggerBundle.message((String)"status.text.select.instance.to.see.stack.frame", (Object[])new Object[0]));
        if (InstancesWithStackFrameView.isArrayType(className)) {
            stackTraceLabel = new JBLabel(JavaDebuggerBundle.message((String)"label.arrays.could.not.be.tracked", (Object[])new Object[0]), 0);
        } else {
            ActionLink actionLink = new ActionLink(JavaDebuggerBundle.message((String)"enable.tracking.for.new.instances", (Object[])new Object[0]), AllIcons.Debugger.Watch, new AnAction(this){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Project project;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((project = e.getProject()) != null && !project.isDisposed()) {
                        InstancesTracker.getInstance((Project)project).add(className, TrackingType.CREATION);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$1", "actionPerformed"));
                }
            });
            actionLink.setHorizontalAlignment(0);
            actionLink.setPaintUnderline(false);
            stackTraceLabel = actionLink;
        }
        this.mySplitter.setSplitterProportionKey("InstancesWithStackFrameView.SplitterKey");
        JBScrollPane stackComponent = new JBScrollPane((Component)((Object)list));
        if (!project.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project);
            tracker.addTrackerListener(new InstancesTrackerListener(){
                final /* synthetic */ JComponent val$stackComponent;
                final /* synthetic */ JLabel val$stackTraceLabel;
                {
                    this.val$stackComponent = jComponent;
                    this.val$stackTraceLabel = jLabel;
                }

                public void classChanged(@NotNull String name, @NotNull TrackingType type) {
                    if (name == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (Objects.equals(className, name) && type == TrackingType.CREATION) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent(this.val$stackComponent);
                    }
                }

                public void classRemoved(@NotNull String name) {
                    if (name == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (Objects.equals(name, className)) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent((JComponent)this.val$stackTraceLabel);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classChanged";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)tree);
            this.mySplitter.setSecondComponent((JComponent)(tracker.isTracked(className) ? stackComponent : stackTraceLabel));
        }
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.myHidedProportion = 0.7f;
        DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)project).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
        MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
        tree.addTreeSelectionListener(e -> {
            ObjectReference ref = InstancesWithStackFrameView.getSelectedReference(tree);
            if (ref != null && data != null) {
                List<StackFrameItem> stack = data.getTrackedStacks().getStack(ref);
                if (stack != null) {
                    list.setFrameItems(stack, debugProcess);
                    if (this.mySplitter.getProportion() == 1.0f) {
                        this.mySplitter.setProportion(0.7f);
                    }
                    return;
                }
                list.setEmptyText(JavaDebuggerBundle.message((String)"status.text.no.stack.frame.for.this.instance", (Object[])new Object[0]));
            } else {
                list.setEmptyText(JavaDebuggerBundle.message((String)"status.text.select.instance.to.see.stack.frame", (Object[])new Object[0]));
            }
            list.clearFrameItems();
        });
    }

    @Nullable
    private static ObjectReference getSelectedReference(InstancesTree tree) {
        NodeDescriptorProvider descriptorProvider;
        XValueNodeImpl xValueNode;
        Object object;
        Object selectedItem;
        TreePath selectionPath = tree.getSelectionPath();
        Object object2 = selectedItem = selectionPath != null ? selectionPath.getLastPathComponent() : null;
        if (selectedItem instanceof XValueNodeImpl && (object = (xValueNode = (XValueNodeImpl)selectedItem).getValueContainer()) instanceof NodeDescriptorProvider && (object = (descriptorProvider = (NodeDescriptorProvider)object).getDescriptor()) instanceof ValueDescriptor) {
            ValueDescriptor valueDescriptor = (ValueDescriptor)object;
            return (ObjectReference)ObjectUtils.tryCast((Object)valueDescriptor.getValue(), ObjectReference.class);
        }
        return null;
    }

    JComponent getComponent() {
        return this.mySplitter;
    }

    private static boolean isArrayType(@NotNull String className) {
        if (className == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(5);
        }
        return className.contains("[]");
    }

    private void hideStackFrame() {
        if (!this.myIsHided) {
            this.myHidedProportion = this.mySplitter.getProportion();
            this.mySplitter.getSecondComponent().setVisible(false);
            this.mySplitter.setProportion(1.0f);
            this.myIsHided = true;
        }
    }

    private void showStackFrame() {
        if (this.myIsHided) {
            this.mySplitter.getSecondComponent().setVisible(true);
            this.mySplitter.setProportion(this.myHidedProportion);
            this.myIsHided = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

