/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackFramePopup {
    public static void show(@NotNull List<@Nullable StackFrameItem> stack, DebugProcessImpl debugProcess) {
        if (stack == null) {
            StackFramePopup.$$$reportNull$$$0(0);
        }
        StackFramePopup.show(stack, debugProcess, null, 1);
    }

    public static void show(@NotNull List<@Nullable StackFrameItem> stack, DebugProcessImpl debugProcess, @Nullable RelativePoint point, int selectedIndex) {
        if (stack == null) {
            StackFramePopup.$$$reportNull$$$0(1);
        }
        StackFrameList list = new StackFrameList(debugProcess.getProject());
        list.setFrameItems(stack, debugProcess, StackFramePopup.showPopupOnDone(point, selectedIndex, list));
    }

    public static void show(@NotNull List<@Nullable XStackFrame> stack, @NotNull Project project, @Nullable RelativePoint point, int selectedIndex) {
        if (stack == null) {
            StackFramePopup.$$$reportNull$$$0(2);
        }
        if (project == null) {
            StackFramePopup.$$$reportNull$$$0(3);
        }
        StackFrameList list = new StackFrameList(project);
        list.setFrameItems(stack, StackFramePopup.showPopupOnDone(point, selectedIndex, list));
    }

    @NotNull
    private static Runnable showPopupOnDone(@Nullable RelativePoint point, int selectedIndex, StackFrameList list) {
        Runnable runnable = () -> DebuggerUIUtil.invokeLater(() -> {
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)((Object)list)).setTitle(JavaDebuggerBundle.message((String)"select.stack.frame", (Object[])new Object[0])).setAutoSelectIfEmpty(true).setResizable(false).setItemChosenCallback(() -> list.navigateToSelectedValue(true)).createPopup();
            list.setSelectedIndex(selectedIndex);
            if (point != null) {
                popup.show(point);
            } else {
                popup.showInFocusCenter();
            }
        });
        if (runnable == null) {
            StackFramePopup.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/ui/StackFramePopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/ui/StackFramePopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupOnDone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

