/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JavaValuePresentation;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.debugger.ui.tree.render.XValuePresentationProvider;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.function.BiFunction;
import org.jdom.Element;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.xml")}, category=SettingsCategory.TOOLS)
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(NodeRendererSettings.class);
    @NonNls
    private static final String REFERENCE_RENDERER = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String RENDERER_ID = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> myDispatcher = EventDispatcher.create(NodeRendererSettingsListener.class);
    private final RendererConfiguration myCustomRenderers = new RendererConfiguration(this);
    private final PrimitiveRenderer myPrimitiveRenderer = new PrimitiveRenderer();
    private final ArrayRenderer myArrayRenderer = new ArrayRenderer();
    private final ClassRenderer myClassRenderer = new ClassRenderer();
    private final HexRenderer myHexRenderer = new HexRenderer();
    private final ToStringRenderer myToStringRenderer = new ToStringRenderer();
    private final NodeRenderer[] myAlternateCollectionRenderers = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.createLabelRenderer(" size = ", "size()"), NodeRendererSettings.createExpressionArrayChildrenRenderer("entrySet().toArray()", "!isEmpty()", this.myArrayRenderer)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.myArrayRenderer), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.createLabelRenderer(" size = ", "size()"), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", this.myArrayRenderer))};
    @NonNls
    private static final String HEX_VIEW_ENABLED = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_COLLECTION_VIEW_ENABLED = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String CUSTOM_RENDERERS_TAG_NAME = "CustomRenderers";

    public NodeRendererSettings() {
        this.myHexRenderer.setEnabled(false);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ApplicationManager.getApplication().getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean enabled) {
        for (NodeRenderer myAlternateCollectionRenderer : this.myAlternateCollectionRenderers) {
            myAlternateCollectionRenderer.setEnabled(enabled);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.myAlternateCollectionRenderers[0].isEnabled();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)o).getState());
    }

    public void addListener(NodeRendererSettingsListener listener2, Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    public Element getState() {
        Element element = new Element("state");
        if (this.myHexRenderer.isEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)HEX_VIEW_ENABLED, (String)"true");
        }
        if (!this.areAlternateCollectionViewsEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED, (String)"false");
        }
        try {
            this.addRendererIfNotDefault(this.myToStringRenderer, element);
            this.addRendererIfNotDefault(this.myClassRenderer, element);
            this.addRendererIfNotDefault(this.myPrimitiveRenderer, element);
            if (this.myCustomRenderers.getRendererCount() > 0) {
                Element custom = new Element(CUSTOM_RENDERERS_TAG_NAME);
                element.addContent(custom);
                this.myCustomRenderers.writeExternal(custom);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    private void addRendererIfNotDefault(@NotNull Renderer renderer, @NotNull Element to) {
        Element element;
        if (renderer == null) {
            NodeRendererSettings.$$$reportNull$$$0(0);
        }
        if (to == null) {
            NodeRendererSettings.$$$reportNull$$$0(1);
        }
        if ((element = this.writeRenderer(renderer)).getContentSize() == 0 && element.getAttributes().size() <= 1) {
            return;
        }
        to.addContent(element);
    }

    public void loadState(@NotNull Element root) {
        String alternativeEnabled;
        String hexEnabled;
        if (root == null) {
            NodeRendererSettings.$$$reportNull$$$0(2);
        }
        if ((hexEnabled = JDOMExternalizerUtil.readField((Element)root, (String)HEX_VIEW_ENABLED)) != null) {
            this.myHexRenderer.setEnabled(Boolean.parseBoolean(hexEnabled));
        }
        if ((alternativeEnabled = JDOMExternalizerUtil.readField((Element)root, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED)) != null) {
            this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(alternativeEnabled));
        }
        for (Element elem : root.getChildren(RENDERER_TAG)) {
            String id = elem.getAttributeValue(RENDERER_ID);
            if (id == null) continue;
            try {
                switch (id) {
                    case "ToStringRenderer": {
                        this.myToStringRenderer.readExternal(elem);
                        if (this.myToStringRenderer.isEnabled()) break;
                        this.myToStringRenderer.setEnabled(true);
                        this.myToStringRenderer.setOnDemand(true);
                        break;
                    }
                    case "ClassRenderer": {
                        this.myClassRenderer.readExternal(elem);
                        break;
                    }
                    case "PrimitiveRenderer": {
                        this.myPrimitiveRenderer.readExternal(elem);
                    }
                }
            }
            catch (InvalidDataException invalidDataException) {}
        }
        Element custom = root.getChild(CUSTOM_RENDERERS_TAG_NAME);
        if (custom != null) {
            this.myCustomRenderers.readExternal(custom);
        }
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.myCustomRenderers;
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.myPrimitiveRenderer;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.myArrayRenderer;
    }

    public ClassRenderer getClassRenderer() {
        return this.myClassRenderer;
    }

    public HexRenderer getHexRenderer() {
        return this.myHexRenderer;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.myToStringRenderer;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.myAlternateCollectionRenderers;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers(Project project) {
        ArrayList<NodeRenderer> allRenderers = new ArrayList<NodeRenderer>();
        this.myCustomRenderers.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)renderer -> {
            allRenderers.add((NodeRenderer)renderer);
            return true;
        }));
        if (Registry.is((String)"debugger.renderers.annotations")) {
            this.addAnnotationRenderers(allRenderers, project);
        }
        CompoundRendererProvider.EP_NAME.getExtensionList().stream().filter(provider -> provider.isApplicable(project)).map(provider -> provider.createRenderer()).forEach(allRenderers::add);
        allRenderers.addAll(NodeRenderer.EP_NAME.getExtensionList());
        allRenderers.add(this.myHexRenderer);
        allRenderers.add(this.myPrimitiveRenderer);
        Collections.addAll(allRenderers, this.myAlternateCollectionRenderers);
        allRenderers.add(this.myToStringRenderer);
        allRenderers.add(this.myArrayRenderer);
        allRenderers.add(this.myClassRenderer);
        return allRenderers;
    }

    private void addAnnotationRenderers(List<NodeRenderer> renderers, Project project) {
        try {
            List<CompoundReferenceRenderer> annotationRenderers = NodeRendererSettings.visitAnnotatedElements(List.of(Debug.Renderer.class.getName().replace("$", ".")), project, (e, annotation) -> {
                if (e instanceof PsiClass) {
                    PsiClass cls = (PsiClass)e;
                    String text = NodeRendererSettings.getAttributeValue(annotation, "text");
                    LabelRenderer labelRenderer = StringUtil.isEmpty((String)text) ? null : NodeRendererSettings.createLabelRenderer(null, text);
                    String childrenArray = NodeRendererSettings.getAttributeValue(annotation, "childrenArray");
                    String isLeaf = NodeRendererSettings.getAttributeValue(annotation, "hasChildren");
                    ExpressionChildrenRenderer childrenRenderer = StringUtil.isEmpty((String)childrenArray) ? null : NodeRendererSettings.createExpressionArrayChildrenRenderer(childrenArray, isLeaf, this.myArrayRenderer);
                    CompoundReferenceRenderer renderer = this.createCompoundReferenceRenderer(cls.getQualifiedName(), cls.getQualifiedName(), labelRenderer, childrenRenderer);
                    renderer.setEnabled(true);
                    return renderer;
                }
                return null;
            }, PsiClass.class);
            renderers.addAll(annotationRenderers);
        }
        catch (ProcessCanceledException | IndexNotReadyException annotationRenderers) {
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
    }

    private static String getAttributeValue(PsiAnnotation annotation, String attribute) {
        Object res;
        PsiAnnotationMemberValue value = annotation.findAttributeValue(attribute);
        if (value == null) {
            return null;
        }
        if (value instanceof PsiExpression && (res = ExpressionUtils.computeConstantExpression((PsiExpression)((PsiExpression)value))) instanceof String) {
            return (String)res;
        }
        throw new IllegalStateException("Constant string expression expected, but was " + String.valueOf(value));
    }

    public Renderer readRenderer(Element root) throws InvalidDataException {
        if (root == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(root.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String rendererId = root.getAttributeValue(RENDERER_ID);
        if (rendererId == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        Renderer renderer = this.createRenderer(rendererId);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        renderer.readExternal(root);
        return renderer;
    }

    @NotNull
    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element root = new Element(RENDERER_TAG);
        if (renderer != null) {
            root.setAttribute(RENDERER_ID, renderer.getUniqueId());
            renderer.writeExternal(root);
        }
        Element element = root;
        if (element == null) {
            NodeRendererSettings.$$$reportNull$$$0(3);
        }
        return element;
    }

    public Renderer createRenderer(String rendererId) {
        if ("ClassRenderer".equals(rendererId)) {
            return this.myClassRenderer;
        }
        if ("ArrayRenderer".equals(rendererId)) {
            return this.myArrayRenderer;
        }
        if ("PrimitiveRenderer".equals(rendererId)) {
            return this.myPrimitiveRenderer;
        }
        if ("HexRenderer".equals(rendererId)) {
            return this.myHexRenderer;
        }
        if (rendererId.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (rendererId.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (rendererId.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (rendererId.equals("ToStringRenderer")) {
            return this.myToStringRenderer;
        }
        if (rendererId.equals("CompoundNodeRenderer") || rendererId.equals("CompoundTypeRenderer") || rendererId.equals(REFERENCE_RENDERER)) {
            CompoundReferenceRenderer renderer = this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
            renderer.setHasOverhead(true);
            return renderer;
        }
        return null;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String rendererName, @NonNls String className, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer renderer = new CompoundReferenceRenderer(this, rendererName, labelRenderer, childrenRenderer);
        renderer.setClassName(className);
        renderer.setIsApplicableChecker(type -> DebuggerUtilsAsync.instanceOf(type, renderer.getClassName()));
        return renderer;
    }

    private static ExpressionChildrenRenderer createExpressionArrayChildrenRenderer(String expressionText, String childrenExpandableText, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer renderer = NodeRendererSettings.createExpressionChildrenRenderer(expressionText, childrenExpandableText);
        renderer.setPredictedRenderer(arrayRenderer);
        return renderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String expressionText, @NonNls String childrenExpandableText) {
        ExpressionChildrenRenderer childrenRenderer = new ExpressionChildrenRenderer();
        childrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)JavaFileType.INSTANCE));
        if (childrenExpandableText != null) {
            childrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, childrenExpandableText, "", (FileType)JavaFileType.INSTANCE));
        }
        return childrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] expressions) {
        EnumerationChildrenRenderer childrenRenderer = new EnumerationChildrenRenderer();
        if (expressions != null && expressions.length > 0) {
            ArrayList<EnumerationChildrenRenderer.ChildInfo> childrenList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(expressions.length);
            for (String[] expression : expressions) {
                childrenList.add(new EnumerationChildrenRenderer.ChildInfo(expression[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression[1], "", (FileType)JavaFileType.INSTANCE), false));
            }
            childrenRenderer.setChildren(childrenList);
        }
        return childrenRenderer;
    }

    private static LabelRenderer createLabelRenderer(@NonNls @Nullable String prefix, @NonNls String expressionText) {
        LabelRenderer labelRenderer = new LabelRenderer();
        labelRenderer.setPrefix(prefix);
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)JavaFileType.INSTANCE));
        return labelRenderer;
    }

    static <T extends PsiModifierListOwner, R> List<R> visitAnnotatedElements(List<String> annotationFqns, Project project, BiFunction<? super PsiModifierListOwner, ? super PsiAnnotation, R> consumer, Class<? extends T> ... types) {
        if (types == null) {
            NodeRendererSettings.$$$reportNull$$$0(4);
        }
        return (List)ReadAction.nonBlocking(() -> {
            ArrayList result = new ArrayList();
            for (String annotationFqn : annotationFqns) {
                PsiClass annotationClass = JavaPsiFacade.getInstance((Project)project).findClass(annotationFqn, GlobalSearchScope.allScope((Project)project));
                if (annotationClass == null) continue;
                AnnotatedElementsSearch.searchElements((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.allScope((Project)project), (Class[])types).asIterable().forEach(owner -> {
                    Object element = consumer.apply((PsiModifierListOwner)owner, (PsiAnnotation)AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{annotationFqn}));
                    if (element != null) {
                        result.add(element);
                    }
                });
            }
            return result;
        }).executeSynchronously();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/NodeRendererSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/NodeRendererSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "writeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRendererIfNotDefault";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer,
    XValuePresentationProvider,
    OnDemandRenderer {
        private static final Key<Boolean> RENDERER_MUTED = Key.create((String)"RENDERER_MUTED");
        private static final Key<ValueDescriptorImpl> KEY_DESCRIPTOR = Key.create((String)"KEY_DESCRIPTOR");
        private static final Key<ValueDescriptorImpl> VALUE_DESCRIPTOR = Key.create((String)"VALUE_DESCRIPTOR");
        private final MyCachedEvaluator myKeyExpression = new MyCachedEvaluator();
        private final MyCachedEvaluator myValueExpression = new MyCachedEvaluator();

        private MapEntryLabelRenderer() {
            super("java.util.Map$Entry");
            this.myKeyExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)JavaFileType.INSTANCE));
            this.myValueExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)JavaFileType.INSTANCE));
        }

        @Override
        public String calcLabel(final ValueDescriptor descriptor, EvaluationContext evaluationContext, final DescriptorLabelListener listener2) throws EvaluateException {
            if (!this.isShowValue(descriptor, evaluationContext)) {
                descriptor.putUserData(RENDERER_MUTED, true);
                return "";
            }
            DescriptorLabelListener customListener = new DescriptorLabelListener(){

                @Override
                public void labelChanged() {
                    descriptor.setValueLabel(MapEntryLabelRenderer.calcMapEntryLabel(descriptor));
                    listener2.labelChanged();
                }
            };
            this.calcExpression(evaluationContext, descriptor, this.myKeyExpression, customListener, KEY_DESCRIPTOR);
            this.calcExpression(evaluationContext, descriptor, this.myValueExpression, customListener, VALUE_DESCRIPTOR);
            return MapEntryLabelRenderer.calcMapEntryLabel(descriptor);
        }

        private static String calcMapEntryLabel(ValueDescriptor descriptor) {
            String keyLabel = MapEntryLabelRenderer.calcDescriptorLabel((ValueDescriptorImpl)descriptor.getUserData(KEY_DESCRIPTOR));
            String valueLabel = MapEntryLabelRenderer.calcDescriptorLabel((ValueDescriptorImpl)descriptor.getUserData(VALUE_DESCRIPTOR));
            return keyLabel + " -> " + valueLabel;
        }

        private static String calcDescriptorLabel(@Nullable ValueDescriptorImpl descriptor) {
            if (descriptor == null) {
                return "null";
            }
            return descriptor.getValueLabel();
        }

        private void calcExpression(EvaluationContext evaluationContext, ValueDescriptor descriptor, MyCachedEvaluator evaluator, DescriptorLabelListener listener2, Key<ValueDescriptorImpl> key) throws EvaluateException {
            Value eval = this.doEval(evaluationContext, descriptor.getValue(), evaluator);
            if (eval == null) {
                descriptor.putUserData(key, null);
                return;
            }
            WatchItemDescriptor evalDescriptor = new WatchItemDescriptor(this, evaluationContext.getProject(), evaluator.getReferenceExpression(), eval, (EvaluationContextImpl)evaluationContext){

                @Override
                public void updateRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
                    this.updateRepresentationNoNotify(context, labelListener);
                }
            };
            evalDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, listener2);
            descriptor.putUserData(key, evalDescriptor);
        }

        @Override
        public String getUniqueId() {
            return "MapEntry renderer";
        }

        @Override
        @NotNull
        public String getLinkText() {
            String string = JavaDebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0]);
            if (string == null) {
                MapEntryLabelRenderer.$$$reportNull$$$0(0);
            }
            return string;
        }

        private Value doEval(EvaluationContext evaluationContext, Value originalValue, MyCachedEvaluator cachedEvaluator) throws EvaluateException {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            if (originalValue == null) {
                return null;
            }
            try {
                ExpressionEvaluator evaluator = cachedEvaluator.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContextImpl thisEvaluationContext = ((EvaluationContextImpl)evaluationContext).createEvaluationContext(originalValue);
                XEvaluationOrigin.setOrigin((UserDataHolder)thisEvaluationContext, (XEvaluationOrigin)XEvaluationOrigin.RENDERER);
                return evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            }
            catch (EvaluateException ex) {
                throw new EvaluateException(JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        @NotNull
        public XValuePresentation getPresentation(ValueDescriptorImpl descriptor) {
            final boolean inCollection = descriptor instanceof ArrayElementDescriptor;
            return new JavaValuePresentation(this, descriptor){

                @Override
                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
                    if (renderer == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (this.isMuted()) {
                        return;
                    }
                    this.renderDescriptor(KEY_DESCRIPTOR, renderer, node);
                    renderer.renderComment(" -> ");
                    this.renderDescriptor(VALUE_DESCRIPTOR, renderer, node);
                }

                private void renderDescriptor(Key<ValueDescriptorImpl> key, @NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
                    ValueDescriptorImpl valueDescriptor;
                    if (renderer == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if ((valueDescriptor = this.myValueDescriptor.getUserData(key)) != null) {
                        String type = valueDescriptor.getIdLabel();
                        if (inCollection && type != null) {
                            renderer.renderComment("{" + type + "} ");
                        }
                        new JavaValuePresentation(valueDescriptor).renderValue(renderer, node);
                    } else {
                        renderer.renderValue("null");
                    }
                }

                @Override
                @NotNull
                public String getSeparator() {
                    String string = inCollection ? "" : super.getSeparator();
                    if (string == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public boolean isShowName() {
                    return !inCollection;
                }

                @Override
                @Nullable
                public String getType() {
                    return inCollection && !this.isMuted() ? null : super.getType();
                }

                private boolean isMuted() {
                    return this.myValueDescriptor.getUserData(RENDERER_MUTED) != null && !OnDemandRenderer.isCalculated(this.myValueDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "renderer";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/debugger/settings/NodeRendererSettings$MapEntryLabelRenderer$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/debugger/settings/NodeRendererSettings$MapEntryLabelRenderer$3";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSeparator";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "renderValue";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "renderDescriptor";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/NodeRendererSettings$MapEntryLabelRenderer", "getLinkText"));
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project) throws EvaluateException {
                return super.getEvaluator(project);
            }
        }
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        ListObjectRenderer(NodeRendererSettings rendererSettings, ArrayRenderer arrayRenderer) {
            super(rendererSettings, "List", NodeRendererSettings.createLabelRenderer(" size = ", "size()"), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
            this.setIsApplicableChecker(type -> DebuggerUtilsAsync.instanceOf(type, this.getClassName()));
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
            LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)node.getDescriptor()).getIndex() + ")", node, context);
            }
            catch (IncorrectOperationException e) {
                return super.getChildValueExpression(node, context);
            }
        }
    }
}

