/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

@State(name="TraceSettings", storages={@Storage(value="debugger.xml")}, category=SettingsCategory.TOOLS)
public class TraceSettings
implements PersistentStateComponent<TraceSettings> {
    private ClassFilter[] myClassFilters;
    private ClassFilter[] myClassExclusionFilters;

    @XCollection(propertyElementName="class-filters")
    public final ClassFilter[] getClassFilters() {
        return this.myClassFilters != null ? this.myClassFilters : ClassFilter.EMPTY_ARRAY;
    }

    public final boolean setClassFilters(ClassFilter[] classFilters) {
        boolean changed = !TraceSettings.filtersEqual(this.myClassFilters, classFilters);
        this.myClassFilters = classFilters;
        return changed;
    }

    protected static boolean filtersEqual(Object[] a, Object[] b) {
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return true;
        }
        return Arrays.equals(a, b);
    }

    @XCollection(propertyElementName="class-exclusion-filters")
    public ClassFilter[] getClassExclusionFilters() {
        return this.myClassExclusionFilters != null ? this.myClassExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public boolean setClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        boolean changed = !TraceSettings.filtersEqual(this.myClassExclusionFilters, classExclusionFilters);
        this.myClassExclusionFilters = classExclusionFilters;
        return changed;
    }

    public static TraceSettings getInstance() {
        return (TraceSettings)ApplicationManager.getApplication().getService(TraceSettings.class);
    }

    public void loadState(@NotNull TraceSettings state) {
        if (state == null) {
            TraceSettings.$$$reportNull$$$0(0);
        }
        this.myClassFilters = state.getClassFilters();
        this.myClassExclusionFilters = state.getClassExclusionFilters();
    }

    public TraceSettings getState() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/settings/TraceSettings", "loadState"));
    }
}

