/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationPanel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlternativeSourceNotificationProvider
implements EditorNotificationProvider {
    private static final Key<Boolean> FILE_PROCESSED_KEY = Key.create((String)"AlternativeSourceCheckDone");

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Location location;
        XDebugSession session;
        if (project == null) {
            AlternativeSourceNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AlternativeSourceNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        DebuggerSession javaSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        XDebugSession xDebugSession = session = javaSession != null ? javaSession.getXDebugSession() : null;
        if (session == null) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        XSourcePosition position = session.getCurrentPosition();
        if (position == null || !file.equals(position.getFile())) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        PsiClass baseClass = classes[0];
        String name = baseClass.getQualifiedName();
        if (name == null) {
            return null;
        }
        Object[] altClasses = JavaPsiFacade.getInstance((Project)project).findClasses(name, javaSession.getSearchScope());
        if (altClasses.length == 0) {
            altClasses = JavaPsiFacade.getInstance((Project)project).findClasses(name, GlobalSearchScope.allScope((Project)project));
        }
        AlternativeSourceNotificationProvider.setFileProcessed(file, true);
        HashSet uniqClasses = ContainerUtil.newHashSet((Object[])altClasses);
        if (uniqClasses.size() <= 1) {
            return null;
        }
        List otherClasses = ContainerUtil.filter((Collection)uniqClasses, cls -> !cls.equals((Object)baseClass) && !cls.getNavigationElement().equals((Object)baseClass));
        List allClasses = ContainerUtil.prepend((List)otherClasses, (Object[])new PsiClass[]{baseClass});
        AlternativeSourceNotificationPanel.AlternativeSourceElement[] elems = (AlternativeSourceNotificationPanel.AlternativeSourceElement[])ContainerUtil.map2Array((Collection)allClasses, AlternativeSourceNotificationPanel.AlternativeSourceElement.class, psiClass -> new AlternativeSourceNotificationPanel.AlternativeSourceElement(psiClass.getNavigationElement()));
        String locationDeclName = null;
        XStackFrame frame = session.getCurrentStackFrame();
        if (frame instanceof JavaStackFrame && (location = ((JavaStackFrame)frame).getDescriptor().getLocation()) != null) {
            locationDeclName = location.declaringType().name();
        }
        String finalLocationDeclName = locationDeclName;
        return fileEditor -> new AlternativeSourceNotificationPanel((FileEditor)fileEditor, project, JavaDebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{name}), file, elems, finalLocationDeclName);
    }

    public static boolean isFileProcessed(VirtualFile file) {
        return FILE_PROCESSED_KEY.get((UserDataHolder)file) != null;
    }

    public static void setFileProcessed(VirtualFile file, boolean value) {
        FILE_PROCESSED_KEY.set((UserDataHolder)file, (Object)(value ? Boolean.TRUE : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/AlternativeSourceNotificationProvider";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

