/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.impl.hotswap.JvmHotSwapInDebugSessionEnablerKt;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapStatusListener;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.rpc.HotSwapSource;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatistics;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatusNotificationManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.util.JpsPathUtil;

public final class HotSwapUIImpl
extends HotSwapUI {
    public static final Key<Boolean> SKIP_HOT_SWAP_KEY = KeyWithDefaultValue.create((String)"skip_hotswap_after_this_compilation", (Object)false);
    private static final Key<HotSwapStatusListener> HOT_SWAP_CALLBACK_KEY = Key.create((String)"hot_swap_callback");
    private final List<HotSwapVetoableListener> myListeners;
    private boolean myAskBeforeHotswap;
    private final Project myProject;

    public HotSwapUIImpl(@NotNull Project project) {
        if (project == null) {
            HotSwapUIImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAskBeforeHotswap = true;
        this.myProject = project;
    }

    @Override
    public void addListener(HotSwapVetoableListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(HotSwapVetoableListener listener2) {
        this.myListeners.remove(listener2);
    }

    private static boolean shouldDisplayHangWarning(DebuggerSettings settings, List<DebuggerSession> sessions) {
        if (!settings.HOTSWAP_HANG_WARNING_ENABLED) {
            return false;
        }
        return ContainerUtil.exists(sessions, DebuggerSession::isPaused);
    }

    private void hotSwapSessions(@NotNull List<DebuggerSession> sessions, @Nullable Map<String, Collection<String>> generatedPaths, @Nullable NotNullLazyValue<List<String>> outputPaths, @Nullable HotSwapStatusListener callback, boolean isAutoRun) {
        if (sessions == null) {
            HotSwapUIImpl.$$$reportNull$$$0(1);
        }
        boolean shouldAskBeforeHotswap = this.myAskBeforeHotswap;
        this.myAskBeforeHotswap = true;
        DebuggerSettings settings = DebuggerSettings.getInstance();
        String runHotswap = settings.RUN_HOTSWAP_AFTER_COMPILE;
        boolean shouldDisplayHangWarning = HotSwapUIImpl.shouldDisplayHangWarning(settings, sessions);
        HotSwapStatusListener statusListener = HotSwapUIImpl.makeNullSafe(callback);
        if (shouldAskBeforeHotswap && "RunHotswapNever".equals(runHotswap)) {
            statusListener.onCancel(sessions);
            return;
        }
        if (isAutoRun && shouldAskBeforeHotswap && "RunHotswapAsk".equals(runHotswap)) {
            statusListener.onCancel(sessions);
            return;
        }
        ArrayList<DebuggerSession> toScan = new ArrayList<DebuggerSession>(sessions);
        ArrayList<DebuggerSession> toUseGenerated = new ArrayList<DebuggerSession>();
        if (generatedPaths != null) {
            toScan.clear();
            for (DebuggerSession session : sessions) {
                if (session.isModifiedClassesScanRequired()) {
                    toScan.add(session);
                } else {
                    toUseGenerated.add(session);
                }
                session.setModifiedClassesScanRequired(false);
            }
        }
        HotSwapProgressImpl findClassesProgress = !toScan.isEmpty() ? this.createHotSwapProgress(statusListener, sessions) : null;
        HotSwapProgressImpl outputPathsProgress = !toUseGenerated.isEmpty() && outputPaths != null ? this.createHotSwapProgress(statusListener, sessions) : null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            HashMap<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
            if (!toUseGenerated.isEmpty()) {
                modifiedClasses.putAll(HotSwapManager.findModifiedClasses(toUseGenerated, generatedPaths));
                if (outputPathsProgress != null) {
                    HotSwapUIImpl.scanForModifiedClassesWithProgress(toUseGenerated, outputPaths, outputPathsProgress).forEach((session, map3) -> modifiedClasses.merge((DebuggerSession)session, (Map<String, HotSwapFile>)map3, (map1, map2) -> {
                        map1.putAll(map2);
                        return map1;
                    }));
                }
            }
            if (findClassesProgress != null) {
                modifiedClasses.putAll(HotSwapUIImpl.scanForModifiedClassesWithProgress(toScan, null, findClassesProgress));
            }
            if (modifiedClasses.isEmpty()) {
                if (!isAutoRun) {
                    String message = JavaDebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                    Notification notification = HotSwapProgressImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
                    HotSwapStatusNotificationManager.getInstance((Project)this.myProject).trackNotification(notification);
                    notification.notify(this.myProject);
                }
                HotSwapStatistics.logHotSwapStatus((Project)this.myProject, (HotSwapStatistics.HotSwapStatus)HotSwapStatistics.HotSwapStatus.NO_CHANGES);
                statusListener.onNothingToReload(sessions);
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (shouldAskBeforeHotswap && !"RunHotswapAlways".equals(runHotswap)) {
                    RunHotswapDialog dialog = new RunHotswapDialog(this.myProject, sessions, shouldDisplayHangWarning);
                    if (!dialog.showAndGet()) {
                        for (DebuggerSession session : modifiedClasses.keySet()) {
                            session.setModifiedClassesScanRequired(true);
                        }
                        statusListener.onCancel(sessions);
                        return;
                    }
                    HotSwapStatistics.logHotSwapCalled((Project)this.myProject, (HotSwapSource)HotSwapSource.ON_REBUILD_ASK);
                    HashSet<DebuggerSession> toReload = new HashSet<DebuggerSession>(dialog.getSessionsToReload());
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        if (toReload.contains(session)) continue;
                        session.setModifiedClassesScanRequired(true);
                    }
                    modifiedClasses.keySet().retainAll(toReload);
                } else if (shouldDisplayHangWarning && !HotSwapUIImpl.confirmPossibleHang(settings)) {
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        session.setModifiedClassesScanRequired(true);
                    }
                    statusListener.onCancel(sessions);
                    return;
                }
                if (modifiedClasses.isEmpty()) {
                    return;
                }
                HotSwapProgressImpl progress = new HotSwapProgressImpl(this.myProject);
                if (modifiedClasses.size() == 1) {
                    progress.setSessionForActions((DebuggerSession)ContainerUtil.getFirstItem(modifiedClasses.keySet()));
                }
                progress.addProgressListener(HotSwapUIImpl.delegatingTo(statusListener, sessions, progress));
                ApplicationManager.getApplication().executeOnPooledThread(() -> HotSwapUIImpl.reloadModifiedClasses(modifiedClasses, progress));
            }, ModalityState.nonModal());
        });
    }

    private static HotSwapProgressImpl.HotSwapProgressListener delegatingTo(final HotSwapStatusListener statusListener, final @NotNull List<DebuggerSession> sessions, final HotSwapProgressImpl progress) {
        if (sessions == null) {
            HotSwapUIImpl.$$$reportNull$$$0(2);
        }
        return new HotSwapProgressImpl.HotSwapProgressListener(){

            @Override
            public void onCancel() {
                statusListener.onCancel(sessions);
            }

            @Override
            public void onFinish() {
                if (!progress.hasErrors()) {
                    HotSwapStatistics.logHotSwapStatus((Project)progress.getProject(), (HotSwapStatistics.HotSwapStatus)HotSwapStatistics.HotSwapStatus.SUCCESS);
                    statusListener.onSuccess(sessions);
                } else {
                    HotSwapStatistics.logHotSwapStatus((Project)progress.getProject(), (HotSwapStatistics.HotSwapStatus)HotSwapStatistics.HotSwapStatus.HOT_SWAP_FAILURE);
                    statusListener.onFailure(sessions);
                }
            }
        };
    }

    private static boolean confirmPossibleHang(@NotNull DebuggerSettings settings) {
        int answer;
        if (settings == null) {
            HotSwapUIImpl.$$$reportNull$$$0(3);
        }
        return (answer = Messages.showCheckboxMessageDialog((String)JavaDebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]), (String[])new String[]{JavaDebuggerBundle.message((String)"button.perform.reload.classes", (Object[])new Object[0]), JavaDebuggerBundle.message((String)"button.skip.reload.classes", (Object[])new Object[0])}, (String)UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getWarningIcon(), (exitCode, cb) -> {
            settings.HOTSWAP_HANG_WARNING_ENABLED = !cb.isSelected();
            return exitCode == 0 ? exitCode : 1;
        })) != 1;
    }

    @NotNull
    private HotSwapProgressImpl createHotSwapProgress(final @NotNull HotSwapStatusListener statusListener, final @NotNull List<DebuggerSession> sessions) {
        if (statusListener == null) {
            HotSwapUIImpl.$$$reportNull$$$0(4);
        }
        if (sessions == null) {
            HotSwapUIImpl.$$$reportNull$$$0(5);
        }
        HotSwapProgressImpl progress = new HotSwapProgressImpl(this.myProject);
        progress.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

            @Override
            public void onCancel() {
                statusListener.onCancel(sessions);
            }
        });
        HotSwapProgressImpl hotSwapProgressImpl = progress;
        if (hotSwapProgressImpl == null) {
            HotSwapUIImpl.$$$reportNull$$$0(6);
        }
        return hotSwapProgressImpl;
    }

    @NotNull
    private static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClassesWithProgress(@NotNull List<DebuggerSession> sessions, @Nullable NotNullLazyValue<List<String>> outputPaths, @NotNull HotSwapProgressImpl progress) {
        if (sessions == null) {
            HotSwapUIImpl.$$$reportNull$$$0(7);
        }
        if (progress == null) {
            HotSwapUIImpl.$$$reportNull$$$0(8);
        }
        Map map2 = (Map)ProgressManager.getInstance().runProcess(() -> {
            try {
                Map<DebuggerSession, Map<String, HotSwapFile>> map2 = HotSwapManager.scanForModifiedClasses(sessions, (NotNullLazyValue<? extends List<String>>)outputPaths, progress);
                return map2;
            }
            finally {
                progress.finished();
            }
        }, progress.getProgressIndicator());
        if (map2 == null) {
            HotSwapUIImpl.$$$reportNull$$$0(9);
        }
        return map2;
    }

    private static void reloadModifiedClasses(Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, HotSwapProgressImpl progress) {
        ProgressManager.getInstance().runProcess(() -> {
            HotSwapManager.reloadModifiedClasses(modifiedClasses, progress);
            progress.finished();
        }, progress.getProgressIndicator());
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap) {
        if (session == null) {
            HotSwapUIImpl.$$$reportNull$$$0(10);
        }
        this.reloadChangedClasses(session, compileBeforeHotswap, null);
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap, @Nullable HotSwapStatusListener callback) {
        if (session == null) {
            HotSwapUIImpl.$$$reportNull$$$0(11);
        }
        this.dontAskHotswapAfterThisCompilation();
        Project project = session.getProject();
        callback = HotSwapUIImpl.mergeCallbacksIfNeeded(callback, JvmHotSwapInDebugSessionEnablerKt.createHotSwapSessionListenerOrNull(session));
        if (compileBeforeHotswap) {
            ProjectTaskManagerImpl.putBuildOriginator((Project)project, this.getClass());
            ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)project);
            if (callback == null) {
                projectTaskManager.buildAllModules();
            } else {
                ProjectTask buildProjectTask = projectTaskManager.createAllModulesBuildTask(true, project);
                projectTaskManager.run(HotSwapUIImpl.createContext(callback), buildProjectTask);
            }
        } else if (session.isAttached()) {
            this.hotSwapSessions(Collections.singletonList(session), null, null, callback, false);
        } else if (callback != null) {
            callback.onFailure(List.of(session));
        }
    }

    @Override
    public void compileAndReload(@NotNull DebuggerSession session, VirtualFile ... files) {
        if (session == null) {
            HotSwapUIImpl.$$$reportNull$$$0(12);
        }
        if (files == null) {
            HotSwapUIImpl.$$$reportNull$$$0(13);
        }
        this.dontAskHotswapAfterThisCompilation();
        Project project = session.getProject();
        ProjectTaskManagerImpl.putBuildOriginator((Project)project, this.getClass());
        HotSwapStatusListener callback = JvmHotSwapInDebugSessionEnablerKt.createHotSwapSessionListenerOrNull(session);
        if (callback == null) {
            ProjectTaskManager.getInstance((Project)project).compile(files);
        } else {
            ProjectTaskManagerImpl taskManager = (ProjectTaskManagerImpl)ProjectTaskManager.getInstance((Project)project);
            ProjectTask task = (ProjectTask)ReadAction.compute(() -> taskManager.createModulesFilesTask(files));
            taskManager.run(HotSwapUIImpl.createContext(callback), task);
        }
    }

    private static ProjectTaskContext createContext(@NotNull HotSwapStatusListener callback) {
        if (callback == null) {
            HotSwapUIImpl.$$$reportNull$$$0(14);
        }
        return new ProjectTaskContext((Object)callback).withUserData(HOT_SWAP_CALLBACK_KEY, (Object)callback);
    }

    @Nullable
    private static HotSwapStatusListener mergeCallbacksIfNeeded(final @Nullable HotSwapStatusListener callback1, final @Nullable HotSwapStatusListener callback2) {
        if (callback1 == null) {
            return callback2;
        }
        if (callback2 == null) {
            return callback1;
        }
        return new HotSwapStatusListener(){

            @Override
            public void onSuccess(@NotNull List<DebuggerSession> sessions) {
                if (sessions == null) {
                    3.$$$reportNull$$$0(0);
                }
                callback1.onSuccess(sessions);
                callback2.onSuccess(sessions);
            }

            @Override
            public void onNothingToReload(List<DebuggerSession> sessions) {
                callback1.onNothingToReload(sessions);
                callback2.onNothingToReload(sessions);
            }

            @Override
            public void onCancel(List<DebuggerSession> sessions) {
                callback1.onCancel(sessions);
                callback2.onCancel(sessions);
            }

            @Override
            public void onFailure(List<DebuggerSession> sessions) {
                callback1.onFailure(sessions);
                callback2.onFailure(sessions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/debugger/ui/HotSwapUIImpl$3", "onSuccess"));
            }
        };
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.myAskBeforeHotswap = false;
    }

    public static boolean canHotSwap(@NotNull DebuggerSession debuggerSession) {
        if (debuggerSession == null) {
            HotSwapUIImpl.$$$reportNull$$$0(15);
        }
        return debuggerSession.isAttached() && debuggerSession.getProcess().canRedefineClasses();
    }

    @NotNull
    private static @Unmodifiable List<DebuggerSession> getHotSwappableDebugSessions(Project project) {
        List list = ContainerUtil.filter(DebuggerManagerEx.getInstanceEx(project).getSessions(), HotSwapUIImpl::canHotSwap);
        if (list == null) {
            HotSwapUIImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static HotSwapStatusListener makeNullSafe(final HotSwapStatusListener listener2) {
        return new HotSwapStatusListener(){

            @Override
            public void onCancel(List<DebuggerSession> sessions) {
                if (listener2 != null) {
                    listener2.onCancel(sessions);
                }
            }

            @Override
            public void onSuccess(List<DebuggerSession> sessions) {
                if (listener2 != null) {
                    listener2.onSuccess(sessions);
                }
            }

            @Override
            public void onNothingToReload(List<DebuggerSession> sessions) {
                if (listener2 != null) {
                    listener2.onNothingToReload(sessions);
                }
            }

            @Override
            public void onFailure(List<DebuggerSession> sessions) {
                if (listener2 != null) {
                    listener2.onFailure(sessions);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusListener";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHotSwapProgress";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForModifiedClassesWithProgress";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHotSwappableDebugSessions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hotSwapSessions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "delegatingTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "confirmPossibleHang";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHotSwapProgress";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scanForModifiedClassesWithProgress";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reloadChangedClasses";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compileAndReload";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canHotSwap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 16 -> new IllegalStateException(string);
        };
    }

    public static class HotSwapDebuggerManagerListener
    implements DebuggerManagerListener {
        @NotNull
        private final Project myProject;
        private MessageBusConnection myConn;

        public HotSwapDebuggerManagerListener(@NotNull Project project) {
            if (project == null) {
                HotSwapDebuggerManagerListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myConn = null;
        }

        @Override
        public void sessionAttached(DebuggerSession session) {
            if (this.myConn == null) {
                this.myConn = this.myProject.getMessageBus().connect();
                this.myConn.subscribe(ProjectTaskListener.TOPIC, (Object)new MyCompilationStatusListener(this.myProject));
            }
        }

        @Override
        public void sessionDetached(DebuggerSession session) {
            if (!HotSwapUIImpl.getHotSwappableDebugSessions(this.myProject).isEmpty()) {
                return;
            }
            MessageBusConnection conn = this.myConn;
            if (conn != null) {
                Disposer.dispose((Disposable)conn);
                this.myConn = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/HotSwapUIImpl$HotSwapDebuggerManagerListener", "<init>"));
        }
    }

    private static final class MyCompilationStatusListener
    implements ProjectTaskListener {
        private final Set<File> myOutputRoots;
        private final Project myProject;

        private MyCompilationStatusListener(Project project) {
            this.myProject = project;
            this.myOutputRoots = FileCollectionFactory.createCanonicalFileSet();
            for (String path : CompilerPaths.getOutputPaths((Module[])ModuleManager.getInstance((Project)this.myProject).getModules())) {
                this.myOutputRoots.add(new File(path));
            }
        }

        public void started(@NotNull ProjectTaskContext context) {
            if (context == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(0);
            }
            context.setCollectionOfGeneratedFilesEnabled(true);
            this.ensureListenerIsInstalled(context);
        }

        private void ensureListenerIsInstalled(@NotNull ProjectTaskContext context) {
            HotSwapStatusListener callback;
            if (context == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(1);
            }
            if ((callback = (HotSwapStatusListener)context.getUserData(HOT_SWAP_CALLBACK_KEY)) != null) {
                return;
            }
            HotSwapUIImpl instance = (HotSwapUIImpl)HotSwapUI.getInstance(this.myProject);
            boolean alwaysDoHotSwapOnRebuild = instance.myAskBeforeHotswap && "RunHotswapAlways".equals(DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE);
            List<DebuggerSession> sessions = HotSwapUIImpl.getHotSwappableDebugSessions(this.myProject);
            for (DebuggerSession session : sessions) {
                HotSwapStatusListener listener2 = JvmHotSwapInDebugSessionEnablerKt.createHotSwapSessionListenerOrNull(session);
                if (listener2 == null) continue;
                context.putUserData(HOT_SWAP_CALLBACK_KEY, (Object)listener2);
                if (alwaysDoHotSwapOnRebuild) {
                    HotSwapStatistics.logHotSwapCalled((Project)this.myProject, (HotSwapSource)HotSwapSource.ON_REBUILD_AUTO);
                }
                return;
            }
        }

        public void finished(@NotNull ProjectTaskManager.Result result) {
            if (result == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(2);
            }
            ProjectTaskContext context = result.getContext();
            HotSwapStatusListener callback = (HotSwapStatusListener)context.getUserData(HOT_SWAP_CALLBACK_KEY);
            if (this.myProject.isDisposed()) {
                MyCompilationStatusListener.notifyCancelled(callback, Collections.emptyList());
                return;
            }
            List<DebuggerSession> sessions = HotSwapUIImpl.getHotSwappableDebugSessions(this.myProject);
            if (result.hasErrors()) {
                if (callback != null) {
                    HotSwapStatistics.logHotSwapStatus((Project)this.myProject, (HotSwapStatistics.HotSwapStatus)HotSwapStatistics.HotSwapStatus.COMPILATION_FAILURE);
                    callback.onFailure(sessions);
                }
                return;
            }
            if (!MyCompilationStatusListener.hasCompilationResults(result) || result.isAborted() || ((Boolean)SKIP_HOT_SWAP_KEY.getRequired((UserDataHolder)context)).booleanValue() || sessions.isEmpty()) {
                MyCompilationStatusListener.notifyCancelled(callback, sessions);
                return;
            }
            HotSwapUIImpl instance = (HotSwapUIImpl)HotSwapUI.getInstance(this.myProject);
            for (HotSwapVetoableListener listener2 : instance.myListeners) {
                if (listener2.shouldHotSwap(context)) continue;
                MyCompilationStatusListener.notifyCancelled(callback, sessions);
                return;
            }
            Map<String, Collection<String>> generatedPaths = this.collectGeneratedPaths(context);
            NotNullLazyValue outputRoots = context.getDirtyOutputPaths().map(paths -> NotNullLazyValue.createValue(() -> paths)).orElse(null);
            instance.hotSwapSessions(sessions, generatedPaths, (NotNullLazyValue<List<String>>)outputRoots, callback, context.isAutoRun());
        }

        private static void notifyCancelled(@Nullable HotSwapStatusListener callback, List<DebuggerSession> sessions) {
            if (callback != null) {
                callback.onCancel(sessions);
            }
        }

        @NotNull
        private Map<String, Collection<String>> collectGeneratedPaths(ProjectTaskContext context) {
            Collection generatedFilesRoots = context.getGeneratedFilesRoots();
            if (generatedFilesRoots.isEmpty()) {
                Map<String, Collection<String>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    MyCompilationStatusListener.$$$reportNull$$$0(3);
                }
                return map2;
            }
            HashMap<String, Collection<String>> generatedPaths = new HashMap<String, Collection<String>>();
            for (String outputRoot : generatedFilesRoots) {
                List relativePaths;
                if (!JpsPathUtil.isUnder(this.myOutputRoots, (File)new File(outputRoot)) || (relativePaths = ContainerUtil.filter((Collection)context.getGeneratedFilesRelativePaths(outputRoot), relativePath -> StringUtil.endsWith((CharSequence)relativePath, (CharSequence)".class"))).isEmpty()) continue;
                generatedPaths.put(outputRoot, relativePaths);
            }
            HashMap<String, Collection<String>> hashMap = generatedPaths;
            if (hashMap == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(4);
            }
            return hashMap;
        }

        private static boolean hasCompilationResults(@NotNull ProjectTaskManager.Result result) {
            if (result == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(5);
            }
            return result.anyTaskMatches((task, state) -> task instanceof ModuleBuildTask && !state.isFailed() && !state.isSkipped());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/HotSwapUIImpl$MyCompilationStatusListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/HotSwapUIImpl$MyCompilationStatusListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectGeneratedPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "started";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "ensureListenerIsInstalled";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "finished";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasCompilationResults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

